/*
 * Decompiled with CFR 0.152.
 */
package pty.smc.test;

import goblin.Taxon;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import nuts.lang.StringUtils;
import pty.io.HGDPDataset;

public class PhylipParser {
    private double[][] observations;
    private ArrayList<Taxon> names;
    private int nleaves;
    private int nsites;

    public PhylipParser(String filename) {
        ArrayList obs = new ArrayList();
        this.names = new ArrayList();
        this.nsites = -1;
        try {
            String s;
            BufferedReader br = new BufferedReader(new FileReader(filename));
            int linenum = 0;
            while ((s = br.readLine()) != null) {
                ArrayList<Double> currentLine = new ArrayList<Double>();
                obs.add(currentLine);
                if (HGDPDataset.PHYLIP_CONTENT_LINE_PATTERN.matcher(s).matches()) {
                    String name = StringUtils.selectFirstRegex(HGDPDataset.POPULATION_PATTERN, s);
                    this.names.add(new Taxon(name));
                    String sites = StringUtils.selectFirstRegex(HGDPDataset.SITE_PATTERN, s);
                    String[] siteValues = sites.split("\\s");
                    if (this.nsites != -1 && this.nsites != siteValues.length) {
                        System.err.println("Inconsistent number of sites in file " + filename);
                        System.exit(1);
                    } else {
                        this.nsites = siteValues.length;
                    }
                    for (String siteValue : siteValues) {
                        currentLine.add(Double.parseDouble(siteValue));
                    }
                }
                ++linenum;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.nleaves = obs.size();
        this.observations = new double[this.nleaves][this.nsites];
        for (int i = 0; i < this.nleaves; ++i) {
            for (int j = 0; j < this.nsites; ++j) {
                this.observations[i][j] = (Double)((List)obs.get(i)).get(j);
            }
        }
    }

    public String toString() {
        String out = "";
        for (int i = 0; i < this.nleaves; ++i) {
            for (int j = 0; j < this.nsites; ++j) {
                out = out + this.observations[i][j] + "\t";
            }
            out = out + "\n";
        }
        return out;
    }

    public int getNumberOfLeaves() {
        return this.nleaves;
    }

    public int getNumberofSites() {
        return this.nsites;
    }

    public double[][] getDoubleObservations() {
        return this.observations;
    }

    public int[][] getObservations() {
        int[][] result = new int[this.observations.length][];
        for (int i = 0; i < this.observations.length; ++i) {
            result[i] = new int[this.observations[i].length];
            for (int j = 0; j < result[i].length; ++j) {
                result[i][j] = (int)this.observations[i][j];
            }
        }
        return result;
    }

    public ArrayList<Taxon> getLeafNames() {
        return this.names;
    }

    public static void main(String[] args) {
        PhylipParser p = new PhylipParser(args[0]);
        System.out.println(p.toString());
    }
}

