/*
 * Decompiled with CFR 0.152.
 */
package pty.smc.test;

import goblin.Taxon;
import java.util.Random;
import java.util.Set;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import pty.eval.SymmetricDiff;
import pty.smc.PartialCoalescentState;
import pty.smc.ParticleFilter;
import pty.smc.PriorPostKernel;

public class SymmetryTest {
    public static final int N = 5;
    public static final Random rand = new Random(1L);

    public static void main(String[] args) {
        ParticleFilter.ParticleMapperProcessor<PartialCoalescentState, Set<Set<Taxon>>> mbr = SymmetricDiff.createCladeProcessor();
        PartialCoalescentState pcs = SymmetryTest.getInitState(10, 10);
        PriorPostKernel kernel = new PriorPostKernel(pcs);
        MeanHeight mh = new MeanHeight();
        ParticleFilter.bootstrapFilter(kernel, mbr, 5, rand);
        for (Set set : mbr.getCounter()) {
            System.out.println(SymmetricDiff.clades2arbre(set).deepToLispString() + "\t" + mbr.getCounter().getCount(set));
        }
    }

    public static PartialCoalescentState getInitState(int nLeaves, int nSites) {
        throw new RuntimeException();
    }

    public static class MeanHeight
    implements ParticleFilter.ParticleProcessor<PartialCoalescentState> {
        public final SummaryStatistics ss = new SummaryStatistics();
        public final SummaryStatistics temp = new SummaryStatistics();

        @Override
        public void process(PartialCoalescentState state, double weight) {
            this.ss.addValue(weight * state.topHeight());
            this.temp.addValue(weight);
        }
    }
}

