/*
 * Decompiled with CFR 0.152.
 */
package sage;

import fig.basic.Option;
import fig.prob.SampleUtils;
import goblin.CognateId;
import goblin.DerivationTree;
import goblin.HLParams;
import goblin.Taxon;
import java.util.ArrayList;
import java.util.Random;
import java.util.SortedSet;
import nuts.maxent.LabeledInstance;
import nuts.util.Arbre;
import nuts.util.Tree;
import pepper.Encodings;
import sage.FatContext;
import sage.LikelihoodModel;

public final class FatGenerator {
    @Option
    public int maxInsert = 1000;
    private final LikelihoodModel.FatLikelihoodModel model;
    private final int N;
    private final char B;
    private String topWord;
    private Taxon botLang;
    private Random rand;
    private int cInsLength = 0;
    private int cDelLength = 0;

    public Arbre<DerivationTree.DerivationNode> generate(Tree<String> languages, Random rand, CognateId id) {
        return this.generate(languages, null, rand, id);
    }

    private Arbre<DerivationTree.DerivationNode> generate(Tree<String> languages, String parent, Random rand, CognateId id) {
        String word;
        Taxon lang = new Taxon(languages.getLabel());
        DerivationTree.Derivation d = null;
        if (parent == null) {
            word = this.generateRoot(lang, rand);
        } else {
            d = this.generateEvolution(parent, rand, lang, id);
            word = d.getCurrentWord();
        }
        DerivationTree.DerivationNode derivNode = new DerivationTree.DerivationNode(lang, word, d);
        Arbre<DerivationTree.DerivationNode> result = new Arbre<DerivationTree.DerivationNode>(derivNode);
        for (Tree<String> childrenLang : languages.getChildren()) {
            result.addLeaves(this.generate(childrenLang, word, rand, id));
        }
        return result;
    }

    public FatGenerator(LikelihoodModel.FatLikelihoodModel model) {
        this.model = model;
        this.B = model.getEncodings().phoneId2Char(model.getEncodings().getBoundaryPhoneId());
        this.N = model.getEncodings().getNumberOfPhonemes();
    }

    private void resetInDelLengths() {
        this.cInsLength = 0;
        this.cDelLength = 0;
    }

    public String generateRoot(Taxon lang, Random rand) {
        StringBuilder result = new StringBuilder();
        result.append(this.B);
        for (int j = 0; j < this.maxInsert; ++j) {
            Encodings enc = this.model.getEncodings();
            int prev = enc.char2PhoneId(result.charAt(result.length() - 1));
            HLParams.HLContext context = new HLParams.HLContext(lang, enc, prev);
            FatContext fatContext = FatContext.baseFatContext(context);
            SortedSet<HLParams.HLOutcome> outcomes = this.model.outcomes(fatContext);
            double[] prs = new double[outcomes.size()];
            int i = 0;
            for (HLParams.HLOutcome out : outcomes) {
                prs[i++] = Math.exp(this.model.logLikelihood(new LabeledInstance<FatContext, HLParams.HLOutcome>(out, fatContext)));
            }
            int choice = SampleUtils.sampleMultinomial(rand, prs);
            if (choice == enc.getBoundaryPhoneId()) break;
            result.append(enc.phoneId2Char(choice));
        }
        return result.substring(1, result.length()).toString();
    }

    public DerivationTree.Derivation generateEvolution(String top, Random rand, Taxon botLang, CognateId id) {
        int i;
        this.topWord = this.B + top;
        this.botLang = botLang;
        this.rand = rand;
        this.cInsLength = 0;
        this.cDelLength = 0;
        ArrayList<Integer> ancestors = new ArrayList<Integer>();
        StringBuilder result = new StringBuilder();
        result.append(this.B);
        CharSequence insertions = this.generateIns(0, result, id);
        for (int i2 = 0; i2 < insertions.length(); ++i2) {
            ancestors.add(-1);
        }
        result.append(insertions);
        for (int topPos = 1; topPos < this.topWord.length(); ++topPos) {
            Character sub = this.generateSub(topPos, result, id);
            if (sub == null) continue;
            ancestors.add(topPos);
            result.append(sub);
            insertions = this.generateIns(topPos, result, id);
            result.append(insertions);
            for (i = 0; i < insertions.length(); ++i) {
                ancestors.add(-1);
            }
        }
        String generated = result.toString().substring(1, result.length());
        int[] convertedAncestors = new int[ancestors.size()];
        for (i = 0; i < ancestors.size(); ++i) {
            convertedAncestors[i] = (Integer)ancestors.get(i) == -1 ? -1 : (Integer)ancestors.get(i) - 1;
        }
        return new DerivationTree.Derivation(convertedAncestors, top, generated);
    }

    private Character generateSub(int topPosition, CharSequence generatedSoFar, CognateId id) {
        int draw = this.sample(topPosition, generatedSoFar, HLParams.ChoiceType.SUBDEL, id);
        if (draw == this.N) {
            ++this.cDelLength;
            return null;
        }
        this.resetInDelLengths();
        return Character.valueOf(this.model.getEncodings().phoneId2Char(draw));
    }

    private CharSequence generateIns(int topPosition, CharSequence generatedSoFar, CognateId id) {
        int draw;
        StringBuilder result = new StringBuilder();
        result.append(generatedSoFar);
        for (int i = 0; i < this.maxInsert && (draw = this.sample(topPosition, result, HLParams.ChoiceType.INS, id)) != this.N; ++i) {
            ++this.cInsLength;
            result.append(this.model.getEncodings().phoneId2Char(draw));
        }
        this.resetInDelLengths();
        String resultString = result.subSequence(generatedSoFar.length(), result.length()).toString();
        if (resultString.contains("#")) {
            throw new RuntimeException();
        }
        return resultString;
    }

    private int sample(int topPosition, CharSequence botPrefix, HLParams.ChoiceType type, CognateId id) {
        if (type != HLParams.ChoiceType.INS && type != HLParams.ChoiceType.SUBDEL) {
            throw new RuntimeException();
        }
        Encodings enc = this.model.getEncodings();
        int top = enc.char2PhoneId(this.topWord.charAt(topPosition));
        int prev = enc.char2PhoneId(botPrefix.charAt(botPrefix.length() - 1));
        HLParams.HLContext context = new HLParams.HLContext(this.botLang, enc, type, prev, top);
        FatContext fatContext = FatContext.fatContext(context, this.cInsLength, this.cDelLength, enc.charAt(this.topWord, topPosition - 1), enc.charAt(this.topWord, topPosition + 1), enc.charAt(botPrefix.toString(), botPrefix.length() - 2), id);
        ArrayList<HLParams.HLOutcome> outcomes = new ArrayList<HLParams.HLOutcome>(this.model.outcomes(fatContext));
        double[] prs = new double[outcomes.size()];
        for (int i = 0; i < outcomes.size(); ++i) {
            prs[i] = Math.exp(this.model.logLikelihood(new LabeledInstance<FatContext, HLParams.HLOutcome>((HLParams.HLOutcome)outcomes.get(i), fatContext)));
        }
        return ((HLParams.HLOutcome)outcomes.get((int)SampleUtils.sampleMultinomial((Random)this.rand, (double[])prs))).outcome;
    }
}

