/*
 * Decompiled with CFR 0.152.
 */
package sand;

import fig.basic.NumUtils;
import fig.prob.SampleUtils;
import java.util.Random;
import sand.TransitionKernel;

public class TruncatedKernel
implements TransitionKernel {
    private final TransitionKernel kernel;
    private final int maxStates;
    private final double[][] prs;

    public TruncatedKernel(TransitionKernel kernel, int maxStates) {
        this.kernel = kernel;
        this.maxStates = maxStates;
        this.prs = new double[this.nCurrentStates()][this.nNextStates()];
        for (int i = 0; i < this.nCurrentStates(); ++i) {
            for (int j = 0; j < this.nNextStates(); ++j) {
                this.prs[i][j] = kernel.pr(i, j);
            }
            NumUtils.normalize(this.prs[i]);
        }
    }

    @Override
    public int nCurrentStates() {
        return Math.min(this.maxStates, this.kernel.nCurrentStates());
    }

    @Override
    public int nNextStates() {
        return Math.min(this.maxStates, this.kernel.nNextStates());
    }

    @Override
    public double pr(int currentState, int nextState) {
        return this.prs[currentState][nextState];
    }

    @Override
    public int sample(int currentState, Random rand) {
        return SampleUtils.sampleMultinomial(rand, this.prs[currentState]);
    }
}

