/*
 * Decompiled with CFR 0.152.
 */
package scratch;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import ma.MSAPoset;
import nuts.io.IO;
import pty.UnrootedTree;

public class ConvertForTreeBase {
    public static void main(String[] args) {
        File baseDir = new File("/Users/bouchard/Documents/experiments/smc-phylo/state/remote");
        File dest = new File("/Users/bouchard/w/systematicbio2011-phylo-smc-paper/treebase");
        for (String method : Arrays.asList("MB", "SMC")) {
            String execName = method.equals("MB") ? "878" : "879";
            for (int i = 0; i < 10; ++i) {
                try {
                    for (File f : IO.ls(baseDir)) {
                        String curExecName = f.getName();
                        if (!curExecName.matches("gp" + execName + ".seg" + i + ".*")) continue;
                        List<File> aligns = IO.ls(new File(f, "output"), "msf");
                        if (aligns.size() != 1) {
                            throw new RuntimeException();
                        }
                        File align = aligns.get(0);
                        MSAPoset msa = MSAPoset.parseAlnOrMsfFormats(align);
                        System.out.println(msa);
                        List<File> trees = IO.ls(new File(f, "inferred-trees"), "newick");
                        if (trees.size() != 1) {
                            throw new RuntimeException();
                        }
                        System.out.println(UnrootedTree.fromNewick(trees.get(0)));
                        File destFASTA = new File(dest, method + i + ".fasta");
                        msa.toFASTA(destFASTA);
                        File destTree = new File(dest, method + i + ".newick");
                        IO.writeToDisk(destTree, IO.f2s(trees.get(0)));
                        System.out.println("\n\n-----\n\n");
                    }
                    continue;
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            }
        }
    }
}

