/*
 * Decompiled with CFR 0.152.
 */
package scratch;

import fig.basic.NumUtils;
import fig.prob.SampleUtils;
import java.util.Random;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;

public class TestRao {
    private static double[][] pot = new double[][]{{2000.0, 1.0}, {1.0, 400.0}};
    private static Random rand = new Random(1L);

    private static double[] p0given1(int s, boolean flipped) {
        int length = flipped ? pot[0].length : pot.length;
        double[] result = new double[length];
        for (int t = 0; t < length; ++t) {
            result[t] = flipped ? pot[s][t] : pot[t][s];
        }
        NumUtils.normalize(result);
        return result;
    }

    private static void resampleP0Given1(int[] state, boolean flipped) {
        double[] prs = TestRao.p0given1(flipped ? state[0] : state[1], flipped);
        int resampled = SampleUtils.sampleMultinomial(rand, prs);
        state[flipped ? 1 : 0] = resampled;
    }

    public static void main(String[] args) {
        double norm = 0.0;
        for (int s = 0; s < pot.length; ++s) {
            for (int t = 0; t < pot[0].length; ++t) {
                norm += pot[s][t];
            }
        }
        double exact = pot[0][0] / norm;
        System.out.println("Exact answer:" + exact);
        SummaryStatistics std = new SummaryStatistics();
        SummaryStatistics weird = new SummaryStatistics();
        for (int sim = 0; sim < 100; ++sim) {
            int i;
            double num = 0.0;
            double denom = 0.0;
            int[] state = new int[2];
            for (i = 0; i < 7; ++i) {
                TestRao.resampleP0Given1(state, i % 10 < 5);
                denom += 1.0;
                num += (double)(state[0] == state[1] && state[1] == 0 ? 1 : 0);
            }
            std.addValue(num / denom);
            num = 0.0;
            denom = 0.0;
            state = new int[2];
            for (i = 0; i < 7; ++i) {
                boolean flipped = i % 2 == 0;
                denom += 1.0;
                num = state[flipped ? 0 : 1] == 0 ? (num += 1.0 * TestRao.p0given1(state[flipped ? 0 : 1], flipped)[0]) : (num += 0.0);
                TestRao.resampleP0Given1(state, flipped);
            }
            weird.addValue(num / denom);
        }
        System.out.println("Error of std:" + Math.abs(exact - std.getMean()));
        System.out.println("Error of weird:" + Math.abs(exact - weird.getMean()));
    }
}

