/*
 * Decompiled with CFR 0.152.
 */
package sgi;

import fig.basic.Pair;
import goblin.DataPrepUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import nuts.math.Sampling;
import nuts.util.Indexer;
import nuts.util.Tree;
import sgi.ScoreFct;

public class HierarchicalAligner {
    private ScoreFct scoreFct;
    private double[][] insideScore;
    private int nT1Nodes;
    private int nT2Nodes;
    private int[] t1subtreeSizes;
    private int[] t2subtreeSizes;
    private Tree<String>[] t1subtrees;
    private Tree<String>[] t2subtrees;
    private ScoreFct.RuleTreelet[] t1noSyncRuleTreelets;
    private ScoreFct.RuleTreelet[] t2noSyncRuleTreelets;
    private ScoreFct.RuleTreelet[][] t1oneSyncRuleTreelets;
    private ScoreFct.RuleTreelet[][] t2oneSyncRuleTreelets;
    private ScoreFct.RuleTreelet[][][] t1twoSyncRuleTreelets;
    private ScoreFct.RuleTreelet[][][] t2twoSyncRuleTreelets;
    private int[][][] nonTermDescendants;
    private Random rand;
    private List<RuleMatch> sample = null;

    public HierarchicalAligner(Tree<String> t1, Tree<String> t2, ScoreFct scoreFct) {
        int i;
        this.scoreFct = scoreFct;
        this.t1subtrees = HierarchicalAligner.tree2subtrees(t1);
        this.t2subtrees = HierarchicalAligner.tree2subtrees(t2);
        this.t1subtreeSizes = new int[this.t1subtrees.length];
        this.t2subtreeSizes = new int[this.t2subtrees.length];
        for (i = 0; i < this.t1subtreeSizes.length; ++i) {
            this.t1subtreeSizes[i] = this.t1subtrees[i].getPostOrderTraversal().size();
        }
        for (i = 0; i < this.t2subtreeSizes.length; ++i) {
            this.t2subtreeSizes[i] = this.t2subtrees[i].getPostOrderTraversal().size();
        }
        this.nT1Nodes = this.t1subtreeSizes[0];
        this.nT2Nodes = this.t2subtreeSizes[0];
        this.insideScore = new double[this.nT1Nodes][this.nT2Nodes];
        this.cacheNonTermDescendants();
        this.cacheRuleTreelets();
    }

    public List<RuleMatch> sample(Random rand) {
        this.rand = rand;
        this.sample = new ArrayList<RuleMatch>();
        LinkedList<Pair<Integer, Integer>> samplingQueue = new LinkedList<Pair<Integer, Integer>>();
        samplingQueue.add(new Pair<Integer, Integer>(0, 0));
        while (!samplingQueue.isEmpty()) {
            Pair current = (Pair)samplingQueue.poll();
            RuleMatch match = (RuleMatch)this.compute((Integer)current.getFirst(), (Integer)current.getSecond(), true);
            this.sample.add(match);
            samplingQueue.addAll(match.matchedChildrenPositions());
        }
        return this.sample;
    }

    private boolean isTerminal(int node, boolean useT1) {
        int subtreesize = useT1 ? this.t1subtreeSizes[node] : this.t2subtreeSizes[node];
        return subtreesize <= 1;
    }

    private void insureInsideScores() {
        this.insideScore = new double[this.nT1Nodes][this.nT2Nodes];
        for (int i = 0; i < this.nT1Nodes; ++i) {
            for (int j = 0; j < this.nT2Nodes; ++j) {
                this.insideScore[i][j] = Double.NaN;
            }
        }
        for (int t1NodeIndex = this.nT1Nodes - 1; t1NodeIndex >= 0; --t1NodeIndex) {
            for (int t2NodeIndex = this.nT2Nodes - 1; t2NodeIndex >= 0; --t2NodeIndex) {
                double sum;
                if (this.isTerminal(t1NodeIndex, true) || this.isTerminal(t2NodeIndex, false)) continue;
                this.insideScore[t1NodeIndex][t2NodeIndex] = sum = ((Double)this.compute(t1NodeIndex, t2NodeIndex, false)).doubleValue();
            }
        }
    }

    private Object compute(int t1NodeIndex, int t2NodeIndex, boolean sample) {
        double sum = 0.0;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        ArrayList<Double> ruleMatchPrs = new ArrayList<Double>();
        ScoreFct.Rule noSyncNonTermRule = this.noSyncNonTermRule(t1NodeIndex, t2NodeIndex);
        double noSyncNonTermScore = this.noSyncNonTermScore(t1NodeIndex, t2NodeIndex, noSyncNonTermRule);
        if (sample) {
            ruleMatches.add(new RuleMatch(noSyncNonTermRule, t1NodeIndex, t2NodeIndex));
            ruleMatchPrs.add(noSyncNonTermScore);
        } else {
            sum += noSyncNonTermScore;
        }
        for (int t1child1 : this.nonTermDescendants(t1NodeIndex, true)) {
            for (int t2child1 : this.nonTermDescendants(t2NodeIndex, false)) {
                ScoreFct.Rule oneSyncNonTermRule = this.oneSyncNonTermRule(t1NodeIndex, t2NodeIndex, t1child1, t2child1);
                double oneSyncNonTermScore = this.oneSyncNonTermScore(t1NodeIndex, t2NodeIndex, t1child1, t2child1, oneSyncNonTermRule);
                if (sample) {
                    ruleMatches.add(new RuleMatch(oneSyncNonTermRule, t1NodeIndex, t2NodeIndex, t1child1, t2child1));
                    ruleMatchPrs.add(oneSyncNonTermScore);
                } else {
                    sum += oneSyncNonTermScore;
                }
                for (int t1child2 : this.nonTermDescendants(t1NodeIndex, true)) {
                    if (t1child2 <= t1child1 || this.overlapping(t1child1, t1child2, true)) continue;
                    for (int t2child2 : this.nonTermDescendants(t2NodeIndex, false)) {
                        if (this.overlapping(t2child1, t2child2, false)) continue;
                        ScoreFct.Rule twoSyncNonTermRule = this.twoSyncNonTermRule(t1NodeIndex, t2NodeIndex, t1child1, t2child1, t1child2, t2child2);
                        double twoSyncNonTermScore = this.twoSyncNonTermScore(t1NodeIndex, t2NodeIndex, t1child1, t2child1, t1child2, t2child2, twoSyncNonTermRule);
                        if (sample) {
                            ruleMatches.add(new RuleMatch(twoSyncNonTermRule, t1NodeIndex, t2NodeIndex, t1child1, t2child1, t1child2, t2child2));
                            ruleMatchPrs.add(twoSyncNonTermScore);
                            continue;
                        }
                        sum += twoSyncNonTermScore;
                    }
                }
            }
        }
        assert (ruleMatches.size() == ruleMatchPrs.size());
        if (sample) {
            return ruleMatches.get(Sampling.sample(this.rand, ruleMatchPrs));
        }
        return sum;
    }

    private ScoreFct.Rule twoSyncNonTermRule(int nodeIndex, int nodeIndex2, int t1child1, int t2child1, int t1child2, int t2child2) {
        ScoreFct.Bijection bijection = ScoreFct.identity;
        if (t2child2 < t2child1) {
            bijection = ScoreFct.swap;
            int temp = t2child1;
            t2child1 = t2child2;
            t2child2 = temp;
        }
        return new ScoreFct.Rule(this.t1twoSyncRuleTreelets[nodeIndex][t1child1][t1child2], this.t2twoSyncRuleTreelets[nodeIndex2][t2child1][t2child2], bijection);
    }

    private ScoreFct.Rule oneSyncNonTermRule(int nodeIndex, int nodeIndex2, int t1child1, int t2child1) {
        return new ScoreFct.Rule(this.t1oneSyncRuleTreelets[nodeIndex][t1child1], this.t2oneSyncRuleTreelets[nodeIndex2][t2child1], ScoreFct.identity);
    }

    private ScoreFct.Rule noSyncNonTermRule(int nodeIndex, int nodeIndex2) {
        return new ScoreFct.Rule(this.t1noSyncRuleTreelets[nodeIndex], this.t2noSyncRuleTreelets[nodeIndex2], ScoreFct.identity);
    }

    private double twoSyncNonTermScore(int nodeIndex, int nodeIndex2, int t1child1, int t2child1, int t1child2, int t2child2, ScoreFct.Rule rule) {
        double ruleScore = this.scoreFct.score(rule);
        return ruleScore * this.insideScore[t1child1][t2child1] * this.insideScore[t1child2][t2child2];
    }

    private double oneSyncNonTermScore(int nodeIndex, int nodeIndex2, int t1child1, int t2child1, ScoreFct.Rule rule) {
        double ruleScore = this.scoreFct.score(rule);
        return ruleScore * this.insideScore[t1child1][t2child1];
    }

    private double noSyncNonTermScore(int nodeIndex, int nodeIndex2, ScoreFct.Rule rule) {
        return this.scoreFct.score(rule);
    }

    public static void main(String[] args) throws IOException {
        Tree<String> t1 = DataPrepUtils.lisp2tree("(A (B c d) (E f))");
        Tree<String> t2 = DataPrepUtils.lisp2tree("(A b (C d e))");
        HierarchicalAligner ha = new HierarchicalAligner(t1, t2, new ScoreFct.UniformScoreFct(new Indexer<String>(), new Indexer<String>()));
        ha.insureInsideScores();
        ha.sample(new Random());
        System.out.println(ha.sample);
        System.out.println(ha.insideScore[0][0]);
    }

    private int[] nonTermDescendants(int nodeIndex, boolean useT1) {
        return this.nonTermDescendants[useT1 ? 0 : 1][nodeIndex];
    }

    private void cacheNonTermDescendants() {
        this.nonTermDescendants = new int[2][][];
        for (int lang = 0; lang < 2; ++lang) {
            this.nonTermDescendants[lang] = new int[lang == 0 ? this.nT1Nodes : this.nT2Nodes][];
            for (int nodeIndex = 0; nodeIndex < (lang == 0 ? this.nT1Nodes : this.nT2Nodes); ++nodeIndex) {
                this.nonTermDescendants[lang][nodeIndex] = this.cacheNonTermDescendants(nodeIndex, lang == 0);
            }
        }
    }

    private int[] cacheNonTermDescendants(int nodeIndex, boolean useT1) {
        int size = useT1 ? this.t1subtreeSizes[nodeIndex] : this.t2subtreeSizes[nodeIndex];
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < size - 1; ++i) {
            int currentNode = nodeIndex + 1 + i;
            if (!(useT1 ? this.t1subtreeSizes[currentNode] > 1 : this.t2subtreeSizes[currentNode] > 1)) continue;
            result.add(currentNode);
        }
        int[] resultArray = new int[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            resultArray[i] = (Integer)result.get(i);
        }
        return resultArray;
    }

    private boolean overlapping(int child1, int child2, boolean useT1) {
        if (child1 == child2) {
            return true;
        }
        int left1 = child1;
        int left2 = child2;
        int right1 = left1 + (useT1 ? this.t1subtreeSizes[child1] : this.t2subtreeSizes[child1]);
        int right2 = left2 + (useT1 ? this.t1subtreeSizes[child2] : this.t2subtreeSizes[child2]);
        boolean result = HierarchicalAligner.areIntervalsIntersecting(left1, right1, left2, right2);
        return result;
    }

    private static boolean areIntervalsIntersecting(int leftIncl, int rightExcl, int otherLeft, int otherRight) {
        assert (leftIncl <= rightExcl && otherLeft <= otherRight);
        return Math.min(rightExcl, otherRight) - Math.max(leftIncl, otherLeft) > 0;
    }

    private static <T> Tree<T>[] tree2subtrees(Tree<T> tree) {
        List<Tree<T>> result = tree.toSubTreeList();
        Tree[] converted = new Tree[result.size()];
        for (int i = 0; i < converted.length; ++i) {
            converted[i] = result.get(i);
        }
        return converted;
    }

    private void cacheRuleTreelets() {
        this.t1noSyncRuleTreelets = new ScoreFct.RuleTreelet[this.nT1Nodes];
        this.t1oneSyncRuleTreelets = new ScoreFct.RuleTreelet[this.nT1Nodes][this.nT1Nodes];
        this.t1twoSyncRuleTreelets = new ScoreFct.RuleTreelet[this.nT1Nodes][this.nT1Nodes][this.nT1Nodes];
        this.cacheRuleTreelets(this.t1subtrees, this.nonTermDescendants[0], this.t1noSyncRuleTreelets, this.t1oneSyncRuleTreelets, this.t1twoSyncRuleTreelets, true);
        this.t2noSyncRuleTreelets = new ScoreFct.RuleTreelet[this.nT2Nodes];
        this.t2oneSyncRuleTreelets = new ScoreFct.RuleTreelet[this.nT2Nodes][this.nT2Nodes];
        this.t2twoSyncRuleTreelets = new ScoreFct.RuleTreelet[this.nT2Nodes][this.nT2Nodes][this.nT2Nodes];
        this.cacheRuleTreelets(this.t2subtrees, this.nonTermDescendants[1], this.t2noSyncRuleTreelets, this.t2oneSyncRuleTreelets, this.t2twoSyncRuleTreelets, false);
    }

    private void cacheRuleTreelets(Tree<String>[] subtrees, int[][] nonTermDesc, ScoreFct.RuleTreelet[] noSyncRuleTreelets, ScoreFct.RuleTreelet[][] oneSyncRuleTreelets, ScoreFct.RuleTreelet[][][] twoSyncRuleTreelets, boolean useT1) {
        for (int i = 0; i < subtrees.length; ++i) {
            if (this.isTerminal(i, useT1)) continue;
            noSyncRuleTreelets[i] = this.scoreFct.extractRuleTreelet(subtrees[i], Collections.EMPTY_LIST);
            assert (noSyncRuleTreelets[i].getNNonTerm() == 0);
            for (int child1 : nonTermDesc[i]) {
                List<Tree<String>> child = Collections.singletonList(subtrees[child1]);
                oneSyncRuleTreelets[i][child1] = this.scoreFct.extractRuleTreelet(subtrees[i], child);
                if (oneSyncRuleTreelets[i][child1].getNNonTerm() != 1) {
                    throw new RuntimeException();
                }
                for (int child2 : nonTermDesc[i]) {
                    if (child1 >= child2 || this.overlapping(child1, child2, useT1)) continue;
                    ArrayList<Tree<String>> children = new ArrayList<Tree<String>>();
                    children.addAll(child);
                    children.add(subtrees[child2]);
                    twoSyncRuleTreelets[i][child1][child2] = this.scoreFct.extractRuleTreelet(subtrees[i], children);
                    if (twoSyncRuleTreelets[i][child1][child2].getNNonTerm() == 2) continue;
                    throw new RuntimeException();
                }
            }
        }
    }

    public static class RuleMatch {
        private int t1LhsMatchNodeIndex;
        private int t2LhsMatchNodeIndex;
        private final ScoreFct.Rule rule;
        private List<Integer> t1RhsNonTermMatchNodeIndices = new ArrayList<Integer>();
        private List<Integer> t2RhsNonTermMatchNodeIndices = new ArrayList<Integer>();

        public ScoreFct.Rule getRule() {
            return this.rule;
        }

        public RuleMatch(ScoreFct.Rule rule, int t1LhsMatchNodeIndex, int t2LhsMatchNodeIndex) {
            this.rule = rule;
            this.t1LhsMatchNodeIndex = t1LhsMatchNodeIndex;
            this.t2LhsMatchNodeIndex = t2LhsMatchNodeIndex;
        }

        public RuleMatch(ScoreFct.Rule rule, int t1LhsMatchNodeIndex, int t2LhsMatchNodeIndex, int t1child1, int t2child1) {
            this(rule, t1LhsMatchNodeIndex, t2LhsMatchNodeIndex);
            this.t1RhsNonTermMatchNodeIndices.add(t1child1);
            this.t2RhsNonTermMatchNodeIndices.add(t2child1);
        }

        public RuleMatch(ScoreFct.Rule rule, int t1LhsMatchNodeIndex, int t2LhsMatchNodeIndex, int t1child1, int t2child1, int t1child2, int t2child2) {
            this(rule, t1LhsMatchNodeIndex, t2LhsMatchNodeIndex, t1child1, t2child1);
            this.t1RhsNonTermMatchNodeIndices.add(t1child2);
            this.t2RhsNonTermMatchNodeIndices.add(t2child2);
        }

        public List<Pair<Integer, Integer>> matchedChildrenPositions() {
            ArrayList<Pair<Integer, Integer>> result = new ArrayList<Pair<Integer, Integer>>();
            assert (this.t1RhsNonTermMatchNodeIndices.size() == this.t2RhsNonTermMatchNodeIndices.size());
            for (int i = 0; i < this.t1RhsNonTermMatchNodeIndices.size(); ++i) {
                result.add(new Pair<Integer, Integer>(this.t1RhsNonTermMatchNodeIndices.get(i), this.t2RhsNonTermMatchNodeIndices.get(i)));
            }
            return result;
        }

        public String toString() {
            return "" + this.rule + " applied @ (" + this.t1LhsMatchNodeIndex + ", " + this.t2LhsMatchNodeIndex + ")";
        }
    }
}

