/*
 * Decompiled with CFR 0.152.
 */
package stat560;

import fig.basic.LogInfo;
import fig.exec.Execution;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import nuts.io.IO;
import nuts.math.PlotHistogram;
import nuts.util.MathUtils;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.GammaDistributionImpl;
import org.apache.commons.math.distribution.NormalDistributionImpl;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;

public class KS {
    public static Random rand = new Random(1L);

    public static void main(String[] args) {
        IO.run(args, new Main());
    }

    private static void test1() {
        double tol = 0.005;
        Normal ndi = new Normal();
        for (int nData : new int[]{10, 20, 40, 80, 160}) {
            SummaryStatistics disc = new SummaryStatistics();
            for (int rep = 0; rep < 100; ++rep) {
                double point = KS.dist(KS.sample(ndi, nData), ndi);
                double ks = KS.pBrown(point, nData);
                double mc = KS.pMC(point, nData, tol, ndi);
                disc.addValue(Math.abs(ks - mc));
            }
            System.out.println("" + nData + "\t" + disc.getMean() + " +/-" + disc.getStandardDeviation() / Math.sqrt(disc.getN()));
        }
        System.out.println();
        for (double x = 0.1; x < 2.0; x += 0.1) {
            System.out.println(KS.bmPDF(x));
        }
    }

    private static double bmPDF(double x) {
        int maxIter = 20;
        double sum = 0.0;
        for (int k = 1; k < maxIter; ++k) {
            double cur = Math.exp(-((double)(2 * k) - 1.0) * ((double)(2 * k) - 1.0) * Math.PI * Math.PI / (8.0 * x * x));
            sum += cur;
            if (cur < MathUtils.threshold) break;
        }
        return Math.sqrt(Math.PI * 2) / x * sum;
    }

    private static double pBrown(double dist, double n) {
        return 1.0 - KS.bmPDF(Math.sqrt(n) * dist);
    }

    private static double pMC(double dist, int n, double tol, Distrib d) {
        SummaryStatistics stat = new SummaryStatistics();
        try {
            for (int outer = 0; outer < 10; ++outer) {
                int iter = 0;
                while ((double)iter < 1000.0 * Math.pow(2.0, outer)) {
                    double sampledDist = KS.dist(KS.sample(d, n), d);
                    stat.addValue(sampledDist <= dist ? 1.0 : 0.0);
                    ++iter;
                }
                if (!(2.0 * stat.getStandardDeviation() / Math.sqrt(stat.getN()) < tol)) continue;
                return 1.0 - stat.getMean();
            }
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        System.out.println("Warning: exceeded max iters in pMC");
        return 1.0 - stat.getMean();
    }

    private static List<Double> sample(Distrib dist, int n) {
        ArrayList<Double> result = new ArrayList<Double>();
        try {
            for (int i = 0; i < n; ++i) {
                result.add(dist.sample(rand));
            }
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        return result;
    }

    private static double dist(List<Double> empirical, Distrib dist) {
        Collections.sort(empirical);
        double max = Double.NEGATIVE_INFINITY;
        double n = empirical.size();
        try {
            for (int i = 0; i < empirical.size(); ++i) {
                double cur = Math.abs((double)i / n - dist.cdfAt(empirical.get(i)));
                if (cur > max) {
                    max = cur;
                }
                if (!((cur = Math.abs(((double)i + 1.0) / n - dist.cdfAt(empirical.get(i)))) > max)) continue;
                max = cur;
            }
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        return max;
    }

    public static class Main
    implements Runnable {
        @Override
        public void run() {
            double tol = 0.005;
            int nData = 100;
            Gamma generatingData = new Gamma(1.0, 1.2);
            Gamma nullHyp = new Gamma(1.0, 1.0);
            List observations = KS.sample(generatingData, 100);
            LogInfo.track((Object)"Samples:", true);
            Iterator iterator = observations.iterator();
            while (iterator.hasNext()) {
                double d = (Double)iterator.next();
                LogInfo.logsForce(d);
            }
            LogInfo.end_track();
            double observedDist = KS.dist(observations, nullHyp);
            LogInfo.logsForce("dist = " + observedDist);
            double ks = KS.pBrown(observedDist, 100.0);
            double mc = KS.pMC(observedDist, 100, tol, nullHyp);
            LogInfo.logs("KS:" + ks);
            LogInfo.logs("MC:" + mc);
            PlotHistogram ph = new PlotHistogram();
            ph.addPoints(observations);
            ph.savePlot(new File(Execution.getFile("observations.pdf")));
        }
    }

    public static class Normal
    implements Distrib {
        private final double mean;
        private final double sd;

        public Normal(double mean, double sd) {
            this.mean = mean;
            this.sd = sd;
        }

        public Normal() {
            this.mean = 0.0;
            this.sd = 1.0;
        }

        @Override
        public double cdfAt(double x) {
            try {
                return new NormalDistributionImpl(this.mean, this.sd).cumulativeProbability(x);
            }
            catch (MathException e) {
                throw new RuntimeException();
            }
        }

        @Override
        public double sample(Random rand) {
            return this.mean + this.sd * rand.nextGaussian();
        }
    }

    public static class Gamma
    implements Distrib {
        public final double shape;
        public final double rate;

        public Gamma(double shape, double rate) {
            this.shape = shape;
            this.rate = rate;
        }

        @Override
        public double cdfAt(double x) {
            try {
                return new GammaDistributionImpl(this.shape, this.rate).cumulativeProbability(x);
            }
            catch (MathException e) {
                throw new RuntimeException();
            }
        }

        @Override
        public double sample(Random rand) {
            return fig.prob.Gamma.sample(rand, this.shape, this.rate);
        }
    }

    public static class Uniform
    implements Distrib {
        @Override
        public double cdfAt(double x) {
            if (x <= 0.0) {
                return 0.0;
            }
            if (x >= 1.0) {
                return 1.0;
            }
            return x;
        }

        @Override
        public double sample(Random rand) {
            return rand.nextDouble();
        }
    }

    public static interface Distrib {
        public double cdfAt(double var1);

        public double sample(Random var1);
    }
}

