/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.AndRevFilter;
import org.eclipse.jgit.revwalk.filter.MaxCountRevFilter;
import org.eclipse.jgit.revwalk.filter.SkipRevFilter;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogCommand
extends GitCommand<Iterable<RevCommit>> {
    private RevWalk walk;
    private boolean startSpecified = false;
    private final List<PathFilter> pathFilters = new ArrayList<PathFilter>();
    private int maxCount = -1;
    private int skip = -1;

    protected LogCommand(Repository repo) {
        super(repo);
        this.walk = new RevWalk(repo);
    }

    @Override
    public Iterable<RevCommit> call() throws GitAPIException, NoHeadException {
        this.checkCallable();
        if (this.pathFilters.size() > 0) {
            this.walk.setTreeFilter(AndTreeFilter.create(PathFilterGroup.create(this.pathFilters), TreeFilter.ANY_DIFF));
        }
        if (this.skip > -1 && this.maxCount > -1) {
            this.walk.setRevFilter(AndRevFilter.create(SkipRevFilter.create(this.skip), MaxCountRevFilter.create(this.maxCount)));
        } else if (this.skip > -1) {
            this.walk.setRevFilter(SkipRevFilter.create(this.skip));
        } else if (this.maxCount > -1) {
            this.walk.setRevFilter(MaxCountRevFilter.create(this.maxCount));
        }
        if (!this.startSpecified) {
            try {
                ObjectId headId = this.repo.resolve("HEAD");
                if (headId == null) {
                    throw new NoHeadException(JGitText.get().noHEADExistsAndNoExplicitStartingRevisionWasSpecified);
                }
                this.add(headId);
            }
            catch (IOException e) {
                throw new JGitInternalException(JGitText.get().anExceptionOccurredWhileTryingToAddTheIdOfHEAD, e);
            }
        }
        this.setCallable(false);
        return this.walk;
    }

    public LogCommand add(AnyObjectId start) throws MissingObjectException, IncorrectObjectTypeException {
        return this.add(true, start);
    }

    public LogCommand not(AnyObjectId start) throws MissingObjectException, IncorrectObjectTypeException {
        return this.add(false, start);
    }

    public LogCommand addRange(AnyObjectId since, AnyObjectId until) throws MissingObjectException, IncorrectObjectTypeException {
        return this.not(since).add(until);
    }

    public LogCommand all() throws IOException {
        Map<String, Ref> refs = this.getRepository().getRefDatabase().getRefs("");
        for (Ref ref : refs.values()) {
            ObjectId objectId;
            if (!ref.isPeeled()) {
                ref = this.getRepository().peel(ref);
            }
            if ((objectId = ref.getPeeledObjectId()) == null) {
                objectId = ref.getObjectId();
            }
            RevCommit commit = null;
            try {
                commit = this.walk.parseCommit(objectId);
            }
            catch (MissingObjectException e) {
            }
            catch (IncorrectObjectTypeException e) {
                // empty catch block
            }
            if (commit == null) continue;
            this.add(commit);
        }
        return this;
    }

    public LogCommand addPath(String path) {
        this.checkCallable();
        this.pathFilters.add(PathFilter.create(path));
        return this;
    }

    public LogCommand setSkip(int skip) {
        this.checkCallable();
        this.skip = skip;
        return this;
    }

    public LogCommand setMaxCount(int maxCount) {
        this.checkCallable();
        this.maxCount = maxCount;
        return this;
    }

    private LogCommand add(boolean include, AnyObjectId start) throws MissingObjectException, IncorrectObjectTypeException, JGitInternalException {
        this.checkCallable();
        try {
            if (include) {
                this.walk.markStart(this.walk.lookupCommit(start));
                this.startSpecified = true;
            } else {
                this.walk.markUninteresting(this.walk.lookupCommit(start));
            }
            return this;
        }
        catch (MissingObjectException e) {
            throw e;
        }
        catch (IncorrectObjectTypeException e) {
            throw e;
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionOccurredDuringAddingOfOptionToALogCommand, start), e);
        }
    }
}

