/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.factory;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import spoon.reflect.code.CtBlock;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.factory.ExecutableFactory;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.template.Substitution;

public class MethodFactory
extends ExecutableFactory {
    public MethodFactory(Factory factory) {
        super(factory);
    }

    public <R, B extends R> CtMethod<R> create(CtClass<?> target, Set<ModifierKind> modifiers, CtTypeReference<R> returnType, String name, List<CtParameter<?>> parameters, Set<CtTypeReference<? extends Throwable>> thrownTypes, CtBlock<B> body) {
        CtMethod<R> method = this.create(target, modifiers, returnType, name, parameters, thrownTypes);
        method.setBody(body);
        return method;
    }

    public <T> CtMethod<T> create(CtType<?> target, CtMethod<T> source, boolean redirectReferences) {
        CtMethod<T> newMethod = this.factory.Core().clone(source);
        if (redirectReferences && source.getDeclaringType() != null) {
            Substitution.redirectTypeReferences(newMethod, source.getDeclaringType().getReference(), target.getReference());
        }
        target.addMethod(newMethod);
        return newMethod;
    }

    public <T> CtMethod<T> create(CtType<?> target, Set<ModifierKind> modifiers, CtTypeReference<T> returnType, String name, List<CtParameter<?>> parameters, Set<CtTypeReference<? extends Throwable>> thrownTypes) {
        CtMethod<T> method = this.factory.Core().createMethod();
        target.addMethod(method);
        if (modifiers != null) {
            method.setModifiers(modifiers);
        }
        method.setType(returnType);
        method.setSimpleName(name);
        if (parameters != null) {
            method.setParameters(parameters);
        }
        if (thrownTypes != null) {
            method.setThrownTypes(thrownTypes);
        }
        return method;
    }

    public <T> CtExecutableReference<T> createReference(CtMethod<T> m) {
        return this.factory.Executable().createReference(m);
    }

    public <T> CtExecutableReference<T> createReference(Method method) {
        return this.createReference(this.factory.Type().createReference(method.getDeclaringClass()), this.factory.Type().createReference(method.getReturnType()), method.getName(), this.factory.Type().createReferences(Arrays.asList(method.getParameterTypes())).toArray(new CtTypeReference[0]));
    }

    public Collection<CtMethod<Void>> getMainMethods() {
        ArrayList<CtMethod<Void>> methods = new ArrayList<CtMethod<Void>>();
        for (CtType<?> t : this.factory.Type().getAll()) {
            CtMethod<Void> m;
            if (!(t instanceof CtClass) || (m = ((CtClass)t).getMethod(this.factory.Type().createReference(Void.TYPE), "main", this.factory.Type().createArrayReference(this.factory.Type().createReference(String.class)))) == null || !m.getModifiers().contains((Object)ModifierKind.STATIC)) continue;
            methods.add(m);
        }
        return methods;
    }
}

