/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.factory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.factory.Factory;
import spoon.reflect.factory.SubFactory;
import spoon.reflect.reference.CtPackageReference;

public class PackageFactory
extends SubFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, CtPackage> packages = new TreeMap<String, CtPackage>();
    CtPackageReference topLevel;

    public PackageFactory(Factory factory) {
        super(factory);
    }

    public CtPackageReference createReference(CtPackage pack) {
        if (pack == null) {
            throw new IllegalArgumentException();
        }
        return this.createReference(pack.getQualifiedName());
    }

    public CtPackageReference createReference(Package pack) {
        return this.createReference(pack.getName());
    }

    public CtPackageReference topLevel() {
        if (this.topLevel == null) {
            this.topLevel = this.createReference("unnamed package");
        }
        return this.topLevel;
    }

    public CtPackageReference createReference(String name) {
        CtPackageReference ref = this.factory.Core().createPackageReference();
        ref.setSimpleName(name);
        return ref;
    }

    public CtPackage create(CtPackage parent, String simpleName) {
        return this.getOrCreate(parent.toString() + "." + simpleName);
    }

    public CtPackage getOrCreate(String qualifiedName) {
        String name;
        StringTokenizer token = new StringTokenizer(qualifiedName, ".");
        CtPackage last = null;
        if (token.hasMoreElements()) {
            name = token.nextToken();
            if (name.length() < 0) {
                name = "unnamed package";
            }
            if (this.packages.containsKey(name)) {
                last = this.packages.get(name);
            } else {
                last = this.factory.Core().createPackage();
                last.setSimpleName(name);
                this.register(last);
            }
        }
        while (token.hasMoreElements()) {
            name = token.nextToken();
            CtPackage next = last.getPackage(name);
            if (next == null) {
                next = this.factory.Core().createPackage();
                next.setSimpleName(name);
                last.getPackages().add(next);
                next.setParent(last);
            }
            last = next;
        }
        return last;
    }

    public CtPackage get(String qualifiedName) {
        if (qualifiedName.contains("$")) {
            throw new RuntimeException("Invalid package name " + qualifiedName);
        }
        StringTokenizer token = new StringTokenizer(qualifiedName, ".");
        CtPackage current = null;
        if (token.hasMoreElements()) {
            for (current = this.packages.get(token.nextElement()); token.hasMoreElements() && current != null; current = current.getPackage(token.nextToken())) {
            }
        }
        return current;
    }

    public Collection<CtPackage> getAll() {
        ArrayList<CtPackage> packs = new ArrayList<CtPackage>();
        for (CtPackage pack : this.packages.values()) {
            packs.addAll(this.getSubPackageList(pack));
        }
        return packs;
    }

    public Collection<CtPackage> getAllRoots() {
        return this.packages.values();
    }

    private List<CtPackage> getSubPackageList(CtPackage pack) {
        ArrayList<CtPackage> packs = new ArrayList<CtPackage>();
        packs.add(pack);
        for (CtPackage p : pack.getPackages()) {
            packs.addAll(this.getSubPackageList(p));
        }
        return packs;
    }

    public void register(CtPackage pck) {
        if (this.packages.containsKey(pck.getQualifiedName())) {
            throw new RuntimeException("package " + pck.getQualifiedName() + " already created");
        }
        this.packages.put(pck.getQualifiedName(), pck);
    }
}

