/*
 * Decompiled with CFR 0.152.
 */
package spoon.support;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;
import spoon.compiler.Environment;
import spoon.compiler.InvalidClassPathException;
import spoon.compiler.SpoonFile;
import spoon.processing.FileGenerator;
import spoon.processing.ProblemFixer;
import spoon.processing.ProcessingManager;
import spoon.processing.Processor;
import spoon.processing.ProcessorProperties;
import spoon.processing.Severity;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.ParentNotInitializedException;
import spoon.reflect.factory.Factory;
import spoon.support.compiler.FileSystemFolder;
import spoon.support.processing.XmlProcessorProperties;

public class StandardEnvironment
implements Serializable,
Environment {
    Logger logger = Logger.getLogger(StandardEnvironment.class);
    public static final String PROPERTIES_EXT = ".xml";
    private static final long serialVersionUID = 1L;
    private boolean debug = false;
    private FileGenerator<? extends CtElement> defaultFileGenerator;
    private int errorCount = 0;
    private transient Factory factory;
    ProcessingManager manager;
    private boolean processingStopped = false;
    private boolean verbose = false;
    private boolean autoImports = false;
    private int warningCount = 0;
    private File xmlRootFolder;
    private String[] sourceClasspath = null;
    private URLClassLoader classLoader = null;
    private boolean preserveLineNumbers = false;
    private boolean copyResources = true;
    private boolean generateJavadoc = false;
    Map<String, ProcessorProperties> processorProperties = new TreeMap<String, ProcessorProperties>();
    int complianceLevel = 7;
    boolean useTabulations = false;
    int tabulationSize = 4;
    private ClassLoader inputClassLoader;
    private boolean noclasspath = false;

    @Override
    public void debugMessage(String message) {
        if (this.isDebug()) {
            this.logger.debug(message);
        }
    }

    @Override
    public boolean isAutoImports() {
        return this.autoImports;
    }

    @Override
    public void setAutoImports(boolean autoImports) {
        this.autoImports = autoImports;
    }

    @Override
    public FileGenerator<? extends CtElement> getDefaultFileGenerator() {
        return this.defaultFileGenerator;
    }

    public Factory getFactory() {
        return this.factory;
    }

    @Override
    public ProcessingManager getManager() {
        return this.manager;
    }

    @Override
    public ProcessorProperties getProcessorProperties(String processorName) throws FileNotFoundException, IOException, SAXException {
        if (this.processorProperties.containsKey(processorName)) {
            return this.processorProperties.get(processorName);
        }
        InputStream in = this.getPropertyStream(processorName);
        XmlProcessorProperties prop = null;
        try {
            prop = new XmlProcessorProperties(this.getFactory(), processorName, in);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        this.processorProperties.put(processorName, prop);
        return prop;
    }

    private InputStream getPropertyStream(String processorName) throws FileNotFoundException {
        for (File child : this.getXmlRootFolder().listFiles()) {
            if (!child.getName().equals(processorName + PROPERTIES_EXT)) continue;
            return new FileInputStream(child);
        }
        throw new FileNotFoundException();
    }

    public File getXmlRootFolder() {
        if (this.xmlRootFolder == null) {
            this.xmlRootFolder = new File(".");
        }
        return this.xmlRootFolder;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public boolean isProcessingStopped() {
        return this.processingStopped;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    private void prefix(StringBuffer buffer, Severity severity) {
        switch (severity) {
            case ERROR: {
                buffer.append("error: ");
                ++this.errorCount;
                break;
            }
            case WARNING: {
                buffer.append("warning: ");
                ++this.warningCount;
                break;
            }
        }
    }

    private void print(StringBuffer buffer, Severity severity) {
        switch (severity) {
            case ERROR: {
                this.logger.error(buffer.toString());
                break;
            }
            case WARNING: {
                this.logger.warn(buffer.toString());
                break;
            }
            default: {
                if (!this.isVerbose()) break;
                this.logger.info(buffer.toString());
            }
        }
    }

    @Override
    public void report(Processor<?> processor, Severity severity, CtElement element, String message) {
        StringBuffer buffer = new StringBuffer();
        this.prefix(buffer, severity);
        buffer.append(message);
        try {
            CtType type = element instanceof CtType ? (CtType)element : element.getParent(CtType.class);
            SourcePosition sp = element.getPosition();
            if (sp == null) {
                buffer.append(" (Unknown Source)");
            } else {
                CtExecutable exe;
                buffer.append(" at " + type.getQualifiedName() + ".");
                CtExecutable ctExecutable = exe = element instanceof CtExecutable ? (CtExecutable)element : element.getParent(CtExecutable.class);
                if (exe != null) {
                    buffer.append(exe.getSimpleName());
                }
                buffer.append("(" + sp.getFile().getName() + ":" + sp.getLine() + ")");
            }
        }
        catch (ParentNotInitializedException e) {
            buffer.append(" (invalid parent)");
        }
        this.print(buffer, severity);
    }

    @Override
    public void report(Processor<?> processor, Severity severity, String message) {
        StringBuffer buffer = new StringBuffer();
        this.prefix(buffer, severity);
        buffer.append(message);
        this.print(buffer, severity);
    }

    @Override
    public void reportEnd() {
        if (!this.isVerbose()) {
            return;
        }
        System.out.print("end of processing: ");
        if (this.warningCount > 0) {
            System.out.print(this.warningCount + " warning");
            if (this.warningCount > 1) {
                System.out.print("s");
            }
            if (this.errorCount > 0) {
                System.out.print(", ");
            }
        }
        if (this.errorCount > 0) {
            System.out.print(this.errorCount + " error");
            if (this.errorCount > 1) {
                System.out.print("s");
            }
        }
        if (this.errorCount + this.warningCount > 0) {
            System.out.print("\n");
        } else {
            System.out.println("no errors, no warnings");
        }
    }

    @Override
    public void reportProgressMessage(String message) {
        if (!this.isVerbose()) {
            return;
        }
        System.out.println(message);
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public void setDefaultFileGenerator(FileGenerator<? extends CtElement> defaultFileGenerator) {
        this.defaultFileGenerator = defaultFileGenerator;
        defaultFileGenerator.setFactory(this.getFactory());
    }

    @Override
    public void setManager(ProcessingManager manager) {
        this.manager = manager;
    }

    @Override
    public void setProcessingStopped(boolean processingStopped) {
        this.processingStopped = processingStopped;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public void setXmlRootFolder(File xmlRootFolder) {
        this.xmlRootFolder = xmlRootFolder;
    }

    @Override
    public int getComplianceLevel() {
        return this.complianceLevel;
    }

    @Override
    public void setComplianceLevel(int level) {
        this.complianceLevel = level;
    }

    @Override
    public void setProcessorProperties(String processorName, ProcessorProperties prop) {
        this.processorProperties.put(processorName, prop);
    }

    @Override
    public void report(Processor<?> processor, Severity severity, CtElement element, String message, ProblemFixer<?> ... fix) {
        this.report(processor, severity, element, message);
    }

    @Override
    public boolean isUsingTabulations() {
        return this.useTabulations;
    }

    @Override
    public void useTabulations(boolean tabulation) {
        this.useTabulations = tabulation;
    }

    @Override
    public int getTabulationSize() {
        return this.tabulationSize;
    }

    @Override
    public void setTabulationSize(int tabulationSize) {
        this.tabulationSize = tabulationSize;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = new URLClassLoader(this.urlClasspath(), Thread.currentThread().getContextClassLoader());
        }
        return this.classLoader;
    }

    public URL[] urlClasspath() {
        String[] classpath = this.getSourceClasspath();
        int length = classpath == null ? 0 : classpath.length;
        URL[] urls = new URL[length];
        for (int i = 0; i < length; ++i) {
            try {
                urls[i] = new File(classpath[i]).toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Invalid classpath: " + classpath, e);
            }
        }
        return urls;
    }

    @Override
    public String[] getSourceClasspath() {
        return this.sourceClasspath;
    }

    @Override
    public void setSourceClasspath(String[] sourceClasspath) {
        this.verifySourceClasspath(sourceClasspath);
        this.sourceClasspath = sourceClasspath;
        this.classLoader = null;
    }

    private void verifySourceClasspath(String[] sourceClasspath) throws InvalidClassPathException {
        for (String classPathElem : sourceClasspath) {
            FileSystemFolder tmp;
            List<SpoonFile> javaFiles;
            File classOrJarFolder = new File(classPathElem);
            if (!classOrJarFolder.exists()) {
                throw new InvalidClassPathException(classPathElem + " does not exist, it is not a valid folder");
            }
            if (!classOrJarFolder.isDirectory() || (javaFiles = (tmp = new FileSystemFolder(classOrJarFolder)).getAllJavaFiles()).size() <= 0) continue;
            this.logger.warn("You're trying to give source code in the classpath, this should be given to addInputSource " + javaFiles);
        }
    }

    @Override
    public int getErrorCount() {
        return this.errorCount;
    }

    @Override
    public int getWarningCount() {
        return this.warningCount;
    }

    @Override
    public ClassLoader getInputClassLoader() {
        if (this.inputClassLoader == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return this.inputClassLoader;
    }

    @Override
    public void setInputClassLoader(ClassLoader classLoader) {
        this.inputClassLoader = classLoader;
    }

    @Override
    public boolean isPreserveLineNumbers() {
        return this.preserveLineNumbers;
    }

    @Override
    public void setPreserveLineNumbers(boolean preserveLineNumbers) {
        this.preserveLineNumbers = preserveLineNumbers;
    }

    @Override
    public void setNoClasspath(boolean option) {
        this.noclasspath = option;
    }

    @Override
    public boolean getNoClasspath() {
        return this.noclasspath;
    }

    @Override
    public boolean isCopyResources() {
        return this.copyResources;
    }

    @Override
    public void setCopyResources(boolean copyResources) {
        this.copyResources = copyResources;
    }

    @Override
    public boolean isGenerateJavadoc() {
        return this.generateJavadoc;
    }

    @Override
    public void setGenerateJavadoc(boolean generateJavadoc) {
        this.generateJavadoc = generateJavadoc;
    }
}

