/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import spoon.Launcher;
import spoon.SpoonException;
import spoon.compiler.SpoonFile;
import spoon.compiler.SpoonFolder;
import spoon.compiler.SpoonResource;
import spoon.compiler.SpoonResourceHelper;

public class FileSystemFile
implements SpoonFile {
    File file;

    public FileSystemFile(File file) {
        this.file = file;
    }

    @Override
    public InputStream getContent() {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            Launcher.logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public SpoonFolder getParent() {
        try {
            return SpoonResourceHelper.createFolder(this.file.getParentFile());
        }
        catch (FileNotFoundException e) {
            Launcher.logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public File getFileSystemParent() {
        return this.file.getParentFile();
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public boolean isJava() {
        return this.getName().endsWith(".java");
    }

    @Override
    public String getPath() {
        try {
            return this.file.getCanonicalPath();
        }
        catch (Exception e) {
            Launcher.logger.error(e.getMessage(), e);
            return this.file.getPath();
        }
    }

    public String toString() {
        return this.file.getPath();
    }

    @Override
    public boolean isArchive() {
        return SpoonResourceHelper.isArchive(this.file);
    }

    @Override
    public File toFile() {
        try {
            return this.file.getCanonicalFile();
        }
        catch (IOException e) {
            throw new SpoonException(e);
        }
    }

    @Override
    public boolean isActualFile() {
        return true;
    }

    public boolean equals(Object obj) {
        return this.toFile().equals(((SpoonResource)obj).toFile());
    }

    public int hashCode() {
        return this.toFile().hashCode();
    }
}

