/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class Timer {
    private static List<Timer> timestamps = new ArrayList<Timer>();
    private static Stack<Timer> current = new Stack();
    String name;
    long start;
    long stop;

    public static void start(String name) {
        current.push(new Timer(name));
    }

    public static void stop(String name) {
        if (!current.peek().getName().equals(name)) {
            throw new RuntimeException("Must stop last timer");
        }
        current.peek().stop();
        timestamps.add(current.pop());
    }

    public static void display() {
        for (Timer time : timestamps) {
            System.out.println(time);
        }
    }

    public Timer(String name) {
        this.name = name;
        this.start = System.currentTimeMillis();
    }

    public void stop() {
        this.stop = System.currentTimeMillis();
    }

    public String getName() {
        return this.name;
    }

    public long getValue() {
        return this.stop - this.start;
    }

    public String toString() {
        return this.getName() + " \t" + this.getValue() + "ms";
    }
}

