/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.DefaultFontMapper;
import com.itextpdf.text.pdf.FontMapper;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.TreePanel;
import org.forester.phylogeny.Phylogeny;

final class PdfExporter {
    private static final int HEIGHT_LIMIT = 100;
    private static final int WIDTH_LIMIT = 60;

    private PdfExporter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String writePhylogenyToPdf(String string, TreePanel treePanel, int n, int n2) throws IOException {
        Phylogeny phylogeny;
        if (n2 < 100) {
            n2 = 100;
        }
        if (n < 60) {
            n = 60;
        }
        if ((phylogeny = treePanel.getPhylogeny()) == null || phylogeny.isEmpty()) {
            return "";
        }
        if (treePanel.getMainPanel().getTreeFontSet().getSmallFont().getSize() < 1) {
            throw new IOException("fonts are too small for PDF export");
        }
        File file = new File(string);
        if (file.isDirectory()) {
            throw new IOException("[" + string + "] is a directory");
        }
        Document document = new Document();
        document.setPageSize(new Rectangle((float)n, (float)n2));
        document.setMargins(30.0f, 30.0f, 50.0f, 50.0f);
        PdfWriter pdfWriter = null;
        try {
            pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(string));
        }
        catch (DocumentException documentException) {
            throw new IOException(documentException);
        }
        document.open();
        DefaultFontMapper defaultFontMapper = new DefaultFontMapper();
        FontFactory.registerDirectories();
        if (AptxUtil.isWindows()) {
            defaultFontMapper.insertDirectory("C:\\WINDOWS\\Fonts\\");
        } else if (AptxUtil.isMac()) {
            defaultFontMapper.insertDirectory("/Library/Fonts/");
            defaultFontMapper.insertDirectory("/System/Library/Fonts/");
        } else {
            defaultFontMapper.insertDirectory("/usr/X/lib/X11/fonts/TrueType/");
            defaultFontMapper.insertDirectory("/usr/X/lib/X11/fonts/Type1/");
            defaultFontMapper.insertDirectory("/usr/share/fonts/default/TrueType/");
            defaultFontMapper.insertDirectory("/usr/share/fonts/default/Type1/");
        }
        PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
        Graphics2D graphics2D = pdfContentByte.createGraphics((float)n, (float)n2, (FontMapper)defaultFontMapper);
        try {
            treePanel.paintPhylogeny(graphics2D, true, false, n, n2, 0, 0);
        }
        catch (Exception exception) {
            AptxUtil.unexpectedException(exception);
        }
        finally {
            try {
                graphics2D.dispose();
                document.close();
            }
            catch (Exception exception) {}
        }
        String string2 = file.toString();
        if (n > 0 && n2 > 0) {
            string2 = string2 + " [size: " + n + ", " + n2 + "]";
        }
        return string2;
    }
}

