/*
 * Decompiled with CFR 0.152.
 */
package org.forester.sdi;

import java.util.HashMap;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.sdi.SDIException;
import org.forester.util.ForesterUtil;

public abstract class SDI {
    final Phylogeny _gene_tree;
    final Phylogeny _species_tree;
    int _duplications_sum;
    int _mapping_cost;

    public SDI(Phylogeny phylogeny, Phylogeny phylogeny2) {
        if (phylogeny2.isEmpty() || phylogeny.isEmpty()) {
            throw new IllegalArgumentException("attempt to infer duplications using empty tree(s)");
        }
        if (!phylogeny.isRooted()) {
            throw new IllegalArgumentException("attempt to infer duplications on unrooted gene tree");
        }
        if (!phylogeny2.isRooted()) {
            throw new IllegalArgumentException("attempt to infer duplications on unrooted species tree");
        }
        this._gene_tree = phylogeny;
        this._species_tree = phylogeny2;
        this._duplications_sum = 0;
        this._mapping_cost = -1;
    }

    private void computeMappingCostHelper(PhylogenyNode phylogenyNode) {
        if (!phylogenyNode.isExternal()) {
            this.computeMappingCostHelper(phylogenyNode.getChildNode1());
            this.computeMappingCostHelper(phylogenyNode.getChildNode2());
            this._mapping_cost = phylogenyNode.getLink() != phylogenyNode.getChildNode1().getLink() && phylogenyNode.getLink() != phylogenyNode.getChildNode2().getLink() ? (this._mapping_cost += phylogenyNode.getChildNode1().getLink().getId() + phylogenyNode.getChildNode2().getLink().getId() - 2 * phylogenyNode.getLink().getId() - 2) : (phylogenyNode.getLink() != phylogenyNode.getChildNode1().getLink() && phylogenyNode.getLink() == phylogenyNode.getChildNode2().getLink() ? (this._mapping_cost += phylogenyNode.getChildNode1().getLink().getId() - phylogenyNode.getLink().getId() + 1) : (phylogenyNode.getLink() == phylogenyNode.getChildNode1().getLink() && phylogenyNode.getLink() != phylogenyNode.getChildNode2().getLink() ? (this._mapping_cost += phylogenyNode.getChildNode2().getLink().getId() - phylogenyNode.getLink().getId() + 1) : ++this._mapping_cost));
        }
    }

    public int computeMappingCostL() {
        this._species_tree.levelOrderReID();
        this._mapping_cost = 0;
        this.computeMappingCostHelper(this._gene_tree.getRoot());
        return this._mapping_cost;
    }

    private TaxonomyComparisonBase determineTaxonomyComparisonBase() {
        Taxonomy taxonomy;
        PhylogenyNode phylogenyNode;
        TaxonomyComparisonBase taxonomyComparisonBase = null;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        PhylogenyNodeIterator phylogenyNodeIterator = this._species_tree.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.getNodeData().isHasTaxonomy()) {
                taxonomy = phylogenyNode.getNodeData().getTaxonomy();
                if (taxonomy.getIdentifier() == null || ForesterUtil.isEmpty(taxonomy.getIdentifier().getValue())) {
                    bl = false;
                }
                if (ForesterUtil.isEmpty(taxonomy.getTaxonomyCode())) {
                    bl2 = false;
                }
                if (!ForesterUtil.isEmpty(taxonomy.getScientificName())) continue;
                bl3 = false;
                continue;
            }
            throw new IllegalArgumentException("species tree node [" + phylogenyNode + "] has no taxonomic data");
        }
        phylogenyNodeIterator = this._gene_tree.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.getNodeData().isHasTaxonomy()) {
                taxonomy = phylogenyNode.getNodeData().getTaxonomy();
                if (taxonomy.getIdentifier() == null || ForesterUtil.isEmpty(taxonomy.getIdentifier().getValue())) {
                    bl = false;
                }
                if (ForesterUtil.isEmpty(taxonomy.getTaxonomyCode())) {
                    bl2 = false;
                }
                if (!ForesterUtil.isEmpty(taxonomy.getScientificName())) continue;
                bl3 = false;
                continue;
            }
            throw new IllegalArgumentException("gene tree node [" + phylogenyNode + "] has no taxonomic data");
        }
        if (bl) {
            taxonomyComparisonBase = TaxonomyComparisonBase.ID;
        } else if (bl2) {
            taxonomyComparisonBase = TaxonomyComparisonBase.CODE;
        } else if (bl3) {
            taxonomyComparisonBase = TaxonomyComparisonBase.SCIENTIFIC_NAME;
        } else {
            throw new IllegalArgumentException("gene tree and species tree have incomparable taxonomies");
        }
        return taxonomyComparisonBase;
    }

    public int getDuplicationsSum() {
        return this._duplications_sum;
    }

    public Phylogeny getGeneTree() {
        return this._gene_tree;
    }

    public Phylogeny getSpeciesTree() {
        return this._species_tree;
    }

    void linkNodesOfG() throws SDIException {
        String string;
        PhylogenyNode phylogenyNode;
        HashMap<String, PhylogenyNode> hashMap = new HashMap<String, PhylogenyNode>();
        TaxonomyComparisonBase taxonomyComparisonBase = this.determineTaxonomyComparisonBase();
        PhylogenyNodeIterator phylogenyNodeIterator = this._species_tree.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            phylogenyNode = phylogenyNodeIterator.next();
            string = SDI.taxonomyToString(phylogenyNode, taxonomyComparisonBase);
            if (hashMap.containsKey(string)) {
                throw new IllegalArgumentException("taxonomy [" + phylogenyNode.getNodeData().getTaxonomy() + "] is not unique in species phylogeny");
            }
            hashMap.put(string, phylogenyNode);
        }
        phylogenyNodeIterator = this._gene_tree.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            phylogenyNode = phylogenyNodeIterator.next();
            string = SDI.taxonomyToString(phylogenyNode, taxonomyComparisonBase);
            PhylogenyNode phylogenyNode2 = (PhylogenyNode)hashMap.get(string);
            if (phylogenyNode2 == null) {
                throw new IllegalArgumentException("taxonomy [" + phylogenyNode.getNodeData().getTaxonomy() + "] not present in species tree");
            }
            phylogenyNode.setLink(phylogenyNode2);
        }
    }

    void linkNodesOfGByTaxonomyIdentifier() {
        PhylogenyNode phylogenyNode;
        PhylogenyNodeIterator phylogenyNodeIterator;
        HashMap<String, PhylogenyNode> hashMap = new HashMap<String, PhylogenyNode>();
        if (this._species_tree.getFirstExternalNode().isRoot()) {
            hashMap.put(this._species_tree.getFirstExternalNode().getNodeData().getTaxonomy().getIdentifier().getValue(), this._species_tree.getFirstExternalNode());
        } else {
            phylogenyNodeIterator = this._species_tree.iteratorExternalForward();
            while (phylogenyNodeIterator.hasNext()) {
                phylogenyNode = phylogenyNodeIterator.next();
                hashMap.put(phylogenyNode.getNodeData().getTaxonomy().getIdentifier().getValue(), phylogenyNode);
            }
        }
        phylogenyNodeIterator = this._gene_tree.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            phylogenyNode = phylogenyNodeIterator.next();
            PhylogenyNode phylogenyNode2 = (PhylogenyNode)hashMap.get(phylogenyNode.getNodeData().getTaxonomy().getIdentifier().getValue());
            if (phylogenyNode2 == null) {
                String string = "species [" + phylogenyNode.getNodeData().getTaxonomy().getIdentifier().getValue();
                string = string + "] not present in species tree";
                throw new IllegalArgumentException(string);
            }
            phylogenyNode.setLink(phylogenyNode2);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass());
        stringBuffer.append(ForesterUtil.LINE_SEPARATOR);
        stringBuffer.append("Duplications sum                   : " + this.getDuplicationsSum());
        stringBuffer.append(ForesterUtil.LINE_SEPARATOR);
        stringBuffer.append("mapping cost L                     : " + this.computeMappingCostL());
        return stringBuffer.toString();
    }

    static String taxonomyToString(PhylogenyNode phylogenyNode, TaxonomyComparisonBase taxonomyComparisonBase) {
        switch (taxonomyComparisonBase) {
            case ID: {
                Identifier identifier = phylogenyNode.getNodeData().getTaxonomy().getIdentifier();
                if (identifier == null) {
                    return null;
                }
                return identifier.getValuePlusProvider();
            }
            case CODE: {
                return phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode();
            }
            case SCIENTIFIC_NAME: {
                return phylogenyNode.getNodeData().getTaxonomy().getScientificName();
            }
        }
        throw new IllegalArgumentException("unknown comparison base for taxonomies: " + (Object)((Object)taxonomyComparisonBase));
    }

    public static enum TaxonomyComparisonBase {
        ID{

            public String toString() {
                return "taxonomy id";
            }
        }
        ,
        CODE{

            public String toString() {
                return "taxonomy code/mnemonic";
            }
        }
        ,
        SCIENTIFIC_NAME{

            public String toString() {
                return "scientific name";
            }
        };

    }
}

