/*
 * Decompiled with CFR 0.152.
 */
package org.forester.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;

public final class SupportCount {
    private SupportCount() {
    }

    public static double compare(Phylogeny phylogeny, Phylogeny phylogeny2, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        String[] stringArray = null;
        if (bl) {
            stringArray = phylogeny.getAllExternalNodeNames();
            SupportCount.strip(stringArray, phylogeny2);
        }
        if (bl3) {
            object = phylogeny.getFirstExternalNode().getName();
            phylogeny.reRoot(phylogeny.getNode((String)object));
            phylogeny2.reRoot(phylogeny2.getNode((String)object));
        }
        object = SupportCount.extractExternalNamesPerNode(phylogeny);
        return SupportCount.compare(phylogeny, phylogeny2, (Map<Integer, ArrayList<String>>)object, bl2, -1.0);
    }

    private static double compare(Phylogeny phylogeny, Phylogeny phylogeny2, Map<Integer, ArrayList<String>> map, boolean bl, double d) {
        int n = 0;
        int n2 = 0;
        Object object = phylogeny.iteratorPostorder();
        while (object.hasNext()) {
            if (object.next().isExternal()) continue;
            ++n2;
        }
        object = new HashMap();
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny2.iteratorPostorder();
        block1: while (phylogenyNodeIterator.hasNext()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (PhylogenyNode phylogenyNode : phylogenyNodeIterator.next().getAllExternalDescendants()) {
                arrayList.add(phylogenyNode.getName());
            }
            for (Integer n3 : map.keySet()) {
                List list = map.get(n3);
                if (list.size() != arrayList.size() || !list.containsAll(arrayList)) continue;
                if (list.size() > 1) {
                    ++n;
                }
                if (!bl) continue block1;
                PhylogenyNode phylogenyNode = phylogeny.getNode(n3);
                double d2 = PhylogenyMethods.getConfidenceValue(phylogenyNode);
                d2 = d2 < 1.0 ? 1.0 : (d2 += 1.0);
                object.put(phylogenyNode, new Double(d2));
                continue block1;
            }
        }
        double d3 = (double)n / (double)n2;
        if (d < 0.0 || d3 >= d) {
            for (PhylogenyNode phylogenyNode : object.keySet()) {
                double d4 = (Double)object.get(phylogenyNode);
                if (d4 < 0.0) {
                    d4 = 0.0;
                }
                PhylogenyMethods.setBootstrapConfidence(phylogenyNode, d4);
            }
        }
        return d3;
    }

    public static void count(Phylogeny phylogeny, Phylogeny[] phylogenyArray, boolean bl, boolean bl2) {
        SupportCount.count(phylogeny, phylogenyArray, bl, -1.0, bl2);
    }

    public static List<Phylogeny> count(Phylogeny phylogeny, Phylogeny[] phylogenyArray, boolean bl, double d, boolean bl2) {
        String[] stringArray = null;
        ArrayList<Phylogeny> arrayList = new ArrayList<Phylogeny>();
        if (bl) {
            stringArray = phylogeny.getAllExternalNodeNames();
        }
        String string = phylogeny.getFirstExternalNode().getName();
        phylogeny.reRoot(phylogeny.getNode(string));
        Map<Integer, ArrayList<String>> map = SupportCount.extractExternalNamesPerNode(phylogeny);
        if (bl2) {
            System.out.println();
            System.out.println("evaluator phylogeny #: similarity score (max is 1.0)");
            System.out.println("----------------------------------------------------");
            System.out.println();
        }
        for (int i = 0; i < phylogenyArray.length; ++i) {
            Phylogeny phylogeny2 = phylogenyArray[i];
            phylogeny2.reRoot(phylogeny2.getNode(string));
            Phylogeny phylogeny3 = phylogeny2;
            if (bl) {
                phylogeny3 = phylogeny2.copy();
                SupportCount.strip(stringArray, phylogeny2);
                PhylogenyMethods.orderAppearance(phylogeny2.getRoot(), true, true, PhylogenyMethods.DESCENDANT_SORT_PRIORITY.TAXONOMY);
                phylogeny2.externalNodesHaveChanged();
                phylogeny2.clearHashIdToNodeMap();
                phylogeny2.recalculateNumberOfExternalDescendants(true);
            }
            double d2 = SupportCount.compare(phylogeny, phylogenyArray[i], map, true, d);
            if (d < 0.0 || d2 >= d) {
                PhylogenyMethods.orderAppearance(phylogeny3.getRoot(), true, true, PhylogenyMethods.DESCENDANT_SORT_PRIORITY.TAXONOMY);
                arrayList.add(phylogeny3);
            }
            if (!bl2) continue;
            if (d < 0.0) {
                System.out.println(i + ": " + d2);
                continue;
            }
            if (d2 >= d) {
                System.out.println(i + ": " + d2 + " <====");
                continue;
            }
            System.out.println(i + ": " + d2);
        }
        if (bl2) {
            System.out.println("----------------------------------------------------");
            System.out.println();
        }
        return arrayList;
    }

    private static Map<Integer, ArrayList<String>> extractExternalNamesPerNode(Phylogeny phylogeny) throws NoSuchElementException {
        HashMap<Integer, ArrayList<String>> hashMap = new HashMap<Integer, ArrayList<String>>();
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            List<PhylogenyNode> list = phylogenyNode.getAllExternalDescendants();
            ArrayList<String> arrayList = new ArrayList<String>();
            hashMap.put(new Integer(phylogenyNode.getId()), arrayList);
            for (PhylogenyNode phylogenyNode2 : list) {
                arrayList.add(phylogenyNode2.getName());
            }
        }
        return hashMap;
    }

    private static void strip(String[] stringArray, Phylogeny phylogeny) {
        PhylogenyMethods.deleteExternalNodesPositiveSelection(stringArray, phylogeny);
    }
}

