/*
 * Decompiled with CFR 0.152.
 */
package smcsampler;

import ev.to.NexusWriter;
import fig.basic.IOUtils;
import fig.basic.Option;
import java.io.File;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import ma.MSAParser;
import ma.MSAPoset;
import ma.RateMatrixLoader;
import ma.SequenceType;
import nuts.io.IO;
import nuts.lang.StringUtils;
import nuts.util.CollUtils;
import pty.RootedTree;

public class MrBayes
implements Runnable {
    public static final MrBayes instance = new MrBayes();
    @Option
    public String mrBayesPath = "mb";
    @Option
    public int nMCMCIters = 10000;
    @Option
    public int nChains = 1;
    @Option
    public int seed = 1297732343;
    @Option
    public String treePrior = "clock:coalescence";
    @Option
    public double mbRate = 1.0;
    @Option
    public boolean setToK2P = false;
    @Option
    public boolean setFixCoalescentPr = true;
    @Option
    public boolean fixNucleotideFreq = false;
    @Option
    public boolean set2nst = false;
    @Option
    public boolean setGTRGammaI = false;
    @Option
    public boolean setInv = false;
    @Option
    public boolean fixGTRGammaPara = false;
    @Option
    public double alpha = 0.5;
    @Option
    public double[] stationaryDistribution = new double[]{0.2, 0.26, 0.33, 0.21};
    @Option
    public double[] subsRates = new double[]{0.26, 0.18, 0.17, 0.15, 0.11, 0.13};
    @Option
    public double mb_trans2tranv = 2.0;
    @Option
    public boolean setstarttree = false;
    @Option
    public boolean setSSinMB = false;
    @Option
    public SequenceType st = SequenceType.RNA;
    @Option
    public File alignmentInputFile = null;
    private File workingDir = null;
    private String starttreeString = "";
    public static final String NEX_FILE = "data.nex";
    private static final Pattern translPattern = Pattern.compile("\\s*([0-9]+)\\s(.*)[,;]");
    private static final Pattern newickPattern = Pattern.compile(".*[=]\\s(.*)[;]");

    public File computeSamples(MSAPoset alignment, SequenceType st) {
        this.workingDir = IO.getTempDir((String)"temp-mrbayes");
        File nexusFile = new File(this.workingDir, NEX_FILE);
        File mrBayesCmd = new File(this.workingDir, "mrbayes.cmd");
        NexusWriter.writeNexus((MSAPoset)alignment, (File)nexusFile, (SequenceType)st);
        this.writeMrBayesCmd(mrBayesCmd);
        String msg = IO.call((String)("" + this.mrBayesPath + " " + mrBayesCmd.getName()), null, (File)this.workingDir);
        IO.writeToDisk((File)new File(this.workingDir, "mrbayes-stdout"), (String)msg);
        return this.workingDir;
    }

    public void processMrBayesTrees(RootedTree.RootedTreeProcessor rtp) {
        this.processMrBayesTrees(rtp, 1);
    }

    public void setStartTree(String startTree) {
        this.starttreeString = startTree;
        if (!this.setstarttree) {
            this.setstarttree = true;
        }
    }

    public String getStartTree() {
        return this.starttreeString;
    }

    public void cleanUpMrBayesOutput() {
        for (File f : IO.ls((File)this.workingDir)) {
            f.delete();
        }
        this.workingDir.delete();
    }

    public void processMrBayesTrees(RootedTree.RootedTreeProcessor rtp, int runNumber) {
        MrBayes.processMrBayesTrees(new File(this.workingDir, "data.nex.run" + runNumber + ".t"), rtp);
    }

    public static void processMrBayesTrees(File file, RootedTree.RootedTreeProcessor rtp) {
        Map<String, String> translation = MrBayes.translation(file);
        for (String line : IO.i((File)file)) {
            if (!line.matches("^\\s*tree rep.*") && !line.matches("^\\s*tree gen.*")) continue;
            rtp.process(MrBayes.parseTree(line, translation));
        }
    }

    private static Map<String, String> translation(File file) {
        String line;
        HashMap trans = CollUtils.map();
        Iterator iterator = IO.i((File)file).iterator();
        while (iterator.hasNext() && !newickPattern.matcher(line = (String)iterator.next()).matches()) {
            if (!translPattern.matcher(line).matches()) continue;
            List matches = StringUtils.multiSelectFirstRegex((Pattern)translPattern, (String)line);
            trans.put(matches.get(0), matches.get(1));
        }
        return trans;
    }

    private static RootedTree parseTree(String line, Map<String, String> translation) {
        String newickStr = StringUtils.selectFirstRegex((Pattern)newickPattern, (String)line);
        newickStr = newickStr.substring(4);
        for (String code : translation.keySet()) {
            String codeCtx = StringUtils.selectFirstRegex((String)("([,)(])" + code + "[:]"), (String)newickStr);
            newickStr = newickStr.replace(codeCtx + code + ":", codeCtx + translation.get(code) + ":");
        }
        newickStr = newickStr + ";";
        return RootedTree.Util.fromNewickString((String)newickStr);
    }

    private void writeMrBayesCmd(File mrBayesCmd) {
        RateMatrixLoader.DEFAULT_TRANS2TRANV = this.mb_trans2tranv;
        double b4 = RateMatrixLoader.beta((double)RateMatrixLoader.DEFAULT_TRANS2TRANV) * 4.0;
        double a4 = RateMatrixLoader.alpha((double)RateMatrixLoader.DEFAULT_TRANS2TRANV) * 4.0;
        String fixGtrGammaStr = null;
        if (this.fixGTRGammaPara) {
            fixGtrGammaStr = "prset statefreqpr=fixed(" + this.stationaryDistribution[0] + "," + this.stationaryDistribution[1] + "," + this.stationaryDistribution[2] + "," + this.stationaryDistribution[3] + ");\nprset revmatpr=fixed(" + this.subsRates[0] + "," + this.subsRates[1] + "," + this.subsRates[2] + "," + this.subsRates[3] + "," + this.subsRates[4] + "," + this.subsRates[5] + ");\nprset shape=fixed(" + this.alpha + ");\n";
        }
        if (this.setstarttree) {
            File treeCmd = new File(this.workingDir, "start.tree");
            PrintWriter outtree = IOUtils.openOutEasy((File)treeCmd);
            outtree.append("execute data.nex;\nbegin trees;\ntree starttree=" + this.starttreeString + "\nend;\n\n");
            outtree.close();
            String cmdStr = "cat start.tree | sed 's/internal_[0-9]*_[0-9]*//g' > mrbayes.cmd";
            IO.call((String)"bash -s", (String)cmdStr, (File)this.workingDir);
        }
        PrintWriter out = IOUtils.openOutAppendEasy((File)mrBayesCmd);
        out.append("begin mrbayes;\nset autoclose=yes nowarn=yes;\n" + (this.setstarttree ? "" : "execute data.nex;\n") + "prset brlenspr=" + this.treePrior + (this.mbRate == 1.0 ? "" : "(" + this.mbRate + ")") + ";\nmcmcp ngen=" + this.nMCMCIters + ";\nmcmcp Nchains=" + this.nChains + ";\nset seed=" + Math.abs(this.seed) + ";\nset scientific=no;\n" + (this.setGTRGammaI ? " lset nst=6 rates=" + (this.setInv ? "invgamma" : "gamma") + " ngammacat=4;\nprset tratiopr = beta(1, 1);\n" : "") + (this.set2nst ? "lset nst=2;\nprset tratiopr = beta(1, 1);\n" : "lset nst=6;\n") + (this.fixNucleotideFreq ? "prset statefreqpr=fixed(0.25,0.25,0.25,0.25);\n" : "") + (this.setToK2P ? "prset revmatpr=fixed(" + b4 + "," + a4 + "," + b4 + "," + b4 + "," + a4 + "," + b4 + ");\n" : "") + (this.fixGTRGammaPara ? fixGtrGammaStr : "") + (this.setstarttree ? "startvals  tau = starttree;\nstartvals  V = starttree;\n" : "") + (this.setSSinMB ? "ss;\n" : "mcmc;\nsumt;\n") + "end;\n");
        out.close();
    }

    public static void main(String[] args) {
        String newickStr = "(Selaginella_uncinata:0.1,((Panax_ginseng:0.1,Daucus_carota:0.1):0.1,Liriodendron_tulipifera:0.1):0.1,Coffea_arabica:0.1);";
        RootedTree rt = RootedTree.Util.fromNewickString((String)newickStr);
        System.out.println(rt);
    }

    @Override
    public void run() {
        MSAPoset align = MSAParser.parseMSA((File)this.alignmentInputFile);
        this.computeSamples(align, this.st);
        this.processMrBayesTrees(new RootedTree.RootedTreeProcessor(){

            public void process(RootedTree rt) {
                System.out.println(rt);
            }
        });
    }
}

