/*
 * Decompiled with CFR 0.152.
 */
package tutorialj;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import spoon.processing.AbstractAnnotationProcessor;
import spoon.reflect.declaration.CtElement;
import tutorialj.Main;
import tutorialj.Tutorial;
import tutorialj.TutorialNode;

public class GenerateTutorials
extends AbstractAnnotationProcessor<Tutorial, CtElement> {
    private List<TutorialNode> tutorialNodesInOrder = Lists.newArrayList();
    private Map<String, LinkedList<TutorialNode>> nodesPerTypeName = Maps.newHashMap();
    private String startType = null;
    private String outputName;
    private static final String commentLine = "<!-- File generated by tutorialj -->";

    public void processingDone() {
        for (LinkedList<TutorialNode> list : this.nodesPerTypeName.values()) {
            Collections.sort(list, new Comparator<TutorialNode>(){

                @Override
                public int compare(TutorialNode t0, TutorialNode t1) {
                    return Integer.valueOf(t0.getLineNumber()).compareTo(t1.getLineNumber());
                }
            });
        }
        this.traverseOrder(this.startType);
        if (!this.isStartDefined()) {
            throw new RuntimeException("One node should have a startTutorial(String name) attribute, where name specifies the name of the output file.");
        }
        File outputFile = this.getAndCheckOutputFile();
        StringBuilder out = new StringBuilder();
        out.append("<!-- File generated by tutorialj -->\n");
        for (TutorialNode node : this.tutorialNodesInOrder) {
            out.append(node.toString() + "\n");
        }
        try {
            Files.write((CharSequence)out, (File)outputFile, (Charset)Charsets.UTF_8);
            Main.success = true;
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    private File getAndCheckOutputFile() {
        File candidate = new File(this.outputName);
        if (!candidate.exists()) {
            return candidate;
        }
        try {
            String firstLine = Files.readFirstLine((File)candidate, (Charset)Charsets.UTF_8);
            if (!commentLine.equals(firstLine)) {
                throw new RuntimeException("Looks like the file " + candidate.getAbsolutePath() + " was not generated by tutorialj (it does not start with \"" + commentLine + "\", " + "so we will not overwrite it.");
            }
            return candidate;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isStartDefined() {
        return this.startType != null;
    }

    private void traverseOrder(String currentType) {
        LinkedList currentQueue = (LinkedList)Optional.fromNullable(this.nodesPerTypeName.get(currentType)).or((Object)Lists.newLinkedList());
        while (!currentQueue.isEmpty()) {
            TutorialNode current = (TutorialNode)currentQueue.pollFirst();
            this.tutorialNodesInOrder.add(current);
            if (!current.hasJump()) continue;
            this.traverseOrder(current.getJumpTarget());
        }
    }

    public void process(Tutorial tutorialEntry, CtElement element) {
        TutorialNode node = new TutorialNode(tutorialEntry, element);
        String enclosingType = node.getEnclosingTypeName();
        LinkedList currentQueue = this.nodesPerTypeName.get(enclosingType);
        if (currentQueue == null) {
            currentQueue = Lists.newLinkedList();
            this.nodesPerTypeName.put(enclosingType, currentQueue);
        }
        currentQueue.add((TutorialNode)node);
        if (node.isTutorialStart()) {
            if (this.startType != null) {
                System.err.println("WARNING: two tutorial starts defined, but multiple tutorials currently not supported. Resetting the tutorial start for now; some of your tutorial nodes mightnot show up.");
            }
            this.startType = node.getEnclosingTypeName();
            this.outputName = tutorialEntry.startTutorial();
        }
    }
}

