/*
 * Decompiled with CFR 0.152.
 */
package org.jblas.util;

import org.jblas.util.LibraryLoader;
import org.jblas.util.Logger;

public class ArchFlavor {
    private static String fixedFlavor;
    public static final int SSE = 1;
    public static final int SSE2 = 2;
    public static final int SSE3 = 3;
    public static final int NO_SSE = -1;

    public static native int SSELevel();

    public static String archFlavor() {
        if (fixedFlavor != null) {
            return fixedFlavor;
        }
        String arch = System.getProperty("os.arch");
        String name = System.getProperty("os.name");
        if (name.startsWith("Windows") && arch.equals("amd64")) {
            return null;
        }
        if (arch.equals("i386") || arch.equals("x86") || arch.equals("x86_64") || arch.equals("amd64")) {
            switch (ArchFlavor.SSELevel()) {
                case 1: {
                    return "sse";
                }
                case 2: {
                    return "sse2";
                }
                case 3: {
                    return "sse3";
                }
            }
            return null;
        }
        return null;
    }

    public static void overrideArchFlavor(String flavor) {
        fixedFlavor = flavor;
    }

    static {
        try {
            System.loadLibrary("jblas_arch_flavor");
        }
        catch (UnsatisfiedLinkError e) {
            Logger.getLogger().config("ArchFlavor native library not found in path. Copying native library libjblas_arch_flavor from the archive. Consider installing the library somewhere in the path (for Windows: PATH, for Linux: LD_LIBRARY_PATH).");
            new LibraryLoader().loadLibrary("jblas_arch_flavor", false, false);
        }
        fixedFlavor = null;
    }
}

