/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.matrices;

import JSci.maths.algebras.Module;
import JSci.maths.algebras.VectorSpace;
import JSci.maths.fields.Field;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;
import JSci.maths.matrices.Matrix;
import JSci.maths.matrices.MatrixDimensionException;

public class RingMatrix
extends Matrix {
    protected Ring.Member[][] matrix;

    protected RingMatrix(int n, int n2) {
        super(n, n2);
    }

    public RingMatrix(Ring.Member[][] memberArray) {
        this(memberArray.length, memberArray[0].length);
        this.matrix = memberArray;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof RingMatrix && this.numRows == ((RingMatrix)object).rows() && this.numCols == ((RingMatrix)object).columns()) {
            RingMatrix ringMatrix = (RingMatrix)object;
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    if (this.matrix[i][j].equals(ringMatrix.getElement(i, j))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5 * this.numRows * this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                stringBuffer.append(this.matrix[i][j].toString());
                stringBuffer.append(' ');
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public Ring.Member getElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            return this.matrix[n][n2];
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public void setElement(int n, int n2, Ring.Member member) {
        if (n < 0 || n >= this.numRows || n2 < 0 || n2 >= this.numCols) {
            throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        }
        this.matrix[n][n2] = member;
    }

    public Object getSet() {
        throw new RuntimeException("Not yet implemented: please file bug report");
    }

    public AbelianGroup.Member negate() {
        Ring.Member[][] memberArray = new Ring.Member[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            memberArray[i][0] = (Ring.Member)this.matrix[i][0].negate();
            for (int j = 1; j < this.numCols; ++j) {
                memberArray[i][j] = (Ring.Member)this.matrix[i][j].negate();
            }
        }
        return new RingMatrix(memberArray);
    }

    public final AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof RingMatrix) {
            return this.add((RingMatrix)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RingMatrix add(RingMatrix ringMatrix) {
        if (this.numRows == ringMatrix.numRows && this.numCols == ringMatrix.numCols) {
            Ring.Member[][] memberArray = new Ring.Member[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                memberArray[i][0] = (Ring.Member)this.matrix[i][0].add(ringMatrix.getElement(i, 0));
                for (int j = 1; j < this.numCols; ++j) {
                    memberArray[i][j] = (Ring.Member)this.matrix[i][j].add(ringMatrix.getElement(i, j));
                }
            }
            return new RingMatrix(memberArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public final AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof RingMatrix) {
            return this.subtract((RingMatrix)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RingMatrix subtract(RingMatrix ringMatrix) {
        if (this.numRows == ringMatrix.numRows && this.numCols == ringMatrix.numCols) {
            Ring.Member[][] memberArray = new Ring.Member[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                memberArray[i][0] = (Ring.Member)this.matrix[i][0].subtract(ringMatrix.getElement(i, 0));
                for (int j = 1; j < this.numCols; ++j) {
                    memberArray[i][j] = (Ring.Member)this.matrix[i][j].subtract(ringMatrix.getElement(i, j));
                }
            }
            return new RingMatrix(memberArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public Module.Member scalarMultiply(Ring.Member member) {
        Ring.Member[][] memberArray = new Ring.Member[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            memberArray[i][0] = member.multiply(this.matrix[i][0]);
            for (int j = 1; j < this.numCols; ++j) {
                memberArray[i][j] = member.multiply(this.matrix[i][j]);
            }
        }
        return new RingMatrix(memberArray);
    }

    public VectorSpace.Member scalarDivide(Field.Member member) {
        Ring.Member[][] memberArray = new Ring.Member[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            memberArray[i][0] = ((Field.Member)this.matrix[i][0]).divide(member);
            for (int j = 1; j < this.numCols; ++j) {
                memberArray[i][j] = ((Field.Member)this.matrix[i][j]).divide(member);
            }
        }
        return new RingMatrix(memberArray);
    }

    public final Ring.Member multiply(Ring.Member member) {
        if (member instanceof RingMatrix) {
            return this.multiply((RingMatrix)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RingMatrix multiply(RingMatrix ringMatrix) {
        if (this.numCols == ringMatrix.numRows) {
            Ring.Member[][] memberArray = new Ring.Member[this.numRows][ringMatrix.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < ringMatrix.numCols; ++j) {
                    AbelianGroup.Member member = this.matrix[i][0].multiply(ringMatrix.getElement(0, j));
                    for (int k = 1; k < this.numCols; ++k) {
                        member = member.add(this.matrix[i][k].multiply(ringMatrix.getElement(k, j)));
                    }
                    memberArray[i][j] = member;
                }
            }
            return new RingMatrix(memberArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public RingMatrix directSum(RingMatrix ringMatrix) {
        int n;
        int n2;
        Ring.Member[][] memberArray = new Ring.Member[this.numRows + ringMatrix.numRows][this.numCols + ringMatrix.numCols];
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < this.numCols; ++n) {
                memberArray[n2][n] = this.matrix[n2][n];
            }
        }
        for (n2 = 0; n2 < ringMatrix.numRows; ++n2) {
            for (n = 0; n < ringMatrix.numCols; ++n) {
                memberArray[n2 + this.numRows][n + this.numCols] = ringMatrix.getElement(n2, n);
            }
        }
        return new RingMatrix(memberArray);
    }

    public RingMatrix tensor(RingMatrix ringMatrix) {
        Ring.Member[][] memberArray = new Ring.Member[this.numRows * ringMatrix.numRows][this.numCols * ringMatrix.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                int n = 0;
                while (n < ringMatrix.numRows) {
                    for (int k = 0; k < ringMatrix.numCols; ++k) {
                        memberArray[i * ringMatrix.numRows + n][j * ringMatrix.numCols + k] = this.matrix[i][j].multiply(ringMatrix.getElement(n, k));
                    }
                    ++j;
                }
            }
        }
        return new RingMatrix(memberArray);
    }

    public Matrix transpose() {
        Ring.Member[][] memberArray = new Ring.Member[this.numCols][this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            memberArray[0][i] = this.matrix[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                memberArray[j][i] = this.matrix[i][j];
            }
        }
        return new RingMatrix(memberArray);
    }
}

