/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml.data;

import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.data.IdentifierParser;
import org.forester.io.parsers.phyloxml.data.PhylogenyDataPhyloXmlParser;
import org.forester.io.parsers.phyloxml.data.UriParser;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.data.Uri;

public class TaxonomyParser
implements PhylogenyDataPhyloXmlParser {
    private static final PhylogenyDataPhyloXmlParser _instance;

    private TaxonomyParser() {
    }

    @Override
    public Taxonomy parse(XmlElement xmlElement) throws PhyloXmlDataFormatException {
        Taxonomy taxonomy = new Taxonomy();
        for (int i = 0; i < xmlElement.getNumberOfChildElements(); ++i) {
            XmlElement xmlElement2 = xmlElement.getChildElement(i);
            if (!xmlElement2.isHasValue()) continue;
            if (xmlElement2.getQualifiedName().equals("code")) {
                taxonomy.setTaxonomyCode(xmlElement2.getValueAsString());
                continue;
            }
            if (xmlElement2.getQualifiedName().equals("common_name")) {
                taxonomy.setCommonName(xmlElement2.getValueAsString());
                continue;
            }
            if (xmlElement2.getQualifiedName().equals("authority")) {
                taxonomy.setAuthority(xmlElement2.getValueAsString());
                continue;
            }
            if (xmlElement2.getQualifiedName().equals("synonym")) {
                taxonomy.getSynonyms().add(xmlElement2.getValueAsString());
                continue;
            }
            if (xmlElement2.getQualifiedName().equals("id")) {
                taxonomy.setIdentifier((Identifier)IdentifierParser.getInstance().parse(xmlElement2));
                continue;
            }
            if (xmlElement2.getQualifiedName().equals("rank")) {
                taxonomy.setRank(xmlElement2.getValueAsString());
                continue;
            }
            if (xmlElement2.getQualifiedName().equals("scientific_name")) {
                taxonomy.setScientificName(xmlElement2.getValueAsString());
                continue;
            }
            if (!xmlElement2.getQualifiedName().equals("uri")) continue;
            taxonomy.addUri((Uri)UriParser.getInstance().parse(xmlElement2));
        }
        return taxonomy;
    }

    public static PhylogenyDataPhyloXmlParser getInstance() {
        return _instance;
    }

    static {
        try {
            _instance = new TaxonomyParser();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.getMessage());
        }
    }
}

