/*
 * Decompiled with CFR 0.152.
 */
package cognates;

public class LanguageTreeNode
implements Comparable<LanguageTreeNode> {
    private char[] sequence = null;
    private String label;
    private double timeDepth;
    private LanguageTreeNode parent = null;
    private LanguageTreeNode leftChild = null;
    private LanguageTreeNode rightChild = null;

    public LanguageTreeNode(String label, char[] sequence) {
        this.label = label;
        this.sequence = sequence;
    }

    public LanguageTreeNode(LanguageTreeNode left, LanguageTreeNode right) {
        this.label = "(left:" + left.label + ") (right:" + right.label;
    }

    public char getSequence(int index) {
        return this.sequence[index];
    }

    public char[] getSequence() {
        return this.sequence;
    }

    public void setParent(LanguageTreeNode parent) {
        this.parent = parent;
    }

    public LanguageTreeNode getParent() {
        return this.parent;
    }

    public LanguageTreeNode getLeftChild() {
        return this.leftChild;
    }

    public LanguageTreeNode getRightChild() {
        return this.rightChild;
    }

    public boolean isNbr(LanguageTreeNode node) {
        if (node == null) {
            return false;
        }
        return node == this.parent || node == this.leftChild || node == this.rightChild;
    }

    public boolean isLeaf() {
        return this.leftChild == null && this.rightChild == null;
    }

    public boolean equals(LanguageTreeNode other) {
        return this.label.equals(other.label) && this.timeDepth == other.timeDepth;
    }

    @Override
    public int compareTo(LanguageTreeNode other) {
        if (this.timeDepth < other.timeDepth) {
            return -1;
        }
        if (this.timeDepth > other.timeDepth) {
            return 1;
        }
        return 0;
    }
}

