/*
 * Decompiled with CFR 0.152.
 */
package conifer.exp;

import conifer.data.PhylogeneticData;
import conifer.evol.PIPLikelihoodModel;
import conifer.exp.Experiment;
import conifer.exp.ExperimentOptions;
import conifer.exp.ExperimentsUtils;
import conifer.exp.PrepareExperimentsContext;
import conifer.msa.TreeMSAState;
import conifer.particle.PhyloParticle;
import ev.poi.PoissonParameters;
import gep.util.OutputManager;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import nuts.io.OutputProducer;
import nuts.math.StatisticsMap;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import pty.smc.ParticleFilter;

public class ParamExperiment
implements Experiment,
OutputProducer {
    private final PhylogeneticData originalData;
    private final OutputManager manager = new OutputManager();
    private final ParamProcessor paramProcessor;
    private final PrepareExperimentsContext experimentContext;
    private final ExperimentOptions options;
    private final boolean comparisonPossible;
    public static final String MU = "mu";
    public static final String LAMBDA = "lambda";
    public static final String LEN = "len";
    public static final String INTENS = "intens";
    public static final String RATIO = "ttratio";
    public Map<String, Double> refs = null;

    public ParamExperiment(PhylogeneticData data, ExperimentOptions options, PrepareExperimentsContext context) {
        this.originalData = data;
        this.comparisonPossible = data.generatingEvolutionaryOptions != null && data.generatingEvolutionaryOptions instanceof PIPLikelihoodModel;
        this.experimentContext = context;
        this.options = options;
        this.paramProcessor = new ParamProcessor();
        if (this.comparisonPossible) {
            this.refs = new HashMap<String, Double>();
            PoissonParameters refpip = ((PIPLikelihoodModel)data.generatingEvolutionaryOptions).params;
            double lambda = refpip.insertRate;
            double mu = refpip.deleteRate;
            double len = PoissonParameters.getAsymptoticLengthParameterForAdditiveIntensityParam(lambda, mu);
            double inte = PoissonParameters.getIndelIntensityParameterForAdditiveIntensityParam(lambda, mu);
            double ratio = ParamExperiment.extractTTRatio(refpip.subRateMtx);
            this.refs.put(RATIO, ratio);
            this.refs.put(MU, mu);
            this.refs.put(LAMBDA, lambda);
            this.refs.put(LEN, len);
            this.refs.put(INTENS, inte);
        }
    }

    @Override
    public PhylogeneticData getDataAfterHoldingOut() {
        return this.comparisonPossible ? this.originalData.holdoutGeneratingParams() : this.originalData;
    }

    public static double extractTTRatio(double[][] rateMtx) {
        double alpha = rateMtx[0][2];
        return alpha / (1.0 - alpha);
    }

    @Override
    public void monitor(Object ... _algorithmContext) {
        Object[] currentContext = ExperimentsUtils.concat(_algorithmContext, this.experimentContext.getContext());
        for (ReconType rt : ReconType.values()) {
            this.monitorReconstruction(rt, currentContext);
        }
    }

    public void monitorReconstruction(ReconType rt, Object[] currentContext) {
        for (String paramName : this.paramProcessor.map.keySet()) {
            double value = Double.NaN;
            double lower = Double.NaN;
            double upper = Double.NaN;
            DescriptiveStatistics curSS = this.paramProcessor.statMap.getDescriptiveStat(paramName);
            if (rt == ReconType.mean) {
                value = curSS.getMean();
                double sd = curSS.getStandardDeviation();
                lower = value - sd;
                upper = value + sd;
            } else if (rt == ReconType.med) {
                value = curSS.getPercentile(50.0);
                lower = curSS.getPercentile(25.0);
                upper = curSS.getPercentile(75.0);
            } else if (rt == ReconType.sample) {
                value = this.paramProcessor.map.get(paramName);
            }
            double absError = Double.NaN;
            double errorSqr = Double.NaN;
            double isIn = Double.NaN;
            if (this.comparisonPossible) {
                double refVal = this.refs.get(paramName);
                absError = Math.abs(refVal - value);
                errorSqr = absError * absError;
                isIn = refVal >= lower && refVal <= upper ? 1.0 : 0.0;
            }
            this.manager.write("params", ExperimentsUtils.concat(currentContext, new Object[]{"type", rt, "param", paramName, "value", value, "lower", lower, "upper", upper, "absErr", absError, "sqrErr", errorSqr, "isInInterv", isIn}));
        }
    }

    @Override
    public ParticleFilter.ParticleProcessor<PhyloParticle> getProcessor() {
        return this.paramProcessor;
    }

    @Override
    public void setOutputFolder(File f) {
        this.manager.setOutputFolder(f);
    }

    @Override
    public String name() {
        return "param-reconstructions";
    }

    private static enum ReconType {
        mean,
        med,
        sample;

    }

    public static class ParamProcessor
    implements ParticleFilter.ParticleProcessor<PhyloParticle> {
        public StatisticsMap.DescriptiveStatisticsMap<String> statMap = new StatisticsMap.DescriptiveStatisticsMap();
        public Map<String, Double> map = new HashMap<String, Double>();

        @Override
        public void process(PhyloParticle _state, double weight) {
            TreeMSAState state = (TreeMSAState)_state;
            PIPLikelihoodModel pip = (PIPLikelihoodModel)state.params;
            double mu = pip.params.deleteRate;
            double lambda = pip.params.insertRate;
            double len = PoissonParameters.getAsymptoticLengthParameterForAdditiveIntensityParam(lambda, mu);
            double inte = PoissonParameters.getIndelIntensityParameterForAdditiveIntensityParam(lambda, mu);
            double ratio = ParamExperiment.extractTTRatio(pip.params.Q);
            this.statMap.addValue(ParamExperiment.RATIO, ratio);
            this.map.put(ParamExperiment.RATIO, ratio);
            this.statMap.addValue(ParamExperiment.MU, mu);
            this.map.put(ParamExperiment.MU, mu);
            this.statMap.addValue(ParamExperiment.LAMBDA, lambda);
            this.map.put(ParamExperiment.LAMBDA, lambda);
            this.statMap.addValue(ParamExperiment.LEN, len);
            this.map.put(ParamExperiment.LEN, len);
            this.statMap.addValue(ParamExperiment.INTENS, inte);
            this.map.put(ParamExperiment.INTENS, inte);
        }
    }
}

