/*
 * Decompiled with CFR 0.152.
 */
package conifer.exp;

import conifer.data.PhylogeneticData;
import conifer.exp.Experiment;
import conifer.exp.ExperimentOptions;
import conifer.exp.ExperimentsUtils;
import conifer.exp.PrepareExperimentsContext;
import conifer.particle.PhyloParticle;
import ev.poi.processors.TreeDistancesProcessor;
import gep.util.OutputManager;
import java.io.File;
import nuts.io.OutputProducer;
import pty.UnrootedTree;
import pty.io.TreeEvaluator;
import pty.smc.ParticleFilter;

public class TreeReconstructionExperiment
implements Experiment,
OutputProducer {
    private final PhylogeneticData originalData;
    private final TreeDistancesProcessor processor;
    private final OutputManager manager = new OutputManager();
    private final PrepareExperimentsContext experimentContext;
    private final ExperimentOptions options;

    public TreeReconstructionExperiment(PhylogeneticData data, ExperimentOptions options, PrepareExperimentsContext context) {
        this.originalData = data;
        this.processor = new TreeDistancesProcessor();
        this.experimentContext = context;
        this.options = options;
    }

    @Override
    public PhylogeneticData getDataAfterHoldingOut() {
        return this.originalData.holdoutPhylogeny();
    }

    @Override
    public void monitor(Object ... _algorithmContext) {
        Object[] currentContext = ExperimentsUtils.concat(_algorithmContext, this.experimentContext.getContext());
        if (this.options.useNinja) {
            this.monitorReconstruction("ninja", this.processor.getConsensus(true), Double.NaN, currentContext);
        }
        if (this.options.useNJ) {
            this.monitorReconstruction("NJ", this.processor.getConsensus(false), Double.NaN, currentContext);
        }
        if (this.options.useLikelihoodMode) {
            this.monitorReconstruction("likelihoodMode", this.processor.getMode().getUnrooted(), this.processor.getBestLogLikelihood(), currentContext);
        }
        this.monitorReconstruction("sample", this.processor.lastPhylo.getUnrooted(), this.processor.lastLogLikelihood, currentContext);
    }

    public void monitorReconstruction(String methodName, UnrootedTree consensus, double ll, Object[] currentContext) {
        UnrootedTree original = this.originalData.getPhylogeny().getUnrooted();
        double reftotalBL = original.totalBranchLength();
        double totalBL = consensus.totalBranchLength();
        for (TreeEvaluator.TreeMetric tm : TreeEvaluator.coreTreeMetrics) {
            double value = tm.score(original, consensus);
            String name = tm.toString();
            this.manager.write("treeMetrics", ExperimentsUtils.concat(currentContext, "reconstruction-method", methodName, "metric", name, "value", value, "totalBL", totalBL, "refTotalBL", reftotalBL, "loglikelihood", Double.isNaN(ll) ? "" : Double.valueOf(ll)));
        }
        if (this.options.saveReconstructions) {
            this.manager.write("treeReconstructions", ExperimentsUtils.concat(currentContext, "reconstruction-method", methodName, "consensus-tree", consensus.toNewick(), "loglikelihood", Double.isNaN(ll) ? "" : Double.valueOf(ll)));
        }
    }

    @Override
    public ParticleFilter.ParticleProcessor<PhyloParticle> getProcessor() {
        return this.processor;
    }

    @Override
    public void setOutputFolder(File f) {
        this.manager.setOutputFolder(f);
    }

    @Override
    public String name() {
        return "tree-reconstructions";
    }
}

