/*
 * Decompiled with CFR 0.152.
 */
package dht;

import dht.EC2Main;
import fig.basic.LogInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import nuts.io.IO;

public class SocketTest
extends EC2Main
implements Runnable {
    @Override
    public void run() {
        LogInfo.logs("Want to test communication via privateIp...");
        if (this.nodeId == 0) {
            ServerSocket serverSocket = null;
            try {
                serverSocket = new ServerSocket(8888);
            }
            catch (IOException e) {
                LogInfo.logs(e);
                System.exit(1);
            }
            Socket clientSocket = null;
            try {
                String inputLine;
                clientSocket = serverSocket.accept();
                PrintWriter out = new PrintWriter(clientSocket.getOutputStream(), true);
                BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
                out.println("hello");
                while ((inputLine = in.readLine()) != null) {
                    LogInfo.logs("client msg received:" + inputLine);
                    if (inputLine.equals("end")) break;
                    out.println("continue writing");
                }
                out.close();
                in.close();
                clientSocket.close();
                serverSocket.close();
            }
            catch (IOException e) {
                LogInfo.logs(e);
                System.exit(1);
            }
        } else {
            LogInfo.logs("privateIp=" + this.bootstrapIp);
            Socket clientSocket = null;
            try {
                clientSocket = new Socket(this.bootstrapIp, 8888);
                PrintWriter out = new PrintWriter(clientSocket.getOutputStream(), true);
                BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
                for (int i = 0; i < 5; ++i) {
                    String inputLine = in.readLine();
                    if (inputLine != null) {
                        LogInfo.logs("received msg:" + inputLine);
                    } else {
                        System.exit(1);
                    }
                    LogInfo.logs("send msg:" + i);
                    out.println("" + i);
                }
                out.println("end");
                out.close();
                in.close();
                clientSocket.close();
            }
            catch (UnknownHostException e) {
                LogInfo.logs("Host unknown");
                LogInfo.logs(e);
                System.exit(1);
            }
            catch (IOException e) {
                LogInfo.logs(e);
                System.exit(1);
            }
        }
    }

    public static void main(String[] args) {
        IO.run(args, new SocketTest());
    }
}

