/*
 * Decompiled with CFR 0.152.
 */
package emc;

import java.io.Serializable;

public class EMCParticle<S>
implements Serializable {
    private static final long serialVersionUID = 21L;
    private Long id;
    private Long seed;
    private Double weight;
    private S sample;
    private long r;
    private transient EMCParticle<S> parent;
    public transient int numResampled;
    public transient int nodeId;

    public EMCParticle(int nodeId, long r, long k, long K, long max) {
        this.r = r;
        this.id = r == -1L ? new Long(-1L) : Long.valueOf((long)nodeId * max + r * K + k);
        this.nodeId = nodeId;
        this.sample = null;
        this.numResampled = 0;
    }

    public EMCParticle(EMCParticle<S> particle) {
        this.r = particle.r;
        this.id = particle.id;
        this.seed = particle.seed;
        this.weight = particle.weight;
        this.sample = particle.sample;
        this.parent = particle.parent;
        this.nodeId = particle.nodeId;
    }

    public long getGeneration() {
        return this.r;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public long getId() {
        return this.id;
    }

    public long getSeed() {
        return this.seed;
    }

    public double getWeight() {
        return this.weight;
    }

    public EMCParticle<S> getParent() {
        return this.parent;
    }

    public S getSample() {
        return this.sample;
    }

    public int getNumResampled() {
        return this.numResampled;
    }

    public void setSample(S sample, Double w) {
        this.sample = sample;
        this.weight = new Double(w);
    }

    public void setSeed(long seed) {
        this.seed = new Long(seed);
    }

    public void setParent(EMCParticle<S> parent) {
        this.parent = parent;
    }

    public void setNumResampled(int num) {
        this.numResampled = num;
    }
}

