/*
 * Decompiled with CFR 0.152.
 */
package ev.ex;

import fig.basic.UnorderedPair;
import fig.prob.Distrib;
import goblin.Taxon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import nuts.math.Graph;
import nuts.math.Sampling;
import nuts.util.Arbre;
import nuts.util.CollUtils;
import pty.RandomRootedTrees;
import pty.RootedTree;
import pty.UnrootedTree;

public class TreeGenerators {
    public static RootedTree sampleUniformTopologyNonClock(Random rand, Distrib<Double> branchDistribution, List<Taxon> leavesNames) {
        if (!CollUtils.isSet(leavesNames)) {
            throw new RuntimeException();
        }
        UnrootedTree unrooted = UnrootedTree.fromRooted(RandomRootedTrees.sampleCoalescent(rand, leavesNames, 1.0));
        Graph<Taxon> topology = unrooted.getTopology();
        ArrayList<Taxon> nodes = CollUtils.list(topology.vertexSet());
        Collections.sort(nodes);
        for (Taxon t : nodes) {
            ArrayList<Taxon> neighbors = CollUtils.list(topology.nbrs(t));
            Collections.sort(neighbors);
            for (Taxon other : neighbors) {
                unrooted.changeBranchLength(UnorderedPair.makePair(t, other), branchDistribution.sampleObject(rand));
            }
        }
        return RootedTree.Util.centroidRooting(unrooted);
    }

    public static RootedTree sampleUniformTopologyNonClock(Random rand, Distrib<Double> branchDistribution, int nTaxa) {
        return TreeGenerators.sampleUniformTopologyNonClock(rand, branchDistribution, RandomRootedTrees.generateLeafNames(nTaxa));
    }

    public static RootedTree sampleExpNonclock(Random rand, int nTax, double rate) {
        return TreeGenerators.sampleExpNonclock(rand, RandomRootedTrees.generateLeafNames(nTax), rate);
    }

    public static RootedTree sampleExpNonclock(Random rand, List<Taxon> generateLeafNames, double rate) {
        RootedTree rootedTree = RandomRootedTrees.sampleCoalescent(rand, generateLeafNames, rate);
        HashMap<Taxon, Double> map = new HashMap<Taxon, Double>();
        for (Arbre<Taxon> node : rootedTree.topology().nodes()) {
            if (node.isRoot()) continue;
            double branchLength = Sampling.sampleExponential(rand, 1.0 / rate);
            map.put(node.getContents(), branchLength);
        }
        return new RootedTree.Util.RootedTreeImpl(rootedTree.topology(), map);
    }

    public static RootedTree sampleExpSlightNonclock(Random rand, int nTax, double rate, double sdScale) {
        return TreeGenerators.sampleExpSlightNonclock(rand, RandomRootedTrees.generateLeafNames(nTax), rate, sdScale);
    }

    private static RootedTree sampleExpSlightNonclock(Random rand, List<Taxon> generateLeafNames, double rate, double sdScale) {
        RootedTree rootedTree = RandomRootedTrees.sampleCoalescent(rand, generateLeafNames, rate);
        Map<Taxon, Double> originBrLenMap = rootedTree.branchLengths();
        HashMap<Taxon, Double> map = new HashMap<Taxon, Double>();
        double MINBR = 0.05 / rate;
        for (Arbre<Taxon> node : rootedTree.topology().nodes()) {
            double branchLength;
            if (node.isRoot()) continue;
            double originBrLen = originBrLenMap.get(node.getContents());
            double sd = sdScale * originBrLen;
            for (branchLength = originBrLen + Sampling.nextDouble(rand, -sd, sd); branchLength < MINBR; branchLength *= 2.0) {
            }
            map.put(node.getContents(), branchLength);
        }
        return new RootedTree.Util.RootedTreeImpl(rootedTree.topology(), map);
    }

    public static RootedTree sampleExpNonclock(Random rand, int nTax, boolean fixedBranchLength) {
        return TreeGenerators.sampleExpNonclock(rand, RandomRootedTrees.generateLeafNames(nTax), fixedBranchLength);
    }

    private static RootedTree sampleExpNonclock(Random rand, List<Taxon> generateLeafNames, boolean fixedBranchLength) {
        double rate = 1.0;
        RootedTree rootedTree = RandomRootedTrees.sampleCoalescent(rand, generateLeafNames, rate);
        HashMap<Taxon, Double> map = new HashMap<Taxon, Double>();
        for (Arbre<Taxon> node : rootedTree.topology().nodes()) {
            if (node.isRoot()) continue;
            double branchLength = 1.0;
            map.put(node.getContents(), branchLength);
        }
        return new RootedTree.Util.RootedTreeImpl(rootedTree.topology(), map);
    }

    public static RootedTree sampleCoalescent(Random rand, int nTax, boolean fixedBranchLength) {
        return TreeGenerators.sampleCoalescent(rand, RandomRootedTrees.generateLeafNames(nTax), fixedBranchLength);
    }

    public static RootedTree sampleCoalescent(Random rand, List<Taxon> generateLeafNames, boolean fixedBranchLength) {
        double rate = 1.0;
        RootedTree rootedTree = RandomRootedTrees.sampleCoalescent(rand, generateLeafNames, rate);
        if (!fixedBranchLength) {
            return rootedTree;
        }
        HashMap<Taxon, Double> map = new HashMap<Taxon, Double>();
        for (Arbre<Taxon> node : rootedTree.topology().nodes()) {
            if (node.isRoot()) continue;
            double branchLength = 1.0;
            map.put(node.getContents(), branchLength);
        }
        return new RootedTree.Util.RootedTreeImpl(rootedTree.topology(), map);
    }

    public static RootedTree scaleRootedTree(RootedTree rootedTree, double scale) {
        HashMap<Taxon, Double> map = new HashMap<Taxon, Double>();
        for (Arbre<Taxon> node : rootedTree.topology().nodes()) {
            if (node.isRoot()) continue;
            double branchLength = rootedTree.branchLengths().get(node.getContents()) * scale;
            map.put(node.getContents(), branchLength);
        }
        return new RootedTree.Util.RootedTreeImpl(rootedTree.topology(), map);
    }

    public static double sumBranchLen(RootedTree rootedTree) {
        double sumBrLen = 0.0;
        for (Arbre<Taxon> node : rootedTree.topology().nodes()) {
            if (node.isRoot()) continue;
            sumBrLen += rootedTree.branchLengths().get(node.getContents()).doubleValue();
        }
        return sumBrLen;
    }

    public static RootedTree normalizedRootedTree(RootedTree rootedTree) {
        return TreeGenerators.scaleRootedTree(rootedTree, 1.0 / TreeGenerators.sumBranchLen(rootedTree));
    }
}

