/*
 * Decompiled with CFR 0.152.
 */
package fenchel.factor.multisitecat;

import fenchel.factor.BinaryFactor;
import fenchel.factor.UnaryFactor;
import fenchel.factor.multisitecat.LowLevelOperations;
import fenchel.factor.multisitecat.MSCUnaryScaledFactor;
import java.util.Arrays;
import java.util.List;

public class MSCBinaryScaledFactor
implements BinaryFactor {
    public final int nCategories;
    public final int nCharacters;
    public final int nSites;
    public final double[] data;

    public void set(int category, int sourceCharacter, int destCharacter, double value) {
        if (category >= this.nCategories || sourceCharacter >= this.nCharacters || destCharacter >= this.nCharacters) {
            throw new RuntimeException();
        }
        this.data[LowLevelOperations.binaryIdx((int)category, (int)sourceCharacter, (int)destCharacter, (int)this.nCharacters)] = value;
    }

    public MSCBinaryScaledFactor(int nSites, int nCategories, int nCharacters) {
        this.nSites = nSites;
        this.nCategories = nCategories;
        this.nCharacters = nCharacters;
        this.data = new double[nCategories * nCharacters * nCharacters];
    }

    public String toString() {
        return "MSCBinaryScaledFactor(packedData=" + Arrays.toString(this.data) + ")";
    }

    @Override
    public UnaryFactor marginalize(List<UnaryFactor> factorsOnFirstNode) {
        MSCUnaryScaledFactor result = new MSCUnaryScaledFactor(this.nSites, this.nCategories, this.nCharacters);
        if (factorsOnFirstNode.size() != 1) {
            throw new RuntimeException();
        }
        MSCUnaryScaledFactor other = (MSCUnaryScaledFactor)factorsOnFirstNode.get(0);
        double newNorm = LowLevelOperations.marginalize(this.data, other._rawData(), other._rawLogNorm(), this.nSites, this.nCategories, this.nCharacters, result._rawData());
        result._setNorm(newNorm);
        return result;
    }

    @Override
    public int maxNumberOfFactorsSupported() {
        return 1;
    }
}

