/*
 * Decompiled with CFR 0.152.
 */
package fenchel.factor.multisites;

import fenchel.factor.multisites.MSUnaryMap;
import fenchel.measurefacto.PointwiseOperation;
import fenchel.measurefacto.PointwiseOperationApplicator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import nuts.util.MathUtils;

public class MSPointwiseOperatedApplicator<N>
implements PointwiseOperationApplicator<MSUnaryMap<N>> {
    public static <N> Collection<N> nodes(List<MSUnaryMap<N>> arguments) {
        HashSet<N> result = new HashSet<N>();
        for (MSUnaryMap<N> map : arguments) {
            result.addAll(map.nodes());
        }
        return result;
    }

    @Override
    public double normalize(MSUnaryMap<N> argument) {
        boolean skipLast = argument.skipLast;
        if (skipLast) {
            throw new RuntimeException();
        }
        double logNorm = 0.0;
        for (N node : argument.nodes()) {
            double[][] current = argument.getUnaryArray(node);
            for (int site = 0; site < current.length; ++site) {
                double norm = MathUtils.normalizeAndGetNorm(current[site], true);
                logNorm += Math.log(norm);
            }
        }
        return logNorm;
    }

    public boolean skipLast(Collection<MSUnaryMap<N>> args) {
        Boolean result = null;
        for (MSUnaryMap<N> arg : args) {
            boolean current = arg.skipLast;
            if (result == null) {
                result = current;
            }
            if (result == current) continue;
            throw new RuntimeException();
        }
        return result;
    }

    @Override
    public void apply(PointwiseOperation operation, List<MSUnaryMap<N>> mainArguments, List<MSUnaryMap<N>> additionalArguments) {
        ArrayList<MSUnaryMap<N>> allArguments = new ArrayList<MSUnaryMap<N>>(mainArguments.size() + additionalArguments.size());
        allArguments.addAll(mainArguments);
        allArguments.addAll(additionalArguments);
        boolean skipLast = this.skipLast(allArguments);
        int nTotalArguments = allArguments.size();
        double[][] passedArguments = new double[nTotalArguments][];
        for (N node : MSPointwiseOperatedApplicator.nodes(mainArguments)) {
            int nSites = this.nSites(allArguments, node);
            int nStates = this.nStates(allArguments, node, skipLast);
            for (int site = 0; site < nSites; ++site) {
                for (int argIdx = 0; argIdx < nTotalArguments; ++argIdx) {
                    double[][] currentArray = ((MSUnaryMap)allArguments.get(argIdx)).getUnaryArray(node);
                    passedArguments[argIdx] = currentArray == null ? null : currentArray[site];
                }
                for (int state = 0; state < nStates; ++state) {
                    operation.apply(passedArguments, state);
                }
            }
        }
    }

    private int nStates(List<MSUnaryMap<N>> allArguments, N node, boolean skipLast) {
        return this._n(allArguments, node, false) - (skipLast ? 1 : 0);
    }

    private int nSites(List<MSUnaryMap<N>> allArguments, N node) {
        return this._n(allArguments, node, true);
    }

    private int _n(List<MSUnaryMap<N>> allArguments, N node, boolean isNSites) {
        int n = -1;
        for (MSUnaryMap<N> map : allArguments) {
            int currentN;
            double[][] currentArray = map.getUnaryArray(node);
            if (currentArray == null) continue;
            int n2 = currentN = isNSites ? currentArray.length : currentArray[0].length;
            if (n == -1) {
                n = currentN;
                continue;
            }
            if (n == currentN) continue;
            throw new RuntimeException();
        }
        return n;
    }
}

