/*
 * Decompiled with CFR 0.152.
 */
package fig.exec.servlet;

import fig.basic.Fmt;
import fig.basic.StrUtils;
import fig.basic.Utils;
import java.util.ArrayList;
import java.util.List;

public class ValueProcessor {
    private List<Processor> processors = new ArrayList<Processor>();

    public ValueProcessor(String description) {
        for (String subStr : StrUtils.split(description, "\t")) {
            if (subStr.equals("DOUBLE")) {
                this.processors.add(new DoubleFormatProcessor());
                continue;
            }
            String[] tokens = StrUtils.split(subStr, "/");
            if (tokens.length != 3 || !tokens[0].equals("s")) continue;
            this.processors.add(new ReplaceProcessor(tokens[1], tokens[2]));
        }
    }

    public String process(String s) {
        if (s == null) {
            return null;
        }
        for (Processor processor : this.processors) {
            s = processor.process(s);
        }
        return s;
    }

    static class DoubleFormatProcessor
    implements Processor {
        DoubleFormatProcessor() {
        }

        @Override
        public String process(String s) {
            double x = Utils.parseDoubleEasy(s);
            if (Double.isNaN(x)) {
                return s;
            }
            return Fmt.D(x);
        }
    }

    static class ReplaceProcessor
    implements Processor {
        private String a;
        private String b;

        public ReplaceProcessor(String a, String b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public String process(String s) {
            return s == null ? null : s.replace(this.a, this.b);
        }
    }

    static interface Processor {
        public String process(String var1);
    }
}

