/*
 * Decompiled with CFR 0.152.
 */
package fig.servlet;

import fig.basic.OrderedMap;
import fig.servlet.CompoundField;
import fig.servlet.ConstantField;
import fig.servlet.Field;
import fig.servlet.IntrinsicField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FieldListMap
extends OrderedMap<String, Field> {
    public FieldListMap() {
    }

    public FieldListMap(List<Field> fields) {
        for (Field field : fields) {
            this.add(field);
        }
    }

    public Field add(Field field) {
        String name = field.name;
        if (name.equals("name")) {
            throw new RuntimeException("Reserved field name: " + name);
        }
        if (this.containsKey(field.name)) {
            throw new RuntimeException("Duplicate field name: " + name);
        }
        this.put(name, field);
        return field;
    }

    public Field add(String name, String gloss) {
        return this.add(name, name, gloss);
    }

    public Field add(String name, String displayName, String gloss) {
        return this.add(name, displayName, gloss, new Object[0]);
    }

    public Field add(String name, String gloss, Object[] objs) {
        return this.add(FieldListMap.parseField(name, name, gloss, objs));
    }

    public Field add(String name, String displayName, String gloss, Object[] objs) {
        return this.add(FieldListMap.parseField(name, displayName, gloss, objs));
    }

    public static Field parseField(String name, String displayName, String gloss, Object[] objs) {
        Field field;
        if (objs.length == 0) {
            field = new IntrinsicField(name, displayName, gloss);
        } else if (objs.length == 1) {
            field = FieldListMap.objToField(name, displayName, gloss, objs[0]);
        } else {
            ArrayList<Field> fields = new ArrayList<Field>();
            for (Object obj : objs) {
                fields.add(FieldListMap.objToField(null, null, null, obj));
            }
            field = new CompoundField(name, displayName, gloss, fields);
        }
        return field;
    }

    private static Field objToField(String name, String displayName, String gloss, Object obj) {
        if (obj instanceof String) {
            String s = (String)obj;
            if (s.startsWith("$")) {
                return new IntrinsicField(s.substring(1), displayName, gloss);
            }
            return new ConstantField(name, displayName, gloss, obj);
        }
        if (obj instanceof Field) {
            return (Field)obj;
        }
        return new ConstantField(name, displayName, gloss, obj);
    }

    public FieldListMap sort() {
        FieldListMap map = new FieldListMap();
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : this.values()) {
            fields.add(field);
        }
        Collections.sort(fields);
        for (Field field : fields) {
            map.add(field);
        }
        return map;
    }
}

