/*
 * Decompiled with CFR 0.152.
 */
package goblin;

import fig.basic.IOUtils;
import goblin.CognateId;
import goblin.CognateSet;
import goblin.DataLoader;
import goblin.DerivationTree;
import goblin.HLParams;
import goblin.ObservationsTracker;
import goblin.Taxon;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import ma.MultiAlignment;
import nuts.util.Arbre;

public interface DataLoaderInterface {
    public List<DataLoader.HeldoutEntry> getHeldout();

    public CognateSet getCognateSet();

    public void load();

    public boolean hasHeldout();

    public boolean hasReferenceAlignments();

    public Map<CognateId, MultiAlignment> referenceAlignments();

    public List<Random> randomness();

    public boolean generated();

    public CognateSet getGeneratingCognateSet();

    public HLParams getGeneratingParams();

    public static final class Utils {
        /*
         * Could not resolve type clashes
         */
        public static String heldoutToString(DataLoaderInterface loader) {
            StringBuilder builder = new StringBuilder();
            for (DataLoader.HeldoutEntry heldoutEntry : loader.getHeldout()) {
                CognateId id = heldoutEntry.id;
                builder.append("ID     " + id + "\n");
                ObservationsTracker observations = loader.getCognateSet().getObs(id);
                Arbre<DerivationTree.DerivationNode> current = loader.getCognateSet().getTree(id);
                HashSet<Character> heldoutCharacters = new HashSet<Character>();
                HashSet<Character> obsCharacters = new HashSet<Character>();
                for (int c : heldoutEntry.trueReconstruction.toCharArray()) {
                    heldoutCharacters.add(Character.valueOf((char)c));
                }
                Object object = observations.observedLanguages().iterator();
                while (object.hasNext()) {
                    int c;
                    Taxon l = (Taxon)object.next();
                    char[] cArray = DerivationTree.findNodeByLangName(current.root(), l).getContents().getWord().toCharArray();
                    c = cArray.length;
                    for (int i = 0; i < c; ++i) {
                        char c2 = cArray[i];
                        obsCharacters.add(Character.valueOf(c2));
                    }
                }
                int initSize = obsCharacters.size();
                heldoutCharacters.removeAll(obsCharacters);
                builder.append("OUTPUT " + heldoutEntry.node + ":" + heldoutEntry.trueReconstruction + "\n");
                for (Taxon l : observations.observedLanguages()) {
                    DerivationTree.DerivationNode node = DerivationTree.findNodeByLangName(current.root(), l).getContents();
                    builder.append("INPUT  " + node.getLanguage() + ":" + node.getWord() + "\n");
                }
                builder.append("Number of characters in the observations:" + initSize + "\n");
                builder.append("Heldout characters not found in observed ones:" + heldoutCharacters + "\n");
                builder.append("-----\n");
            }
            return builder.toString();
        }

        public static void saveHeldoutToExec(DataLoaderInterface loader) {
            PrintWriter out = IOUtils.openOutHard(pepper.editmodel.Utils.safeGetExecFilePath("heldout.txt"));
            out.append(Utils.heldoutToString(loader));
            out.close();
            Utils.saveSerializedHeldout(loader, "heldout.List_HeldoutEntry");
        }

        public static void saveSerializedHeldout(DataLoaderInterface loader, String file) {
            ObjectOutputStream oos = IOUtils.openBinOutHard(pepper.editmodel.Utils.safeGetExecFilePath(file));
            try {
                oos.writeObject(loader.getHeldout());
                oos.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

