/*
 * Decompiled with CFR 0.152.
 */
package goblin;

import fig.basic.LogInfo;
import goblin.CognateId;
import goblin.CognateSet;
import goblin.DerivationTree;
import goblin.EditsTracker;
import goblin.ExactDataLikelihood;
import goblin.Heldout;
import goblin.ObservationsTracker;
import goblin.ParamsTracker;
import goblin.ParamsTrackers;
import goblin.Taxon;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import nuts.math.RejectionSampler;
import nuts.util.Arbre;
import nuts.util.CollUtils;
import nuts.util.CounterMap;
import pepper.Edit;
import pepper.editmodel.EditParam;
import pepper.editmodel.ParamUpdater;
import pepper.editmodel.PhonemeModel;

public class EM {
    private ParamsTracker currentParams;
    private CounterMap<Taxon, Edit> currentEdits;
    private RejectionSampler<Arbre<DerivationTree.DerivationNode>> rejectionSampler;
    private List<FilterTypes> filterTypes;
    private PhonemeModel rootPhonemeModel = null;
    private ParamUpdater paramUpdater = null;
    private Set<CognateId> stalledCognates;
    private CognateSet cognates;
    private Double logLikelihood = null;

    public CognateSet getCognates() {
        return this.cognates;
    }

    public ParamsTracker getCurrentParams() {
        return this.currentParams;
    }

    public CounterMap<Taxon, Edit> getCurrentEdits() {
        return this.currentEdits;
    }

    public void compute(Random rand, int nOuterSamplingIter, int nOuterBurnInIter, Heldout.BayesEvaluator bayesEvaluator) {
        this.currentEdits = this.e(this.currentParams, rand, nOuterSamplingIter, nOuterBurnInIter, bayesEvaluator);
        this.currentParams = this.m(this.currentEdits);
    }

    public Heldout.WordHeldoutEvaluation evaluate(Heldout heldout) {
        return heldout.evaluateWordHeldout(this.cognates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detailedBayesEvaluationEMonitoring(ParamsTracker params, int nIters, Random rand, Heldout.BayesEvaluator bayesEvaluator) {
        long start = System.currentTimeMillis();
        LogInfo.track("detailedBayesEvaluationEMonitoring");
        try {
            for (int i = 0; i < nIters; ++i) {
                int stalled = 0;
                for (CognateId id : this.cognates.getCognateIds()) {
                    if (this.stalledCognates.contains(id)) continue;
                }
                LogInfo.logss("Iteration " + i + ": score=" + bayesEvaluator.evaluate().averageOverWords() + ", time=" + (System.currentTimeMillis() - start) + ", rejection=" + this.rejectionSampler.toString() + ", stalled=" + stalled + "/" + this.cognates.size());
            }
        }
        finally {
            LogInfo.end_track();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CounterMap<Taxon, Edit> e(ParamsTracker params, Random rand, int nOuterSamplingIters, int nOuterBurnInIters, Heldout.BayesEvaluator bayesEvaluator) {
        this.logLikelihood = null;
        CounterMap<Taxon, Edit> result = new CounterMap<Taxon, Edit>();
        int current = 0;
        int total = this.cognates.getCognateIds().size() - this.stalledCognates.size();
        for (CognateId id : this.cognates.getCognateIds()) {
            if (this.stalledCognates.contains(id)) continue;
            LogInfo.track("Sampling tree " + current + "/" + total + " (" + this.stalledCognates.size() + " stalled)---" + this.cognates.nObserved(id) + " languages observed in this tree");
            try {
                ++current;
                EditsTracker cEdits = new EditsTracker();
                this.rejectionSampler.initFilters(EM.constructFilters(this.filterTypes, this.cognates.getObs(id)));
                for (int i = 0; i < nOuterSamplingIters; ++i) {
                }
                ExactDataLikelihood edl = new ExactDataLikelihood(params, this.cognates.getObs(id));
                if (edl.isTractable(this.cognates.getTree(id))) {
                    double llTerm = edl.logLikelihood(this.cognates.getTree(id));
                    this.logLikelihood = this.logLikelihood == null ? Double.valueOf(llTerm) : Double.valueOf(this.logLikelihood + llTerm);
                }
                for (Taxon lang : cEdits.languages()) {
                    result.getCounter(lang).incrementAll(cEdits.expectedCounts(lang));
                }
                LogInfo.logss("Id: " + id.toString());
                LogInfo.logss("Rejection rate: " + this.rejectionSampler.toString());
                LogInfo.logss("Number of edits collected:\n " + cEdits.totalCountsStatistics().toString());
            }
            catch (Exception e) {
                this.stalledCognates.add(id);
                LogInfo.warning("Cognate impossible to sample: " + e);
            }
            finally {
                LogInfo.end_track();
            }
        }
        LogInfo.logss("Number of stalled cognates: " + this.stalledCognates.size());
        return result;
    }

    private ParamsTracker m(CounterMap<Taxon, Edit> edits) {
        this.printSumOfEdits(edits);
        LogInfo.logss("Updating parameters");
        Map<Taxon, EditParam> editParams = this.paramUpdater.update(edits, true);
        return new ParamsTrackers.ParamsTrackerMap(editParams, this.rootPhonemeModel);
    }

    private void printSumOfEdits(CounterMap<Taxon, Edit> edits) {
        LogInfo.track("Total counts after E:");
        for (Taxon lang : edits.keySet()) {
            LogInfo.logss(lang.toString() + ":" + edits.getCounter(lang).totalCount());
        }
        LogInfo.end_track();
    }

    private void initFields(ParamsTracker paramInit, CognateSet cognateSetInit) {
        this.cognates = cognateSetInit;
        this.stalledCognates = CollUtils.set();
        this.rootPhonemeModel = paramInit.getRootPhonemeModel();
    }

    public static List<RejectionSampler.RejectionFilter<Arbre<DerivationTree.DerivationNode>>> constructFilters(List<FilterTypes> filterTypes, ObservationsTracker obs) {
        ArrayList<RejectionSampler.RejectionFilter<Arbre<DerivationTree.DerivationNode>>> result = CollUtils.list();
        return result;
    }

    public boolean isLogLikelihoodAvailable() {
        return this.logLikelihood != null;
    }

    public double getLogLikelihood() {
        if (this.logLikelihood == null) {
            throw new RuntimeException();
        }
        return this.logLikelihood;
    }

    public static enum FilterTypes {
        OBSERVED_DATA_SUPPORT,
        NON_EMPTY;

    }
}

