/*
 * Decompiled with CFR 0.152.
 */
package goblin;

import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.Pair;
import goblin.CognateId;
import goblin.CognateSet;
import goblin.DerivationTree;
import goblin.HLParams;
import goblin.LineageSampler;
import goblin.ObservationsTracker;
import goblin.Taxon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import ma.MultiAlignment;
import nuts.math.MeasureZeroException;
import nuts.math.Sampling;
import nuts.util.Arbre;
import nuts.util.CollUtils;
import nuts.util.Counter;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import sage.GlobalAlignmentSampler;
import sage.LikelihoodModel;

public class TreeSamplers {
    public static final DevNullSampleProcessor devNullSampleProcessor = new DevNullSampleProcessor();
    public static MixtureMCMCKernelOptions mixtureOptions = new MixtureMCMCKernelOptions();
    public static AncestryMCMCKernelOptions bigAncestryOptions = new AncestryMCMCKernelOptions();
    public static AncestryMCMCKernelOptions smallAncestryOptions = new AncestryMCMCKernelOptions();
    public static EdgeMCMCKernelOptions edgeOptions = new EdgeMCMCKernelOptions();

    public static <T> ArrayList<T> asArrayList(T ... t) {
        return new ArrayList<T>(Arrays.asList(t));
    }

    public static PhyloTreeMCMCKernel createDefaultMixture() {
        ArrayList<PhyloTreeMCMCKernel> kernels = new ArrayList<PhyloTreeMCMCKernel>();
        for (KernelType kt : TreeSamplers.mixtureOptions.kernelTypes) {
            kernels.add(kt.createDefaultKernel());
        }
        return new MixtureMCMCKernel(kernels, TreeSamplers.mixtureOptions.mixPrs);
    }

    public static void checkConsistent(Arbre<DerivationTree.DerivationNode> derivation, ObservationsTracker obs) {
        TreeSamplers.checkObservationsConsistent(derivation, obs);
        CognateSet.checkUniqueNodeIds(derivation);
    }

    public static void checkObservationsConsistent(Arbre<DerivationTree.DerivationNode> derivation, ObservationsTracker obs) {
        if (obs.observedLanguages().size() == 0) {
            throw new RuntimeException("You should be conditioning on something.");
        }
        List<Taxon> allLangs = TreeSamplers.allLanguages(derivation);
        for (Taxon obsLang : obs.observedLanguages()) {
            if (allLangs.contains(obsLang)) continue;
            throw new RuntimeException("Unknown lang reference in observations: " + obsLang + "\nObs:" + obs.observedLanguages() + ",allLangs:" + allLangs);
        }
    }

    public static List<Taxon> allLanguages(Arbre<DerivationTree.DerivationNode> derivation) {
        ArrayList<Taxon> allLangs = CollUtils.list();
        for (Arbre<DerivationTree.DerivationNode> node : derivation.nodes()) {
            allLangs.add(node.getContents().getLanguage());
        }
        return allLangs;
    }

    public static boolean alignsInitialized(Arbre<DerivationTree.DerivationNode> previous) {
        return previous.getChildren().get(0).getContents().getDerivation() != null;
    }

    public static class AncestryMCMCKernel
    implements PhyloTreeMCMCKernel {
        private boolean rejectionAnneal;
        private SampleProcessor processor;
        private Arbre<DerivationTree.DerivationNode> initial;
        private ObservationsTracker obs;
        private HLParams proposalDistribution;
        private LikelihoodModel model;
        private CognateId id;
        private final AncestryMCMCKernelOptions options;
        private final Taxon smallMovesLang;
        private Pair<Taxon, DerivationTree.Window> last = null;
        private Queue<Pair<Taxon, DerivationTree.Window>> movesQueue = new LinkedList<Pair<Taxon, DerivationTree.Window>>();

        public boolean usePairedModel() {
            return this.model != null && this.model != this.proposalDistribution;
        }

        public boolean isSmallMove() {
            return this.smallMovesLang != null;
        }

        @Override
        public void init(SampleProcessor integrand, Arbre<DerivationTree.DerivationNode> initial, ObservationsTracker obs, HLParams proposalDistribution, LikelihoodModel model, boolean rejAnneal, int nRounds, CognateId id) {
            TreeSamplers.checkConsistent(initial, obs);
            this.id = id;
            this.rejectionAnneal = rejAnneal;
            this.processor = integrand;
            this.initial = initial.copy();
            this.obs = obs;
            this.proposalDistribution = proposalDistribution;
            this.model = model;
            AncestryMCMCKernel.checkSmallMovesLangConsistent(initial, this.smallMovesLang, obs);
        }

        private static void checkSmallMovesLangConsistent(Arbre<DerivationTree.DerivationNode> tree, Taxon lang, ObservationsTracker obs) {
            if (lang == null) {
                return;
            }
            DerivationTree.findNodeByLangName(tree, lang);
            if (obs.isObserved(lang)) {
                throw new RuntimeException();
            }
        }

        private Pair<Taxon, DerivationTree.Window> nextMove(Arbre<DerivationTree.DerivationNode> current) {
            if (this.movesQueue.isEmpty()) {
                this.movesQueue = this.refreshMovesList(current);
                assert (this.refreshMovesList(current).equals(this.refreshMovesList(this.initial)));
            }
            return this.movesQueue.poll();
        }

        private Queue<Pair<Taxon, DerivationTree.Window>> refreshMovesList(Arbre<DerivationTree.DerivationNode> current) {
            LinkedList<Pair<Taxon, DerivationTree.Window>> result = new LinkedList<Pair<Taxon, DerivationTree.Window>>();
            for (Taxon observedLanguage : this.obs.observedLanguages()) {
                if (DerivationTree.findNodeByLangName(current, observedLanguage).getChildren().size() > 0) continue;
                String word = DerivationTree.findNodeByLangName(current, observedLanguage).getContents().getWord();
                for (DerivationTree.Window window : DerivationTree.getWindows(word, this.options.anchorWindowSize)) {
                    result.add(Pair.makePair(observedLanguage, window));
                }
            }
            return result;
        }

        public AncestryMCMCKernel(AncestryMCMCKernelOptions options) {
            this(options, null);
        }

        public AncestryMCMCKernel(AncestryMCMCKernelOptions options, Taxon smallMoveLang) {
            this.options = options;
            this.smallMovesLang = smallMoveLang;
        }

        public String toString() {
            return "Ancestry(" + this.last + ")";
        }

        @Override
        public Arbre<DerivationTree.DerivationNode> next(Random rand, Arbre<DerivationTree.DerivationNode> previous, SummaryStatistics acceptStats) throws MeasureZeroException {
            if (!TreeSamplers.alignsInitialized(previous)) {
                previous = this.proposalDistribution.resampleAlignments(previous, rand);
            }
            previous = previous.copy();
            Pair<Taxon, DerivationTree.Window> move = this.nextMove(previous);
            this.last = move;
            Taxon lang = move.getFirst();
            DerivationTree.Window win = move.getSecond();
            if (this.options.printLineageInfo) {
                LogInfo.logs("Current anchor language:" + lang);
            }
            Arbre<DerivationTree.DerivationNode> anchor = DerivationTree.findNodeByLangName(previous, lang);
            String cWord = anchor.getContents().getWord();
            Arbre<DerivationTree.LineagedNode> lineagedTree = DerivationTree.lineage(anchor, win);
            if (this.options.printLineageInfo) {
                LogInfo.logs("Current anchor window:" + win + "@" + lang + " = " + win.slice(anchor.getContents().getWord()));
                this.logSample(DerivationTree.cutLineage(lineagedTree), "Initial lineaged tree");
            }
            Object result = previous;
            InnerSampler innerSampler = new InnerSampler(lineagedTree, rand, this.rejectionAnneal);
            result = this.rejectionAnneal || !this.options.computeAcceptance ? innerSampler.proposed() : Sampling.metropolisHastingsStep(rand, innerSampler, acceptStats);
            if (this.usePairedModel()) {
                this.processor.process((Arbre<DerivationTree.DerivationNode>)result, this.model.fullLogLikelihood((Arbre<DerivationTree.DerivationNode>)result, this.id), this.id);
            } else {
                this.processor.process((Arbre<DerivationTree.DerivationNode>)result, this.proposalDistribution.fullLogLikelihood((Arbre<DerivationTree.DerivationNode>)result, this.id), this.id);
            }
            if (this.options.printSamples) {
                this.logSample((Arbre<DerivationTree.DerivationNode>)result, "Sample picked");
            }
            return result;
        }

        private void logSample(Arbre<DerivationTree.DerivationNode> a, String desc) {
            LogInfo.track(desc);
            if (this.options.printTrees) {
                LogInfo.logs("" + a.deepToString());
                LogInfo.logs("");
            }
            if (this.options.printFullAlignments) {
                LogInfo.logs(MultiAlignment.fullInducedMultiAlignment(a.root()));
            } else {
                LogInfo.logs(MultiAlignment.inducedMultiAlignment(a.root()));
            }
            LogInfo.end_track();
        }

        private AncestryMCMCKernel getInstance() {
            return this;
        }

        private class InnerSampler
        implements Sampling.Proposal<Arbre<DerivationTree.DerivationNode>> {
            private final Arbre<DerivationTree.LineagedNode> lineagedTree;
            private final Random rand;
            private LineageSampler lineageSampler;
            private Arbre<DerivationTree.LineagedNode> cSample;
            private final boolean rejectAnneal;
            private double _initLogRatio = Double.NaN;

            private InnerSampler(Arbre<DerivationTree.LineagedNode> lineagedTree, Random rand, boolean rejectAnneal) {
                this.rejectAnneal = rejectAnneal;
                this.rand = rand;
                this.lineagedTree = lineagedTree;
            }

            @Override
            public Arbre<DerivationTree.DerivationNode> proposed() {
                LineageSampler.LongGapAlignmentSamplerAdaptor model = new LineageSampler.LongGapAlignmentSamplerAdaptor(AncestryMCMCKernel.this.getInstance().proposalDistribution);
                this.lineageSampler = new LineageSampler(AncestryMCMCKernel.this.obs, this.lineagedTree, model, AncestryMCMCKernel.this.options, AncestryMCMCKernel.this.smallMovesLang, false);
                try {
                    this.cSample = this.rejectAnneal ? this.rejectAnneal() : this.lineageSampler.sample(this.rand);
                }
                catch (MeasureZeroException e) {
                    this.cSample = this.lineagedTree;
                    e.printStackTrace();
                    LogInfo.warning("Unexpected MeasureZero:" + e.toString());
                }
                if (((AncestryMCMCKernel)AncestryMCMCKernel.this).options.printProposedSamples) {
                    AncestryMCMCKernel.this.logSample(DerivationTree.cutLineage(this.cSample), "Proposed sample");
                }
                return DerivationTree.derivation(this.cSample);
            }

            private Arbre<DerivationTree.LineagedNode> rejectAnneal() throws MeasureZeroException {
                LikelihoodModel llm = AncestryMCMCKernel.this.usePairedModel() ? AncestryMCMCKernel.this.model : AncestryMCMCKernel.this.proposalDistribution;
                double max = Double.NEGATIVE_INFINITY;
                Arbre<DerivationTree.LineagedNode> argmax = null;
                for (int i = 0; i < ((AncestryMCMCKernel)AncestryMCMCKernel.this).options.nRejectAnneal; ++i) {
                    Arbre<DerivationTree.LineagedNode> current = this.lineageSampler.sample(this.rand);
                    double curScore = llm.partialLogLikelihood(current, AncestryMCMCKernel.this.id);
                    if (!(curScore > max)) continue;
                    max = curScore;
                    argmax = current;
                }
                return argmax;
            }

            private double initLogRatio() {
                if (this.rejectAnneal) {
                    throw new RuntimeException();
                }
                if (!Double.isNaN(this._initLogRatio)) {
                    return this._initLogRatio;
                }
                double log_q_old_z = this.lineageSampler.getSumLogPr();
                if (!AncestryMCMCKernel.this.usePairedModel()) {
                    this._initLogRatio = log_q_old_z;
                } else {
                    double log_q_old = AncestryMCMCKernel.this.proposalDistribution.partialLogLikelihood(this.lineagedTree, AncestryMCMCKernel.this.id);
                    double log_p_old = AncestryMCMCKernel.this.model.partialLogLikelihood(this.lineagedTree, AncestryMCMCKernel.this.id);
                    this._initLogRatio = log_q_old + log_q_old_z - log_p_old;
                }
                return this._initLogRatio;
            }

            @Override
            public double mhRatio() {
                if (this.rejectAnneal) {
                    throw new RuntimeException();
                }
                double log_q_new_z = this.lineageSampler.newInstance(this.cSample).getSumLogPr();
                double logRatio = Double.NaN;
                if (!AncestryMCMCKernel.this.usePairedModel()) {
                    logRatio = this.initLogRatio() - log_q_new_z;
                } else {
                    double log_p_new = AncestryMCMCKernel.this.model.partialLogLikelihood(this.cSample, AncestryMCMCKernel.this.id);
                    double log_q_new = AncestryMCMCKernel.this.proposalDistribution.partialLogLikelihood(this.cSample, AncestryMCMCKernel.this.id);
                    logRatio = log_p_new + this.initLogRatio() - log_q_new - log_q_new_z;
                }
                if (((AncestryMCMCKernel)AncestryMCMCKernel.this).options.printMHRatio) {
                    LogInfo.logs("Untrunc. ratio of previous sample:" + Math.exp(logRatio));
                }
                return Math.min(1.0, Math.exp(logRatio));
            }

            @Override
            public Arbre<DerivationTree.DerivationNode> initial() {
                return DerivationTree.derivation(this.lineagedTree);
            }
        }
    }

    public static class IndepChainKernel
    implements PhyloTreeMCMCKernel {
        private HLParams proposalDistribution;
        private LikelihoodModel model;
        private CognateId id;
        private SampleProcessor processor;
        private LineageSampler sampler;
        private final AncestryMCMCKernelOptions options;

        public boolean usePairedModel() {
            return this.model != null && this.model != this.proposalDistribution;
        }

        public IndepChainKernel(AncestryMCMCKernelOptions options) {
            this.options = options;
        }

        @Override
        public void init(SampleProcessor integrand, Arbre<DerivationTree.DerivationNode> initial, ObservationsTracker obs, HLParams proposalDistribution, LikelihoodModel model, boolean annealing, int rounds, CognateId id) {
            this.model = model;
            this.processor = integrand;
            this.id = id;
            this.proposalDistribution = proposalDistribution;
            if (!TreeSamplers.alignsInitialized(initial)) {
                try {
                    initial = proposalDistribution.resampleAlignments(initial, new Random(1L));
                }
                catch (MeasureZeroException e) {
                    throw new RuntimeException();
                }
            }
            this.sampler = new LineageSampler(obs, DerivationTree.fullLineage(initial), new LineageSampler.LongGapAlignmentSamplerAdaptor(proposalDistribution), this.options, null, true);
        }

        @Override
        public Arbre<DerivationTree.DerivationNode> next(final Random rand, Arbre<DerivationTree.DerivationNode> _previous, SummaryStatistics acceptStats) throws MeasureZeroException {
            if (!TreeSamplers.alignsInitialized(_previous)) {
                _previous = this.proposalDistribution.resampleAlignments(_previous, rand);
            }
            final Arbre<DerivationTree.DerivationNode> previous = _previous = _previous.copy();
            Sampling.Proposal<Arbre<DerivationTree.DerivationNode>> is = new Sampling.Proposal<Arbre<DerivationTree.DerivationNode>>(){
                Arbre<DerivationTree.DerivationNode> sample;

                @Override
                public double mhRatio() {
                    if (this.usePairedModel()) {
                        double logRatio = model.fullLogLikelihood(this.sample, id) + proposalDistribution.fullLogLikelihood(previous, id) - model.fullLogLikelihood(previous, id) - proposalDistribution.fullLogLikelihood(this.sample, id);
                        return Math.min(1.0, Math.exp(logRatio));
                    }
                    return 1.0;
                }

                @Override
                public Arbre<DerivationTree.DerivationNode> proposed() {
                    try {
                        this.sample = DerivationTree.derivation(sampler.sample(rand));
                    }
                    catch (MeasureZeroException e) {
                        throw new RuntimeException();
                    }
                    return this.sample;
                }

                @Override
                public Arbre<DerivationTree.DerivationNode> initial() {
                    return previous;
                }
            };
            Arbre<DerivationTree.DerivationNode> result = Sampling.metropolisHastingsStep(rand, is, acceptStats);
            if (this.usePairedModel()) {
                this.processor.process(result, this.model.fullLogLikelihood(result, this.id), this.id);
            } else {
                this.processor.process(result, this.proposalDistribution.fullLogLikelihood(result, this.id), this.id);
            }
            return result;
        }
    }

    public static class SmallAncestryMCMCKernel
    implements PhyloTreeMCMCKernel {
        private List<AncestryMCMCKernel> kernels;
        private List<Taxon> langs;
        private int currentIndex = 0;
        private final AncestryMCMCKernelOptions options;
        private int lastIndex = -1;

        public SmallAncestryMCMCKernel(AncestryMCMCKernelOptions options) {
            this.options = options;
        }

        @Override
        public void init(SampleProcessor integrand, Arbre<DerivationTree.DerivationNode> initial, ObservationsTracker obs, HLParams proposalDistribution, LikelihoodModel model, boolean annealing, int rounds, CognateId id) {
            this.kernels = new ArrayList<AncestryMCMCKernel>();
            this.langs = new ArrayList<Taxon>();
            for (Arbre<DerivationTree.DerivationNode> subt : initial.root().nodes()) {
                if (obs.isObserved(subt.getContents().getLanguage())) continue;
                this.kernels.add(new AncestryMCMCKernel(this.options, subt.getContents().getLanguage()));
                this.langs.add(subt.getContents().getLanguage());
            }
            for (AncestryMCMCKernel kernel : this.kernels) {
                kernel.init(integrand, initial, obs, proposalDistribution, model, annealing, rounds, id);
            }
        }

        @Override
        public Arbre<DerivationTree.DerivationNode> next(Random rand, Arbre<DerivationTree.DerivationNode> previous, SummaryStatistics acceptStats) throws MeasureZeroException {
            int index;
            if (this.kernels.size() == 0) {
                return previous.copy();
            }
            this.lastIndex = index = this.popIndex();
            AncestryMCMCKernel current = this.kernels.get(index);
            return current.next(rand, previous, acceptStats);
        }

        public String toString() {
            return "Small(" + this.langs.get(this.lastIndex) + "," + this.kernels.get(this.lastIndex).toString() + ")";
        }

        private int popIndex() {
            int result = this.currentIndex++;
            if (this.currentIndex == this.kernels.size()) {
                this.currentIndex = 0;
            }
            if (this.currentIndex > this.kernels.size()) {
                throw new RuntimeException();
            }
            return result;
        }
    }

    public static class EdgeMCMCKernel
    implements PhyloTreeMCMCKernel {
        private boolean isAnneal;
        private int nRounds;
        private SampleProcessor processor;
        private CognateId id;
        private Arbre<DerivationTree.DerivationNode> initial;
        private HLParams proposalDistribution;
        private LikelihoodModel model;
        private final EdgeMCMCKernelOptions options;
        private Taxon lastMove = null;
        private Queue<Taxon> languages = new LinkedList<Taxon>();

        public EdgeMCMCKernel(EdgeMCMCKernelOptions options) {
            this.options = options;
        }

        public boolean usePairedModel() {
            return this.model != null || this.model == this.proposalDistribution;
        }

        @Override
        public void init(SampleProcessor integrand, Arbre<DerivationTree.DerivationNode> initial, ObservationsTracker obs, HLParams proposalDistribution, LikelihoodModel model, boolean annealing, int nRounds, CognateId id) {
            this.id = id;
            this.isAnneal = annealing;
            this.nRounds = nRounds;
            this.processor = integrand;
            this.initial = initial.copy();
            this.proposalDistribution = proposalDistribution;
            this.model = model;
        }

        private Taxon nextMove(Arbre<DerivationTree.DerivationNode> current) {
            Taxon result;
            if (this.languages.isEmpty()) {
                this.languages = this.movesList(current);
                assert (this.movesList(current).equals(this.movesList(this.initial)));
            }
            this.lastMove = result = this.languages.poll();
            return result;
        }

        public String toString() {
            return "Edge(" + this.lastMove + ")";
        }

        private Queue<Taxon> movesList(Arbre<DerivationTree.DerivationNode> current) {
            LinkedList<Taxon> result = new LinkedList<Taxon>();
            for (Arbre<DerivationTree.DerivationNode> node : current.nodes()) {
                if (node.isRoot()) continue;
                result.add(node.getContents().getLanguage());
            }
            return result;
        }

        @Override
        public Arbre<DerivationTree.DerivationNode> next(Random rand, Arbre<DerivationTree.DerivationNode> previous, SummaryStatistics acceptStats) throws MeasureZeroException {
            Arbre<DerivationTree.DerivationNode> result = GlobalAlignmentSampler.next(previous, this.nextMove(previous), this.model, this.proposalDistribution, rand, this.isAnneal, this.nRounds, acceptStats, this.id);
            if (this.usePairedModel()) {
                this.processor.process(result, this.model.fullLogLikelihood(result, this.id), this.id);
            } else {
                this.processor.process(result, this.proposalDistribution.fullLogLikelihood(result, this.id), this.id);
            }
            return result;
        }
    }

    public static class SMFMCMCKernel
    implements PhyloTreeMCMCKernel {
        private int nRounds;
        private SampleProcessor processor;
        private HLParams proposalDistribution = null;
        private LikelihoodModel model;
        private ObservationsTracker obs;
        private Counter<Object> w = null;

        @Override
        public void init(SampleProcessor integrand, Arbre<DerivationTree.DerivationNode> initial, ObservationsTracker obs, HLParams proposalDistribution, LikelihoodModel model, boolean annealing, int rounds, CognateId id) {
            throw new RuntimeException();
        }

        public boolean usePairedModel() {
            return this.model != null || this.model == this.proposalDistribution;
        }

        @Override
        public Arbre<DerivationTree.DerivationNode> next(Random rand, Arbre<DerivationTree.DerivationNode> unsafe_previous, SummaryStatistics acceptStats) throws MeasureZeroException {
            return null;
        }
    }

    public static class MixtureMCMCKernel
    implements PhyloTreeMCMCKernel {
        private final List<PhyloTreeMCMCKernel> kernels;
        private final List<Double> mixturePrs;
        private int lastIndex = -1;

        public MixtureMCMCKernel(List<PhyloTreeMCMCKernel> kernels, List<Double> mixturePrs) {
            if (kernels.size() != mixturePrs.size()) {
                throw new RuntimeException();
            }
            this.kernels = kernels;
            this.mixturePrs = mixturePrs;
        }

        @Override
        public void init(SampleProcessor integrand, Arbre<DerivationTree.DerivationNode> initial, ObservationsTracker obs, HLParams proposalDistribution, LikelihoodModel model, boolean annealing, int rounds, CognateId id) {
            for (PhyloTreeMCMCKernel kernel : this.kernels) {
                kernel.init(integrand, initial, obs, proposalDistribution, model, annealing, rounds, id);
            }
        }

        @Override
        public Arbre<DerivationTree.DerivationNode> next(Random rand, Arbre<DerivationTree.DerivationNode> previous, SummaryStatistics acceptStats) throws MeasureZeroException {
            int index;
            this.lastIndex = index = Sampling.sample(rand, this.mixturePrs);
            return this.kernels.get(index).next(rand, previous, acceptStats);
        }

        public String toString() {
            return this.kernels.get(this.lastIndex).toString();
        }
    }

    public static enum KernelType {
        EDGE{

            @Override
            public PhyloTreeMCMCKernel createDefaultKernel() {
                return new EdgeMCMCKernel(edgeOptions);
            }
        }
        ,
        ANCS{

            @Override
            public PhyloTreeMCMCKernel createDefaultKernel() {
                return new SmallAncestryMCMCKernel(smallAncestryOptions);
            }
        }
        ,
        ANCB{

            @Override
            public PhyloTreeMCMCKernel createDefaultKernel() {
                return new AncestryMCMCKernel(bigAncestryOptions);
            }
        }
        ,
        IND{

            @Override
            public PhyloTreeMCMCKernel createDefaultKernel() {
                return new IndepChainKernel(new AncestryMCMCKernelOptions());
            }
        }
        ,
        SMF{

            @Override
            public PhyloTreeMCMCKernel createDefaultKernel() {
                return new SMFMCMCKernel();
            }
        };


        public abstract PhyloTreeMCMCKernel createDefaultKernel();
    }

    public static class AncestryMCMCKernelOptions {
        @Option(gloss="Size of the windows")
        public int anchorWindowSize = 2;
        @Option
        public boolean failsIfOneLineageDoes = false;
        @Option
        public int nRejectAnneal = 10;
        @Option(gloss="Should MH ratios be computed?")
        public boolean computeAcceptance = true;
        @Option
        public boolean printSamples = false;
        @Option
        public boolean printProposedSamples = false;
        @Option
        public boolean printMHRatio = false;
        @Option
        public boolean printLineageInfo = false;
        @Option
        public boolean printFullAlignments = true;
        @Option
        public boolean printTrees = false;
        @Option(gloss="Restrict proposed unobserved lineage values to phonemes that occur in the observed parts of the lineage")
        public RestrictType restrictToObservedSymbols = RestrictType.FALSE;

        public static enum RestrictType {
            FALSE,
            OBS,
            WIN;

        }
    }

    public static class EdgeMCMCKernelOptions {
    }

    public static class MixtureMCMCKernelOptions {
        @Option
        public ArrayList<KernelType> kernelTypes = TreeSamplers.asArrayList(KernelType.ANCB);
        @Option
        public ArrayList<Double> mixPrs = TreeSamplers.asArrayList(1.0);
    }

    public static class DevNullSampleProcessor
    implements SampleProcessor {
        @Override
        public void process(Arbre<DerivationTree.DerivationNode> currentSample, double score, CognateId id) {
        }
    }

    public static class ForkedSampleProcessor
    implements SampleProcessor {
        public List<SampleProcessor> processors = new ArrayList<SampleProcessor>();

        @Override
        public void process(Arbre<DerivationTree.DerivationNode> currentSample, double score, CognateId id) {
            for (SampleProcessor processor : this.processors) {
                processor.process(currentSample, score, id);
            }
        }
    }

    public static interface SampleProcessor {
        public void process(Arbre<DerivationTree.DerivationNode> var1, double var2, CognateId var4);
    }

    public static interface PhyloTreeMCMCKernel {
        public void init(SampleProcessor var1, Arbre<DerivationTree.DerivationNode> var2, ObservationsTracker var3, HLParams var4, LikelihoodModel var5, boolean var6, int var7, CognateId var8);

        public Arbre<DerivationTree.DerivationNode> next(Random var1, Arbre<DerivationTree.DerivationNode> var2, SummaryStatistics var3) throws MeasureZeroException;
    }
}

