/*
 * Decompiled with CFR 0.152.
 */
package goblin;

import fig.basic.Option;
import fig.exec.Execution;
import goblin.ParamsTracker;
import goblin.ParamsTrackers;
import goblin.Taxon;
import nuts.io.IO;
import nuts.util.Counter;
import pepper.Edit;
import pepper.editmodel.EditParam;

public class ViewParams
implements Runnable {
    @Option(required=true)
    public String path;
    @Option(required=true)
    public String langString;
    @Option
    public boolean filterSelf = true;
    @Option
    public double threshold = 0.1;

    public static void main(String[] args) {
        Execution.run(args, new ViewParams());
    }

    @Override
    public void run() {
        try {
            ParamsTracker params = ParamsTrackers.restoreParamsTracker(this.path);
            Taxon lang = new Taxon(this.langString);
            EditParam param = params.getEditParam(lang);
            Counter<Edit> counter = param.toCounter();
            for (Edit edit : counter) {
                if (this.filterSelf && edit.isSelfSubstitution() || !(counter.getCount(edit) >= this.threshold)) continue;
                IO.so(edit.toString() + "\t" + counter.getCount(edit));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

