/*
 * Decompiled with CFR 0.152.
 */
package nuts.math;

import fig.basic.UnorderedPair;
import java.util.HashMap;
import java.util.Map;
import nuts.math.CliqueVisitor;
import nuts.math.EdgeFct;
import nuts.math.GMFct;
import nuts.math.GMFctUtils;
import nuts.math.Graph;

public final class TabularGMFct<V extends Comparable<V>>
implements GMFct<V> {
    private final Map<V, double[]> fct = new HashMap<V, double[]>();
    private final TabularEdgeFct<V> edges;
    private transient V _n = null;
    private transient double[] _cache;

    public String toString() {
        return GMFctUtils.toString(this);
    }

    public TabularGMFct(Graph<V> graph, Map<V, Integer> randomVariableDom) {
        this.edges = new TabularEdgeFct<V>(graph, randomVariableDom);
    }

    public TabularGMFct(final GMFct<V> model) {
        this(model.graph(), GMFctUtils.domain(model));
        final TabularGMFct<V> caller = this;
        GMFctUtils.visit(model, new CliqueVisitor<V>(){

            @Override
            public void visitEdge(V n1, V n2, int s1, int s2) {
                caller.set(n1, n2, s1, s2, model.get(n1, n2, s1, s2));
            }

            @Override
            public void visitVertex(V n, int s) {
                caller.set(n, s, model.get(n, s));
            }
        });
    }

    @Override
    public double get(V n1, V n2, int s1, int s2) {
        return this.edges.get(n1, n2, s1, s2);
    }

    private double[] access(V n, boolean insertAllowed) {
        if (this._n == n) {
            return this._cache;
        }
        this._cache = this.fct.get(n);
        this._n = n;
        if (this._cache != null) {
            return this._cache;
        }
        if (!insertAllowed) {
            throw new RuntimeException();
        }
        this._cache = new double[this.nStates(n)];
        this.fct.put((double[])n, this._cache);
        return this._cache;
    }

    public void set(V n, int s, double v) {
        if (s >= this.nStates(n)) {
            throw new RuntimeException();
        }
        this.access(n, (boolean)true)[s] = v;
    }

    public void set(V n1, V n2, int s1, int s2, double v) {
        this.edges.set(n1, n2, s1, s2, v);
    }

    public void increment(V n1, V n2, int s1, int s2, double v) {
        this.set(n1, n2, s1, s2, v + this.get(n1, n2, s1, s2));
    }

    public void increment(V n, int s, double v) {
        this.set(n, s, this.get(n, s) + v);
    }

    public void scale(V n1, V n2, int s1, int s2, double v) {
        this.set(n1, n2, s1, s2, v * this.get(n1, n2, s1, s2));
    }

    public void scale(V n, int s, double v) {
        this.set(n, s, this.get(n, s) * v);
    }

    public void scale(V n1, V n2, double[][] v) {
        for (int s1 = 0; s1 < this.nStates(n1); ++s1) {
            for (int s2 = 0; s2 < this.nStates(n2); ++s2) {
                this.set(n1, n2, s1, s2, v[s1][s2] * this.get(n1, n2, s1, s2));
            }
        }
    }

    public void scale(V n, double[] v) {
        for (int s = 0; s < this.nStates(n); ++s) {
            this.set(n, s, this.get(n, s) * v[s]);
        }
    }

    @Override
    public double get(V n, int s) {
        return this.access(n, false)[s];
    }

    public double[] get(V n) {
        return this.access(n, false);
    }

    public boolean has(V n) {
        return this.fct.containsKey(n);
    }

    @Override
    public Graph<V> graph() {
        return this.edges.graph();
    }

    @Override
    public int nStates(V node) {
        return this.edges.nStates(node);
    }

    private static final class TabularEdgeFct<V extends Comparable<V>>
    implements EdgeFct<V> {
        private final Graph<V> graph;
        private final Map<V, Integer> randomVariableDom;
        private final Map<UnorderedPair<V, V>, double[][]> fct = new HashMap<UnorderedPair<V, V>, double[][]>();
        private transient V _n1 = null;
        private transient V _n2 = null;
        private transient double[][] _cache;

        public TabularEdgeFct(Graph<V> graph, Map<V, Integer> randomVariableDom) {
            assert (graph.vertexSet().equals(randomVariableDom.keySet()));
            this.graph = graph;
            this.randomVariableDom = randomVariableDom;
        }

        @Override
        public int nStates(V node) {
            return this.randomVariableDom.get(node);
        }

        private double[][] access(V n1, V n2, boolean insertAllowed) {
            if (this._n1 == n1 && this._n2 == n2) {
                return this._cache;
            }
            assert (n1.compareTo(n2) >= 0);
            if (!this.graph.hasEdge(n1, n2)) {
                throw new RuntimeException();
            }
            UnorderedPair<V, V> key = new UnorderedPair<V, V>(n1, n2);
            this._cache = this.fct.get(key);
            this._n1 = n1;
            this._n2 = n2;
            if (this._cache != null) {
                return this._cache;
            }
            if (!insertAllowed) {
                throw new RuntimeException();
            }
            this._cache = new double[this.randomVariableDom.get(n1).intValue()][this.randomVariableDom.get(n2).intValue()];
            this.fct.put(key, this._cache);
            return this._cache;
        }

        public void set(V n1, V n2, int s1, int s2, double v) {
            if (s1 >= this.nStates(n1) || s2 >= this.nStates(n2)) {
                throw new RuntimeException();
            }
            if (n1.compareTo(n2) > 0) {
                this.access(n1, n2, (boolean)true)[s1][s2] = v;
            } else if (n1.compareTo(n2) < 0) {
                this.access(n2, n1, (boolean)true)[s2][s1] = v;
            } else {
                throw new RuntimeException();
            }
        }

        @Override
        public double get(V n1, V n2, int s1, int s2) {
            if (n1.compareTo(n2) > 0) {
                return this.access(n1, n2, false)[s1][s2];
            }
            if (n1.compareTo(n2) < 0) {
                return this.access(n2, n1, false)[s2][s1];
            }
            throw new RuntimeException();
        }

        public boolean has(V n1, V n2) {
            if (n1.compareTo(n2) > 0) {
                return this.fct.containsKey(new UnorderedPair<V, V>(n1, n2));
            }
            if (n1.compareTo(n2) < 0) {
                return this.fct.containsKey(new UnorderedPair<V, V>(n2, n1));
            }
            throw new RuntimeException();
        }

        @Override
        public Graph<V> graph() {
            return this.graph;
        }
    }
}

