/*
 * Decompiled with CFR 0.152.
 */
package nuts.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nuts.tui.FancyTreeRenderer;
import nuts.util.CollUtils;
import nuts.util.Tree;

public final class Arbre<T>
implements Serializable {
    private static final long serialVersionUID = 7400624745947208022L;
    private T contents;
    private ArrayList<Arbre<T>> children = new ArrayList();
    private Arbre<T> parent;

    public static <T> Arbre<T> findFirstNodeWithContents(Arbre<T> a, T contents) {
        for (Arbre<T> node : a.nodes()) {
            if (!node.getContents().equals(contents)) continue;
            return node;
        }
        return null;
    }

    public static <T> Arbre<T> tree2Arbre(Tree<T> t) {
        ArrayList<Arbre<T>> children = new ArrayList<Arbre<T>>();
        for (Tree<T> child : t.getChildren()) {
            children.add(Arbre.tree2Arbre(child));
        }
        return Arbre.arbre(t.getLabel(), children);
    }

    public static <T> Tree<T> arbre2Tree(Arbre<T> a) {
        ArrayList children = new ArrayList();
        for (Arbre<T> child : a.getChildren()) {
            children.add(Arbre.arbre2Tree(child));
        }
        return new Tree<T>(a.getContents(), children);
    }

    public static <T> Map<T, T> parents(Arbre<T> a) {
        HashMap<T, T> result = new HashMap<T, T>();
        for (Arbre<T> node : a.nodes()) {
            if (node.isRoot()) continue;
            result.put(node.getContents(), node.getParent().getContents());
        }
        return result;
    }

    public static <T> Arbre<T> childMap2Arbre(Map<T, Set<T>> childMap, T root) {
        ArrayList<Arbre<T>> children = new ArrayList<Arbre<T>>();
        if (childMap.containsKey(root)) {
            for (T childContent : childMap.get(root)) {
                children.add(Arbre.childMap2Arbre(childMap, childContent));
            }
        }
        return new Arbre<T>(root, children);
    }

    public static <T> Arbre<T> parentMap2Arbre(Map<T, T> parentMap) {
        T root = Arbre.findRoot(parentMap);
        Arbre<T> result = Arbre.parentMap2Arbre(parentMap, root);
        if (result.nodes().size() != parentMap.size() + 1) {
            throw new RuntimeException("forest instead of tree? " + result.nodes().size() + "," + parentMap.size());
        }
        return result;
    }

    public static <T> Arbre<T> parentMap2Arbre(Map<T, T> parentMap, T root) {
        Map<T, Set<T>> childMap = CollUtils.invert(parentMap);
        Arbre<T> result = Arbre.childMap2Arbre(childMap, root);
        return result;
    }

    private static <T> T findRoot(Map<T, T> parentMap) {
        T result = parentMap.keySet().iterator().next();
        while (parentMap.containsKey(result)) {
            result = parentMap.get(result);
        }
        return result;
    }

    public static <S, T> Arbre<T> map(Arbre<S> src, final Map<S, T> map) {
        return src.preOrderMap(new ArbreMap<S, T>(){

            @Override
            public T map(Arbre<S> currentDomainNode) {
                return map.get(currentDomainNode.getContents());
            }
        });
    }

    public static <T> Map<Arbre<T>, Set<T>> descMap(Arbre<T> arbre) {
        HashMap<Arbre<T>, Set<T>> result = new HashMap<Arbre<T>, Set<T>>();
        for (Arbre<T> node : arbre.nodes()) {
            HashSet<T> current = new HashSet<T>();
            result.put(node, current);
            for (Arbre<T> subnode : node.nodes()) {
                current.add(subnode.getContents());
            }
        }
        return result;
    }

    public static <T> Map<T, Set<T>> leavesMap_Efficient(Arbre<T> arbre) {
        HashMap result = new HashMap();
        Iterator<Arbre<T>> iterator = arbre.leaves().iterator();
        while (iterator.hasNext()) {
            Arbre<T> leaf;
            Arbre<T> current = leaf = iterator.next();
            do {
                CollUtils.getNoNullSet(result, current.getContents()).add(leaf.getContents());
            } while ((current = current.getParentEasy()) != null);
        }
        return result;
    }

    public static <T> Map<Arbre<T>, Set<T>> leavesMap(Arbre<T> arbre) {
        HashMap<Arbre<T>, Set<T>> result = new HashMap<Arbre<T>, Set<T>>();
        for (Arbre<T> node : arbre.nodes()) {
            HashSet<T> current = new HashSet<T>();
            result.put(node, current);
            for (Arbre<T> subnode : node.nodes()) {
                if (!subnode.isLeaf()) continue;
                current.add(subnode.getContents());
            }
        }
        return result;
    }

    public static <T> Map<T, Set<T>> debox(Map<Arbre<T>, Set<T>> map) {
        HashMap result = CollUtils.map();
        for (Arbre<T> subt : map.keySet()) {
            if (result.containsKey(subt.getContents())) {
                throw new RuntimeException("Some internal node is not unique");
            }
            result.put(subt.getContents(), map.get(subt));
        }
        return result;
    }

    public static <T> Map<Arbre<T>, Set<T>> ancestorMap(Arbre<T> arbre) {
        HashMap<Arbre<T>, Set<T>> result = new HashMap<Arbre<T>, Set<T>>();
        for (Arbre<T> node : arbre.nodes()) {
            HashSet<T> current = new HashSet<T>();
            result.put(node, current);
            current.add(node.getContents());
            Arbre<T> tmp = node;
            while (!tmp.isRoot()) {
                tmp = tmp.getParent();
                current.add(tmp.getContents());
            }
        }
        return result;
    }

    public static <T> Map<Arbre<T>, Set<T>> nadMap(Arbre<T> arbre) {
        Map<Arbre<T>, Set<T>> ancestors = Arbre.ancestorMap(arbre);
        Map<Arbre<T>, Set<T>> descendants = Arbre.descMap(arbre);
        HashMap<Arbre<T>, Set<T>> result = new HashMap<Arbre<T>, Set<T>>();
        Arbre<T> r = arbre.root();
        List<Arbre<T>> allNodes = r.nodes();
        for (Arbre<T> node : arbre.nodes()) {
            HashSet<T> current = new HashSet<T>();
            result.put(node, current);
            Set<T> currentAnc = ancestors.get(node);
            Set<T> currentDesc = descendants.get(node);
            for (Arbre<T> tmp : allNodes) {
                T content = tmp.getContents();
                if (currentAnc.contains(content) || currentDesc.contains(content)) continue;
                current.add(content);
            }
        }
        return result;
    }

    public static <T> Arbre<T> lowestCommonAncestor(Arbre<T> arbre, Set<T> elements) {
        return Arbre.lowestCommonAncestor(arbre, Arbre.descMap(arbre), elements);
    }

    private static <T> Arbre<T> lowestCommonAncestor(Arbre<T> arbre, Map<Arbre<T>, Set<T>> descMap, Set<T> elements) {
        if (!CollUtils.intersects(descMap.get(arbre), elements)) {
            throw new RuntimeException("Should have nonnull inter:" + descMap.get(arbre) + " and " + elements);
        }
        for (Arbre<T> child : arbre.getChildren()) {
            if (!descMap.get(child).containsAll(elements)) continue;
            return Arbre.lowestCommonAncestor(child, descMap, elements);
        }
        return arbre.copy();
    }

    public static <T> void removeNode(Arbre<T> node) {
        if (node.isRoot()) {
            throw new RuntimeException();
        }
        Iterator<Arbre<T>> parentsChildI = node.getParent().children.iterator();
        while (parentsChildI.hasNext()) {
            Arbre<T> current = parentsChildI.next();
            if (!current.getContents().equals(node.getContents())) continue;
            parentsChildI.remove();
            break;
        }
        for (Arbre<T> nodeChild : node.getChildren()) {
            nodeChild.parent = node.getParent();
            node.getParent().children.add(nodeChild);
        }
        node.parent = null;
        node.children = null;
    }

    public T getContents() {
        return this.contents;
    }

    public void setContents(T contents) {
        this.contents = contents;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isLeaf() {
        return this.children.size() == 0;
    }

    public Arbre<T> getParent() {
        if (this.parent == null) {
            throw new RuntimeException();
        }
        return this.parent;
    }

    public Arbre<T> getParentEasy() {
        if (this.parent == null) {
            return null;
        }
        return this.parent;
    }

    public ArrayList<Arbre<T>> forceGetChildren() {
        return this.children;
    }

    public List<Arbre<T>> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public Arbre<T> copy() {
        Arbre<T> result = Arbre.arbre(this.contents);
        for (Arbre<T> child : this.children) {
            result.addLeaves(child.copy());
        }
        return result;
    }

    protected Arbre() {
    }

    public Arbre(T contents) {
        this.contents = contents;
    }

    public static <T> Arbre<T> arbre(T contents) {
        return new Arbre<T>(contents);
    }

    public static <T> Arbre<T> arbre(T contents, List<Arbre<T>> children) {
        return new Arbre<T>(contents, children);
    }

    public static <T> Arbre<T> arbreWithChildren(T contents, Arbre<T> ... childrenArray) {
        ArrayList<Arbre<T>> children = new ArrayList<Arbre<T>>();
        for (Arbre<T> child : childrenArray) {
            children.add(child);
        }
        return Arbre.arbre(contents, children);
    }

    public static <T> Arbre<T> arbre(T contents, Arbre<T> parent) {
        return new Arbre<T>(contents, parent);
    }

    public Arbre(T contents, Arbre<T> parent) {
        this(contents);
        this.parent = parent;
        if (parent != null) {
            parent.children.add(this);
        }
    }

    public Arbre(T contents, List<Arbre<T>> children) {
        this(contents);
        this.children.addAll(children);
        for (Arbre<T> child : children) {
            child.parent = this;
        }
    }

    public Arbre<T> addLeaves(Arbre<T> ... arbres) {
        for (Arbre<T> arbre : arbres) {
            this.children.add(arbre);
            arbre.parent = this;
        }
        return this;
    }

    public List<Arbre<T>> leaves() {
        ArrayList<Arbre<T>> result = new ArrayList<Arbre<T>>();
        if (this.children.size() == 0) {
            result.add(this);
        }
        for (Arbre<T> child : this.children) {
            result.addAll(child.leaves());
        }
        return result;
    }

    public List<T> leaveContents() {
        ArrayList<T> result = new ArrayList<T>();
        if (this.children.size() == 0) {
            result.add(this.getContents());
        }
        for (Arbre<T> child : this.children) {
            result.addAll(child.leaveContents());
        }
        return result;
    }

    public List<Arbre<T>> nodes() {
        ArrayList<Arbre<T>> result = new ArrayList<Arbre<T>>();
        result.add(this);
        for (Arbre<T> child : this.children) {
            result.addAll(child.nodes());
        }
        return result;
    }

    public List<T> nodeContents() {
        ArrayList<T> result = new ArrayList<T>();
        result.add(this.getContents());
        for (Arbre<T> child : this.children) {
            result.addAll(child.nodeContents());
        }
        return result;
    }

    public List<Arbre<T>> nodesInPostOrder() {
        ArrayList<Arbre<T>> result = new ArrayList<Arbre<T>>();
        for (Arbre<T> child : this.children) {
            result.addAll(child.nodes());
        }
        result.add(this);
        return result;
    }

    public Arbre<T> root() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.root();
    }

    public String toString() {
        return this.contents == null ? null : this.contents.toString();
    }

    public String deepToString() {
        final Arbre root = this;
        return new FancyTreeRenderer(new FancyTreeRenderer.Populator(){

            @Override
            public Object populate() {
                for (Arbre node : Arbre.this.nodes()) {
                    this.add(node, node.parent);
                }
                return root;
            }
        }).toString();
    }

    public String deepToLispString() {
        StringBuilder result = new StringBuilder();
        result.append("(");
        result.append(this.contents == null ? "null" : this.contents.toString());
        for (Arbre<T> arbre : this.getChildren()) {
            result.append(" " + arbre.deepToLispString());
        }
        result.append(")");
        return result.toString();
    }

    public <T2> Arbre<T2> preOrderMap(ArbreMap<T, T2> map) {
        return this.preOrderMap(map, null);
    }

    private <T2> Arbre<T2> preOrderMap(ArbreMap<T, T2> map, Arbre<T2> parent) {
        ((ArbreMap)map).callerImageNode = parent == null ? null : parent.contents;
        T2 currentImageContents = map.map(this);
        Arbre<T2> currentImageNode = null;
        currentImageNode = parent == null ? new Arbre<T2>(currentImageContents) : new Arbre<T2>(currentImageContents, parent);
        for (Arbre<T> child : this.children) {
            super.preOrderMap(map, currentImageNode);
        }
        return currentImageNode;
    }

    public <T2> Arbre<T2> postOrderMap(ArbreMap<T, T2> map) {
        ArrayList<Arbre<T>> childrenImageNodes = new ArrayList<Arbre<T>>();
        ArrayList<T2> childrenImageContents = new ArrayList<T2>();
        for (Arbre<T> child : this.children) {
            Arbre<T2> childrenImageContent = child.postOrderMap(map);
            childrenImageNodes.add(childrenImageContent);
            childrenImageContents.add(childrenImageContent.getContents());
        }
        ((ArbreMap)map).childImageNode = childrenImageContents;
        T2 currentImageContents = map.map(this);
        return new Arbre<T2>(currentImageContents, childrenImageNodes);
    }

    public <T2> Arbre<T2> undirectedPreOrderMap(ArbreMap<T, T2> map) {
        return this.undirectedPreOrderMap(map, null, null, false);
    }

    private <T2> Arbre<T2> undirectedPreOrderMap(ArbreMap<T, T2> map, Arbre<T> caller, Arbre<T2> callerImage, boolean callerIsParent) {
        ((ArbreMap)map).isCallerParent = callerIsParent;
        ((ArbreMap)map).callerImageNode = callerImage == null ? null : callerImage.contents;
        T2 currentImageContents = map.map(this);
        Arbre<T2> currentImageNode = null;
        currentImageNode = caller == null ? new Arbre<T2>(currentImageContents) : (callerIsParent ? new Arbre<T2>(currentImageContents, callerImage) : new Arbre<T2>(currentImageContents, Collections.singletonList(callerImage)));
        if (this.parent != null && caller != this.parent) {
            super.undirectedPreOrderMap(map, this, currentImageNode, false);
        }
        for (Arbre<T> child : this.children) {
            if (caller == child) continue;
            super.undirectedPreOrderMap(map, this, currentImageNode, true);
        }
        return currentImageNode;
    }

    public static <T> Arbre<String> arbreToArbreOfStrings(Arbre<T> a) {
        return a.postOrderMap(new ArbreMap<T, String>(){

            @Override
            public String map(Arbre<T> currentDomainNode) {
                return currentDomainNode.getContents().toString();
            }
        });
    }

    public static void main(String[] args) {
    }

    public int nLeaves() {
        int result = 0;
        for (Arbre<T> desc : this.nodes()) {
            if (!desc.isLeaf()) continue;
            ++result;
        }
        return result;
    }

    public List<Arbre<T>> getLeaves() {
        return this.leaves();
    }

    public static boolean isAncestorOf(Arbre<String> a1, Arbre<String> a2) {
        while (true) {
            if (a1.getContents().equals(a2.getContents())) {
                return true;
            }
            if (a1.isRoot()) break;
            a1 = a1.getParent();
        }
        return false;
    }

    public int nInternalNodes() {
        if (this.isLeaf()) {
            return 0;
        }
        int n = 1;
        for (Arbre<T> child : this.children) {
            n += child.nInternalNodes();
        }
        return n;
    }

    public static class Lispify
    extends ArbreMap<String, String> {
        @Override
        public String map(Arbre<String> currentDomainNode) {
            StringBuilder result = new StringBuilder();
            result.append("(" + currentDomainNode.toString());
            for (String childLisp : this.getChildImage()) {
                result.append(" " + childLisp);
            }
            result.append(")");
            return result.toString();
        }
    }

    public static class AppendPathFromRoot
    extends ArbreMap<String, String> {
        @Override
        public String map(Arbre<String> currentDomainNode) {
            if (this.getCallerImage() == null) {
                return currentDomainNode.getContents();
            }
            return (this.isCallerParent() ? "" : "-") + currentDomainNode.getContents() + (String)this.getCallerImage();
        }
    }

    public static abstract class ArbreMap<S1, S2> {
        private boolean isCallerParent = true;
        private S2 callerImageNode = null;
        private List<S2> childImageNode = null;

        public final boolean isCallerParent() {
            return this.isCallerParent;
        }

        public final S2 getCallerImage() {
            return this.callerImageNode;
        }

        public final List<S2> getChildImage() {
            return Collections.unmodifiableList(this.childImageNode);
        }

        public abstract S2 map(Arbre<S1> var1);
    }
}

