/*
 * Decompiled with CFR 0.152.
 */
package pepper.editmodel;

import fig.basic.ListUtils;
import fig.basic.NumUtils;
import fig.prob.Dirichlet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;
import nuts.util.Counter;
import pepper.Edit;
import pepper.Encodings;
import pepper.editmodel.ConstrainedEditMDParametrization;
import pepper.editmodel.EditParam;

public class EditSampler
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Random random;
    private EditMultiDirichletParametrization prior;

    public EditSampler(Random random, EditMultiDirichletParametrization prior) {
        this.random = random;
        this.prior = prior;
    }

    public EditMultiDirichletParametrization sample() {
        return this.sample(new Counter<Edit>());
    }

    public EditMultiDirichletParametrization sample(Counter<Edit> edits) {
        return this.sample(edits, false);
    }

    public EditMultiDirichletParametrization sample(Counter<Edit> edits, boolean viterbi) {
        EditMultiDirichletParametrization posterior = this.prior.newInstance(edits);
        for (int i = 0; i < posterior.numberOfDistribution(); ++i) {
            int j;
            for (j = 0; j < posterior.getParameters(i).length; ++j) {
                double[] dArray = posterior.getParameters(i);
                int n = j;
                dArray[n] = dArray[n] + this.prior.getParameters(i)[j];
            }
            if (viterbi) {
                for (j = 0; j < posterior.getParameters(i).length; ++j) {
                    double[] dArray = posterior.getParameters(i);
                    int n = j;
                    dArray[n] = dArray[n] - 1.0;
                    if (!(posterior.getParameters(i)[j] < 0.0)) continue;
                    posterior.getParameters((int)i)[j] = 0.0;
                }
                NumUtils.normalize(posterior.getParameters(i));
                continue;
            }
            Dirichlet dir = new Dirichlet(posterior.getParameters(i));
            posterior.setParameters(i, dir.sample(this.random));
        }
        return posterior;
    }

    public static void main(String[] args) {
        Encodings enc = Encodings.toyEncodings();
        int NC = enc.getNumberOfEqClasses();
        int alpha = enc.getNumberOfPhonemes();
        int a = enc.char2PhoneId('a');
        int b = enc.char2PhoneId('b');
        int c = enc.char2PhoneId('c');
        int bc = enc.getBoundaryEqClassId();
        double a2a = 0.0;
        double a2b = 0.0;
        double b2b = 0.0;
        double b2c = 0.0;
        for (int i = 0; i < 100; ++i) {
            ArrayList<Edit> edits = ListUtils.newList(new Edit(enc, bc, a, bc, b));
            ConstrainedEditMDParametrization prior = EditSampler.getToyPrior();
            EditSampler sampler = new EditSampler(new Random(1L), prior);
            EditMultiDirichletParametrization posterior = null;
            EditParam editParam = posterior.getEditParameters();
            a2a += editParam.substitutionCost(bc, a, bc, a);
            a2b += editParam.substitutionCost(bc, a, bc, b);
            b2b += editParam.substitutionCost(bc, b, bc, b);
            b2c += editParam.substitutionCost(bc, b, bc, c);
        }
        System.out.println(a2a / 100.0);
        System.out.println(a2b / 100.0);
        System.out.println(b2b / 100.0);
        System.out.println(b2c / 100.0);
    }

    private static ConstrainedEditMDParametrization getToyPrior() {
        Encodings enc = Encodings.toyEncodings();
        int NC = enc.getNumberOfEqClasses();
        int alpha = enc.getNumberOfPhonemes();
        ArrayList<Edit> rules = new ArrayList<Edit>();
        int a = enc.char2PhoneId('a');
        int b = enc.char2PhoneId('b');
        int c = enc.char2PhoneId('c');
        int bc = enc.getBoundaryEqClassId();
        rules.add(new Edit(enc, bc, a, bc, b));
        rules.add(new Edit(enc, bc, b, bc, c));
        return new ConstrainedEditMDParametrization(enc, rules, 1.0, 1.0, false);
    }

    public EditMultiDirichletParametrization getPrior() {
        return this.prior;
    }

    public static interface EditMultiDirichletParametrization
    extends Serializable {
        public double[] getParameters(int var1);

        public void setParameters(int var1, double[] var2);

        public int numberOfDistribution();

        public EditParam getEditParameters();

        public EditMultiDirichletParametrization newInstance(Counter<Edit> var1);
    }
}

