/*
 * Decompiled with CFR 0.152.
 */
package practice;

import ev.hmm.HetPairHMM;
import ev.par.ExponentialFamily;
import ev.par.FeatureExtractor;
import fig.basic.LogInfo;
import goblin.Taxon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import ma.SequenceType;
import nuts.maxent.MaxentClassifier;
import nuts.util.CollUtils;
import org.jblas.DoubleMatrix;
import pepper.Encodings;
import practice.DataInput;
import practice.ForestState;

public class Language {
    public static final int BEG = 95;
    public static final int END = 96;
    public Hashtable<Integer, List<Cognate>> wordlist = new Hashtable();
    public String name;
    public int totalBranch;
    public HashMap<Integer, ArrayList<Double>> data = null;
    public Language[] children;
    public int branch;
    public double likelihood;
    public StringBuilder sequence = new StringBuilder();
    private double[][] bigram;

    public Language(String name) {
        this.name = name;
    }

    public Language(Language l0, Language l1, int branch, int totalBranch) {
        this.children = new Language[2];
        this.children[0] = l0;
        this.children[1] = l1;
        this.branch = branch;
        this.totalBranch = totalBranch;
        this.name = "(" + l0.name + ", " + l1.name + ", " + this.totalBranch + ")";
        this.data = new HashMap();
    }

    public void coalesce(ForestState.RateMatrix Q) {
        double condProb = 0.0;
        LogInfo.logs("Merging... ");
        try {
            LogInfo.logs(this.children[0].name + " with " + this.children[1].name + "... ");
        }
        catch (Exception exception) {
            // empty catch block
        }
        LogInfo.logs("with branch length=" + this.branch);
        DoubleMatrix P = Q.computeCondProb(this.branch);
        for (int p = 0; p < DataInput.SEQ_LENGTH; ++p) {
            ArrayList<Object> childLikelihood = null;
            double[] lik = new double[2];
            ArrayList<Double> siteLikelihood = new ArrayList<Double>();
            for (int z = 0; z < DataInput.NUM_SOUNDS; ++z) {
                lik[0] = 0.0;
                lik[1] = 0.0;
                for (int l = 0; l < 2; ++l) {
                    int x;
                    if (this.children[l].data == null) {
                        LogInfo.logs(this.children[l].name + " does not have data.");
                        this.children[l].data = new HashMap();
                    }
                    if (this.children[l].data.containsKey(p)) {
                        childLikelihood = this.children[l].data.get(p);
                    } else {
                        childLikelihood = new ArrayList();
                        for (x = 0; x < DataInput.NUM_SOUNDS; ++x) {
                            childLikelihood.add(x, DataInput.PI);
                        }
                    }
                    for (x = 0; x < DataInput.NUM_SOUNDS; ++x) {
                        condProb = P.get(z, x);
                        int n = l;
                        lik[n] = lik[n] + condProb * (Double)childLikelihood.get(x);
                    }
                }
                double likelihoodZ = lik[0] * lik[1];
                siteLikelihood.add(z, likelihoodZ);
                this.likelihood += DataInput.PI * likelihoodZ;
            }
            this.data.put(p, siteLikelihood);
        }
    }

    public double likelihood() {
        return this.likelihood;
    }

    public void addData(Integer key, int val, char ch) {
        while (this.sequence.length() < key - 1) {
            this.sequence.append("-");
        }
        this.sequence.append(ch);
        if (this.data == null) {
            LogInfo.logs(this.name + " data being initialized.");
            this.data = new HashMap();
        }
        ArrayList<Double> soundLikelihood = new ArrayList<Double>();
        if (!this.data.containsKey(key)) {
            this.data.put(key, soundLikelihood);
        }
        for (int i = 0; i < DataInput.NUM_SOUNDS; ++i) {
            soundLikelihood.add(i, 0.0);
        }
        this.data.get(key).set(val, DataInput.PI);
        this.likelihood += DataInput.PI;
    }

    public String toString() {
        if (this.children == null) {
            return this.name;
        }
        StringBuilder sb = new StringBuilder();
        Language l0 = this.children[0];
        Language l1 = this.children[1];
        sb.append("(");
        sb.append(l0.toString());
        sb.append(", ");
        sb.append(l1.toString());
        sb.append(", " + this.totalBranch + ")");
        return sb.toString();
    }

    public void addWord(int cognateGroup, String meaning, String word) {
        int i = meaning.hashCode();
        if (!this.wordlist.containsKey(i)) {
            this.wordlist.put(i, new ArrayList());
        }
        List<Cognate> cognates = this.wordlist.get(i);
        cognates.add(new Cognate(cognateGroup, meaning, word));
    }

    public void learnBigram() {
        Set<Character> chars = null;
        Encodings encoding = null;
        try {
            chars = Encodings.allCharsInRealEnc();
            encoding = Encodings.realEncoding();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int N = chars.size();
        this.bigram = new double[N + 2][N + 2];
        ArrayList<Integer> deleteList = CollUtils.list();
        int row = 0;
        int col = 0;
        for (Integer key : this.wordlist.keySet()) {
            List<Cognate> words = this.wordlist.get(key);
            for (Cognate cognate : words) {
                String word = cognate.word;
                for (int i = 0; i <= word.length(); ++i) {
                    row = i == 0 ? 95 : encoding.char2PhoneId(word.charAt(i - 1));
                    int n = col = i == word.length() ? 96 : encoding.char2PhoneId(word.charAt(i));
                    if (col < 0 || row < 0) {
                        deleteList.add(key);
                        continue;
                    }
                    double[] dArray = this.bigram[row];
                    int n2 = col;
                    dArray[n2] = dArray[n2] + 1.0;
                }
            }
        }
        for (Integer key : deleteList) {
            this.wordlist.remove(key);
        }
        for (int r = 0; r < this.bigram.length; ++r) {
            int c;
            int total = 0;
            for (c = 0; c < this.bigram.length; ++c) {
                double[] dArray = this.bigram[r];
                int n = c;
                dArray[n] = dArray[n] + 1.0;
                total = (int)((double)total + this.bigram[r][c]);
            }
            for (c = 0; c < this.bigram.length; ++c) {
                this.bigram[r][c] = this.bigram[r][c] / (double)total;
            }
        }
    }

    public double logp(String x) {
        Encodings encoding = null;
        try {
            encoding = Encodings.realEncoding();
        }
        catch (Exception exception) {
            // empty catch block
        }
        double p = Math.log(this.bigram[95][encoding.char2PhoneId(x.charAt(0))]);
        for (int i = 1; i < x.length(); ++i) {
            int r = encoding.char2PhoneId(x.charAt(i - 1));
            int c = encoding.char2PhoneId(x.charAt(i));
            if (r < 0 || c < 0) {
                LogInfo.logs(x);
                LogInfo.logs(x.charAt(i - 1) + ", " + x.charAt(i));
            }
            p += Math.log(this.bigram[r][c]);
        }
        return p;
    }

    public int[][] learn(Language other, int numIter, double threshold) {
        ExponentialFamily.ExponentialFamilyOptions opt = new ExponentialFamily.ExponentialFamilyOptions();
        opt.encodingType = SequenceType.PHONEMES;
        FeatureExtractor.FeatureOptions fopt = new FeatureExtractor.FeatureOptions();
        fopt.hydrophobicModeling = false;
        ExponentialFamily fam = ExponentialFamily.createExpfam(new MaxentClassifier.MaxentOptions<Object>(), opt, fopt, null);
        Taxon lang1 = new Taxon(this.name);
        Taxon lang2 = new Taxon(other.name);
        HetPairHMM hh = null;
        double p = 0.5;
        int[][] pr = new int[numIter][3];
        for (int iter = 0; iter < numIter; ++iter) {
            int numWords = 0;
            double suff = 0.0;
            for (Integer key : this.wordlist.keySet()) {
                if (!this.wordlist.containsKey(key) || !other.wordlist.containsKey(key)) continue;
                List<Cognate> words1 = this.wordlist.get(key);
                List<Cognate> words2 = other.wordlist.get(key);
                for (Cognate c1 : words1) {
                    String w1 = c1.word;
                    for (Cognate c2 : words2) {
                        String w2 = c2.word;
                        ++numWords;
                        hh = fam.getHMM(w1, w2, lang1, lang2);
                        fam.addSufficientStatistics(hh, lang1, lang2);
                        double joint = Math.exp(hh.logSumProduct());
                        double logpx = Math.exp(this.logp(w1));
                        double logpy = Math.exp(other.logp(w2));
                        double alpha = p * joint / ((1.0 - p) * logpx * logpy + p * joint);
                        if (iter == numIter - 1) {
                            LogInfo.logs(hh.viterbi());
                            LogInfo.logs((alpha > threshold) + ", " + (c1.groupId == c2.groupId));
                        }
                        int[] nArray = pr[iter];
                        nArray[0] = nArray[0] + (c1.groupId == c2.groupId ? 1 : 0);
                        if (alpha > threshold) {
                            int[] nArray2 = pr[iter];
                            nArray2[1] = nArray2[1] + 1;
                            if (c1.groupId == c2.groupId) {
                                int[] nArray3 = pr[iter];
                                nArray3[2] = nArray3[2] + 1;
                            }
                        }
                        suff += alpha;
                    }
                }
            }
            if (numWords <= 0) continue;
            fam.updateParameters();
            p = suff / (double)numWords;
        }
        return pr;
    }

    public double computeDistance(Language other, boolean weighted) {
        double total = 0.0;
        if (!weighted) {
            for (Integer key : this.wordlist.keySet()) {
                List<Cognate> words1 = this.wordlist.get(key);
                List<Cognate> words2 = this.wordlist.get(key);
                for (Cognate c1 : words1) {
                    String w1 = c1.word;
                    for (Cognate c2 : words2) {
                        String w2 = c2.word;
                        total += (double)this.minEditDistance(w1, w2);
                    }
                }
            }
        }
        if (total == 0.0) {
            LogInfo.logs(other.name);
        }
        return total /= (double)this.wordlist.size() * (double)other.wordlist.size();
    }

    public int minEditDistance(String x, String y) {
        int[][] table = new int[x.length() + 1][y.length() + 1];
        for (int r = 0; r <= x.length(); ++r) {
            for (int c = 0; c <= y.length(); ++c) {
                if (r == c && c == 0) continue;
                if (Math.min(r, c) == 0) {
                    table[r][c] = Math.max(r, c);
                    continue;
                }
                int sub = x.charAt(r - 1) == y.charAt(c - 1) ? 0 : 2;
                table[r][c] = Math.min(Math.min(table[r - 1][c] + 1, table[r][c - 1] + 1), table[r - 1][c - 1] + sub);
            }
        }
        return table[x.length()][y.length()];
    }

    public static class Cognate {
        public String word;
        public String meaning;
        public Taxon lang;
        public boolean recognizable = true;
        public int groupId;

        public Cognate(int groupId, String meaning, String word) {
            this.word = word;
            this.meaning = meaning;
            this.groupId = groupId;
        }

        public Cognate(int groupId, String meaning, String word, Taxon lang) {
            this(groupId, meaning, word);
            this.lang = lang;
        }
    }
}

