/*
 * Decompiled with CFR 0.152.
 */
package pty.smc;

import conifer.Phylogeny;
import conifer.data.TaxonIndexedData;
import conifer.particle.FiniteGenerationParticle;
import conifer.particle.PhyloParticle;
import conifer.particle.PhyloParticleInitContext;
import conifer.ssm.SSMModelCalculator;
import fig.basic.NumUtils;
import fig.basic.Option;
import fig.basic.Pair;
import goblin.Taxon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import monaco.Density;
import nuts.io.IO;
import nuts.maxent.SloppyMath;
import nuts.util.Arbre;
import nuts.util.CollUtils;
import pty.Observations;
import pty.RootedTree;
import pty.UnrootedTree;
import pty.io.Dataset;
import pty.smc.models.BrownianModel;
import pty.smc.models.BrownianModelCalculator;
import pty.smc.models.CTMC;
import pty.smc.models.DiscreteModelCalculator;
import pty.smc.models.FastDiscreteModelCalculator;
import pty.smc.models.ForestModelCalculator;
import pty.smc.models.LikelihoodModelCalculator;
import pty.smc.models.NoLikelihoodModel;
import pty.smc.test.PhyloHash;

public class PartialCoalescentState
implements PhyloParticle,
FiniteGenerationParticle {
    public List<Pair<Taxon, LikelihoodModelCalculator>> calculators;
    public PhyloParticleInitContext context;
    private double logPrior = Double.NaN;
    private Density<PhyloParticle> priorFct;
    @Option
    public static boolean disableUnrooted = true;
    @Option
    public static boolean useExtendedLogLL = false;
    @Option
    public static boolean useStar = false;
    public static boolean alwaysComputeTopMessage = false;
    private final boolean isClock;
    private TaxonIndexedData data;
    private Observations obs;
    List<Arbre<CoalescentNode>> roots;
    private final double topHeight;
    private final CoalescentNode topNode;
    private int nLeaves;
    private final double oldLogLikelihood;
    private double logWeightCache;
    public transient Set<Set<Taxon>> mapped = null;
    private transient double _logLikelihood = Double.NaN;

    public PartialCoalescentState() {
        this.topHeight = 0.0;
        this.topNode = null;
        this.oldLogLikelihood = 0.0;
        this.isClock = false;
    }

    @Override
    public void init(List<Pair<Taxon, LikelihoodModelCalculator>> calculators, Density<PhyloParticle> prior, PhyloParticleInitContext context) {
        this.calculators = calculators;
        this.context = context;
        if (this.obs != null) {
            throw new RuntimeException("Looks like trying to init PCS created from legacy constructors");
        }
        if (context.getTaxonIndexedData() instanceof Observations) {
            this.obs = (Observations)((Object)context.getTaxonIndexedData());
        }
        this.data = context.getTaxonIndexedData();
        ArrayList<Arbre<CoalescentNode>> roots = new ArrayList<Arbre<CoalescentNode>>();
        for (int i = 0; i < calculators.size(); ++i) {
            Taxon name = calculators.get(i).getFirst();
            LikelihoodModelCalculator calculator = calculators.get(i).getSecond();
            roots.add(Arbre.arbre(new CoalescentNode(Collections.singleton(name), calculator, 0.0, name, 0.0, 0.0)));
        }
        this.roots = roots;
        this.nLeaves = roots.size();
        this.priorFct = prior;
        this.logPrior = this.priorFct.logDensity(this);
    }

    @Override
    public Phylogeny getPhylogeny() {
        return this.getFullCoalescentState();
    }

    @Override
    public double getLogLikelihood() {
        return this.logLikelihood();
    }

    @Override
    public double getLogPrior() {
        return this.logPrior;
    }

    @Override
    public int nGenerationsLeft() {
        return this.nIterationsLeft();
    }

    public boolean isClock() {
        return this.isClock;
    }

    public int nIterationsLeft() {
        return this.roots.size() - 1;
    }

    public boolean isFinalState() {
        return this.nIterationsLeft() == 0;
    }

    public boolean isInitialState() {
        return this.topNode == null;
    }

    public int nRoots() {
        return this.roots.size();
    }

    public double topHeight() {
        return this.topHeight;
    }

    public int nNonTrivialRoots() {
        int i = 0;
        for (Arbre<CoalescentNode> subt : this.roots) {
            if (subt.isLeaf()) continue;
            ++i;
        }
        return i;
    }

    public int peekNNonTrivialRoots(int i1, int i2) {
        int result = this.nNonTrivialRoots();
        if (this.roots.get(i1).isLeaf() && this.roots.get(i2).isLeaf()) {
            return result + 1;
        }
        if (this.roots.get(i1).isLeaf() || this.roots.get(i2).isLeaf()) {
            return result;
        }
        return result - 1;
    }

    public void setWeight(double weight) {
        this.logWeightCache = weight;
    }

    public double getWeight() {
        return this.logWeightCache;
    }

    public int getLeaves() {
        return this.nLeaves;
    }

    public Map<Taxon, LikelihoodModelCalculator> getTopLevelModelCalculators() {
        HashMap<Taxon, LikelihoodModelCalculator> result = CollUtils.map();
        for (Arbre<CoalescentNode> subt : this.roots) {
            result.put(subt.getContents().nodeIdentifier, subt.getContents().likelihoodModelCache);
        }
        return result;
    }

    public Map<Taxon, Integer> rootsTaxa() {
        HashMap<Taxon, Integer> result = CollUtils.map();
        int i = 0;
        for (Arbre<CoalescentNode> root : this.roots) {
            result.put(root.getContents().nodeIdentifier, i++);
        }
        return result;
    }

    public Arbre<Taxon> getUnlabeledArbre() {
        if (!this.isFinalState()) {
            throw new RuntimeException();
        }
        Arbre<Taxon> result = this.roots.get(0).preOrderMap(new Arbre.ArbreMap<CoalescentNode, Taxon>(){

            @Override
            public Taxon map(Arbre<CoalescentNode> currentDomainNode) {
                return currentDomainNode.getContents().nodeIdentifier;
            }
        });
        return result;
    }

    public PhyloHash.Phylo<Double> getPhylo() {
        if (!this.isFinalState()) {
            throw new RuntimeException();
        }
        return this.cnode2phylo(this.roots.get(0));
    }

    private PhyloHash.Phylo<Double> cnode2phylo(Arbre<CoalescentNode> arbre) {
        Double h = arbre.getContents().height;
        HashSet children = new HashSet();
        for (Arbre<CoalescentNode> c : arbre.getChildren()) {
            children.add(this.cnode2phylo(c));
        }
        return new PhyloHash.Phylo<Double>(h, children);
    }

    public List<Arbre<CoalescentNode>> getRoots() {
        return this.roots;
    }

    public LikelihoodModelCalculator getLikelihoodModelCalculator(int j) {
        return this.roots.get((int)j).getContents().likelihoodModelCache;
    }

    public boolean isReversible() {
        return this.roots.get((int)0).getContents().likelihoodModelCache.isReversible();
    }

    public double getHeight(int j) {
        return this.roots.get((int)j).getContents().height;
    }

    public RootedTree getFullCoalescentState() {
        if (!this.isFinalState()) {
            throw new RuntimeException();
        }
        final Pair<Arbre<Taxon>, Map<Taxon, Double>> pair = this.getArbreAndBranchLengths();
        return new RootedTree(){

            @Override
            public Arbre<Taxon> topology() {
                return (Arbre)pair.getFirst();
            }

            @Override
            public Map<Taxon, Double> branchLengths() {
                return (Map)pair.getSecond();
            }

            @Override
            public int nTaxa() {
                return ((Arbre)pair.getFirst()).nLeaves();
            }

            @Override
            public RootedTree getRooted() {
                return this;
            }

            @Override
            public UnrootedTree getUnrooted() {
                return UnrootedTree.fromRooted(this);
            }
        };
    }

    public RootedTree getSubtree(int i) {
        final Pair<Arbre<Taxon>, Map<Taxon, Double>> pair = this.getArbreAndBranchLengths(i);
        return new RootedTree(){

            @Override
            public Arbre<Taxon> topology() {
                return (Arbre)pair.getFirst();
            }

            @Override
            public Map<Taxon, Double> branchLengths() {
                return (Map)pair.getSecond();
            }

            @Override
            public int nTaxa() {
                return ((Arbre)pair.getFirst()).nLeaves();
            }

            @Override
            public RootedTree getRooted() {
                return this;
            }

            @Override
            public UnrootedTree getUnrooted() {
                return UnrootedTree.fromRooted(this);
            }
        };
    }

    public double nonClockLogWeight() {
        if (this.isClock()) {
            throw new RuntimeException();
        }
        double logSum = Double.NEGATIVE_INFINITY;
        for (Arbre<CoalescentNode> root : this.roots) {
            if (root.isLeaf()) continue;
            if (root.getChildren().size() != 2) {
                throw new RuntimeException();
            }
            double logCur = root.getChildren().get((int)0).getContents().likelihoodModelCache.logLikelihood() + root.getChildren().get((int)1).getContents().likelihoodModelCache.logLikelihood() - root.getContents().likelihoodModelCache.logLikelihood();
            logSum = SloppyMath.logAdd(logSum, logCur);
        }
        return -logSum;
    }

    public double logLikelihoodRatio() {
        return this.logLikelihood() - this.oldLogLikelihood;
    }

    public double logLikelihood() {
        if (!Double.isNaN(this._logLikelihood)) {
            return this._logLikelihood;
        }
        if (useStar) {
            return this.starLogLikelihood();
        }
        return this.stdLogLikelihood();
    }

    private double stdLogLikelihood() {
        if (this.roots.size() == this.nLeaves) {
            return 0.0;
        }
        this._logLikelihood = 0.0;
        for (Arbre<CoalescentNode> root : this.roots) {
            CoalescentNode current = root.getContents();
            if (useExtendedLogLL) {
                this._logLikelihood += current.likelihoodModelCache.extendLogLikelihood(this.topHeight - current.height);
                continue;
            }
            this._logLikelihood += current.likelihoodModelCache.logLikelihood();
        }
        return this._logLikelihood;
    }

    private double starLogLikelihood() {
        double max = Double.NEGATIVE_INFINITY;
        double argmax = -1.0;
        for (double curDelt = 0.005; curDelt < 20.0; curDelt *= 2.0) {
            double cur = this.starLogLikelihood(curDelt);
            if (!(cur > max)) continue;
            max = cur;
            argmax = curDelt;
        }
        return max;
    }

    private double starLogLikelihood(double plusDelta) {
        IO.warnOnce("Using star log likelihood...");
        if (this.isInitialState()) {
            return 0.0;
        }
        ArrayList<Double> deltas = CollUtils.list();
        ArrayList<DiscreteModelCalculator> calcs = CollUtils.list();
        for (Arbre<CoalescentNode> root : this.roots) {
            deltas.add(this.topHeight - root.getContents().height + plusDelta);
            calcs.add((DiscreteModelCalculator)root.getContents().likelihoodModelCache);
        }
        double result = DiscreteModelCalculator.starCombine(deltas, calcs);
        return result;
    }

    public CTMC getCTMC() {
        return ((DiscreteModelCalculator)this.roots.get((int)0).getContents().likelihoodModelCache).ctmc;
    }

    public boolean isBrownianMotion() {
        return this.roots.get((int)0).getContents().likelihoodModelCache instanceof BrownianModelCalculator;
    }

    public Map<Taxon, double[]> getObservations(int site) {
        if (!this.isFinalState()) {
            throw new RuntimeException();
        }
        HashMap<Taxon, double[]> result = new HashMap<Taxon, double[]>();
        for (Arbre<CoalescentNode> node : this.roots.get(0).nodes()) {
            DiscreteModelCalculator dmc;
            if (!node.isLeaf() || (dmc = (DiscreteModelCalculator)node.getContents().likelihoodModelCache).isMissing(site)) continue;
            double[] cacheCopy = dmc.getCacheCopy(site);
            NumUtils.expNormalize(cacheCopy);
            result.put(node.getContents().nodeIdentifier, cacheCopy);
        }
        return result;
    }

    public Pair<Arbre<Taxon>, Map<Taxon, Double>> getArbreAndBranchLengths(int i) {
        final HashMap bls = new HashMap();
        Arbre<Taxon> result = this.roots.get(i).postOrderMap(new Arbre.ArbreMap<CoalescentNode, Taxon>(){
            int nodeId = 0;

            @Override
            public Taxon map(Arbre<CoalescentNode> currentDomainNode) {
                Taxon current = currentDomainNode.getContents().nodeIdentifier;
                if (current == null) {
                    current = new Taxon("internal_" + this.nodeId++);
                }
                if (!currentDomainNode.isLeaf()) {
                    List childImage = this.getChildImage();
                    bls.put(childImage.get(0), currentDomainNode.getContents().leftBranchLength);
                    bls.put(childImage.get(1), currentDomainNode.getContents().rightBranchLength);
                }
                return current;
            }
        });
        return Pair.makePair(result, bls);
    }

    public Pair<Arbre<Taxon>, Map<Taxon, Double>> getArbreAndBranchLengths() {
        if (!this.isFinalState()) {
            throw new RuntimeException();
        }
        final HashMap bls = new HashMap();
        Arbre<Taxon> result = this.roots.get(0).postOrderMap(new Arbre.ArbreMap<CoalescentNode, Taxon>(){
            int nodeId = 0;

            @Override
            public Taxon map(Arbre<CoalescentNode> currentDomainNode) {
                Taxon current = currentDomainNode.getContents().nodeIdentifier;
                if (current == null) {
                    current = new Taxon("internal_" + this.nodeId++);
                }
                if (!currentDomainNode.isLeaf()) {
                    List childImage = this.getChildImage();
                    bls.put(childImage.get(0), currentDomainNode.getContents().leftBranchLength);
                    bls.put(childImage.get(1), currentDomainNode.getContents().rightBranchLength);
                }
                return current;
            }
        });
        return Pair.makePair(result, bls);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        int i = 0;
        for (Arbre<CoalescentNode> root : this.roots) {
            result.append("Root " + (i++ + 1) + "/" + this.roots.size() + "(LL=" + root.getContents().likelihoodModelCache.logLikelihood() + "):\n" + root.preOrderMap(new Arbre.ArbreMap<CoalescentNode, String>(){

                @Override
                public String map(Arbre<CoalescentNode> currentDomainNode) {
                    Taxon nodeId = currentDomainNode.getContents().nodeIdentifier;
                    double h = currentDomainNode.getContents().height;
                    return "" + (nodeId == null ? "<internal>" : nodeId) + "@h=" + h;
                }
            }).deepToString());
        }
        return result.toString();
    }

    @Deprecated
    public static PartialCoalescentState initialState(List<LikelihoodModelCalculator> leaves, List<Taxon> leavesNames, Observations obs, boolean isClock) {
        if (leaves.size() != leavesNames.size()) {
            throw new RuntimeException();
        }
        ArrayList<Arbre<CoalescentNode>> roots = new ArrayList<Arbre<CoalescentNode>>();
        for (int i = 0; i < leaves.size(); ++i) {
            roots.add(Arbre.arbre(new CoalescentNode(Collections.singleton(leavesNames.get(i)), leaves.get(i), 0.0, leavesNames.get(i), 0.0, 0.0)));
        }
        return new PartialCoalescentState(roots, 0.0, leaves.size(), null, 0.0, obs, isClock, null, null, null, null);
    }

    @Deprecated
    public static PartialCoalescentState initState(Dataset data, BrownianModel bm, boolean resampleRoot) {
        ArrayList<Taxon> leafNames = new ArrayList<Taxon>();
        ArrayList<LikelihoodModelCalculator> leaves = new ArrayList<LikelihoodModelCalculator>();
        Map<Taxon, double[][]> observations = data.observations();
        for (Taxon lang : observations.keySet()) {
            leafNames.add(lang);
            double[][] cObs = observations.get(lang);
            double[] converted = new double[cObs.length];
            for (int i = 0; i < converted.length; ++i) {
                converted[i] = cObs[i][0];
            }
            leaves.add(BrownianModelCalculator.observation(converted, bm, resampleRoot));
        }
        return PartialCoalescentState.initialState(leaves, leafNames, data, disableUnrooted);
    }

    public static PartialCoalescentState initState(List leavesNames) {
        return PartialCoalescentState.initState(leavesNames, disableUnrooted);
    }

    public static PartialCoalescentState initState(List leavesNames, boolean clock) {
        ArrayList<Taxon> leafNames = new ArrayList<Taxon>();
        ArrayList<LikelihoodModelCalculator> leaves = new ArrayList<LikelihoodModelCalculator>();
        for (int i = 0; i < leavesNames.size(); ++i) {
            leafNames.add(new Taxon(leavesNames.get(i).toString()));
            leaves.add(new NoLikelihoodModel());
        }
        return PartialCoalescentState.initialState(leaves, leafNames, null, clock);
    }

    @Deprecated
    public static PartialCoalescentState initState(Dataset data, CTMC ctmc) {
        return PartialCoalescentState.initState(data, ctmc, null, null);
    }

    public static PartialCoalescentState initForestState(Dataset data, CTMC ctmc, double rootHeight, double langInvRate) {
        return PartialCoalescentState.initState(data, ctmc, rootHeight, langInvRate);
    }

    private static PartialCoalescentState initState(Dataset data, CTMC ctmc, Double rootHeight, Double langInvRate) {
        ArrayList<Taxon> leafNames = new ArrayList<Taxon>();
        ArrayList<LikelihoodModelCalculator> leaves = new ArrayList<LikelihoodModelCalculator>();
        Map<Taxon, double[][]> observations = data.observations();
        for (Taxon lang : observations.keySet()) {
            leafNames.add(lang);
            if (rootHeight == null && langInvRate == null) {
                leaves.add(DiscreteModelCalculator.observation(ctmc, observations.get(lang)));
                continue;
            }
            if (rootHeight != null && langInvRate != null) {
                leaves.add(ForestModelCalculator.observation(ctmc, observations.get(lang), rootHeight, langInvRate));
                continue;
            }
            throw new RuntimeException();
        }
        return PartialCoalescentState.initialState(leaves, leafNames, data, true);
    }

    @Deprecated
    public static PartialCoalescentState initFastState(Dataset data, CTMC ctmc) {
        return PartialCoalescentState.initFastState(false, data, ctmc, true);
    }

    @Deprecated
    public static PartialCoalescentState initFastState(Dataset data, CTMC ctmc, boolean isClock) {
        return PartialCoalescentState.initFastState(false, data, ctmc, isClock);
    }

    @Deprecated
    public static PartialCoalescentState initFastState(boolean resampleRoot, Dataset data, CTMC ctmc) {
        return PartialCoalescentState.initFastState(resampleRoot, data, ctmc, true);
    }

    @Deprecated
    public static PartialCoalescentState initFastState(boolean resampleRoot, Dataset data, CTMC ctmc, boolean isClock) {
        ArrayList<Taxon> leafNames = new ArrayList<Taxon>();
        ArrayList<LikelihoodModelCalculator> leaves = new ArrayList<LikelihoodModelCalculator>();
        Map<Taxon, double[][]> observations = data.observations();
        for (Taxon lang : observations.keySet()) {
            leafNames.add(lang);
            leaves.add(FastDiscreteModelCalculator.observation(ctmc, observations.get(lang), resampleRoot));
        }
        return PartialCoalescentState.initialState(leaves, leafNames, data, isClock);
    }

    public static PartialCoalescentState initSSMState(Map<Taxon, List<String>> data) {
        ArrayList<Taxon> leafNames = new ArrayList<Taxon>();
        ArrayList<LikelihoodModelCalculator> leaves = new ArrayList<LikelihoodModelCalculator>();
        for (Taxon taxon : data.keySet()) {
            leafNames.add(taxon);
            leaves.add(new SSMModelCalculator(data.get(taxon)));
        }
        return PartialCoalescentState.initialState(leaves, leafNames, null, true);
    }

    private static Set<Set<Taxon>> singletons(boolean rooted, List<Taxon> leavesNames) {
        HashSet<Set<Taxon>> result = new HashSet<Set<Taxon>>();
        for (Taxon lang : leavesNames) {
            result.add(Collections.singleton(lang));
            if (rooted) continue;
            HashSet<Taxon> compl = new HashSet<Taxon>(leavesNames);
            compl.remove(lang);
            result.add(compl);
        }
        return result;
    }

    private PartialCoalescentState(List<Arbre<CoalescentNode>> roots, double topHeight, int nLeaves, CoalescentNode topNode, double oldLogLikelihood, Observations obs, boolean isClock, TaxonIndexedData data, Density<PhyloParticle> priorFct, List<Pair<Taxon, LikelihoodModelCalculator>> calculators, PhyloParticleInitContext context) {
        this.calculators = calculators;
        this.context = context;
        assert (topHeight == 0.0 && topNode == null || topNode.height == topHeight);
        this.roots = roots;
        this.topHeight = topHeight;
        this.nLeaves = nLeaves;
        this.topNode = topNode;
        this.oldLogLikelihood = oldLogLikelihood;
        this.obs = obs;
        this.isClock = isClock;
        this.data = data;
        this.priorFct = priorFct;
        if (priorFct != null) {
            this.logPrior = priorFct.logDensity(this);
        }
    }

    public PartialCoalescentState coalesce(int left, int right, double delta, double leftIncrement, double rightIncrement) {
        return this.coalesce(left, right, delta, leftIncrement, rightIncrement, null);
    }

    public PartialCoalescentState coalesce(int left, int right, double delta, double leftIncrement, double rightIncrement, Taxon newNode) {
        return (PartialCoalescentState)this.compute(left, right, delta, leftIncrement, rightIncrement, false, newNode);
    }

    public double peekLogLikelihoodRatio(int left, int right, double delta, double leftIncrement, double rightIncrement) {
        return (Double)this.compute(left, right, delta, leftIncrement, rightIncrement, true, null);
    }

    private Object compute(int left, int right, double delta, double leftIncrement, double rightIncrement, boolean isPeek, Taxon newNode) {
        boolean avoidBuildCache;
        if (this.isClock && (leftIncrement != 0.0 || rightIncrement != 0.0)) {
            throw new RuntimeException();
        }
        if (!this.isClock && leftIncrement + rightIncrement == 0.0) {
            throw new RuntimeException();
        }
        if (this.isFinalState()) {
            throw new RuntimeException();
        }
        CoalescentNode node1 = this.roots.get(left).getContents();
        CoalescentNode node2 = this.roots.get(right).getContents();
        double newTopHeight = delta + this.topHeight;
        double branch1 = newTopHeight - node1.height + leftIncrement;
        double branch2 = newTopHeight - node2.height + rightIncrement;
        if (isPeek) {
            double result = node1.likelihoodModelCache.peekCoalescedLogLikelihood(node1.likelihoodModelCache, node2.likelihoodModelCache, branch1, branch2);
            for (Arbre<CoalescentNode> root : this.roots) {
                CoalescentNode current = root.getContents();
                if (current == node1 || current == node2) continue;
                if (useExtendedLogLL) {
                    result += current.likelihoodModelCache.extendLogLikelihood(newTopHeight - current.height);
                    continue;
                }
                result += current.likelihoodModelCache.logLikelihood();
            }
            return result - this.logLikelihood();
        }
        boolean bl = avoidBuildCache = this.nIterationsLeft() == 1;
        if (alwaysComputeTopMessage) {
            avoidBuildCache = false;
        }
        return this.coalesce(left, right, node1.likelihoodModelCache.combine(node1.likelihoodModelCache, node2.likelihoodModelCache, branch1, branch2, avoidBuildCache), newTopHeight, branch1, branch2, newNode);
    }

    private PartialCoalescentState coalesce(int left, int right, LikelihoodModelCalculator contents, double newTopHeight, double branch1, double branch2, Taxon newNode) {
        ArrayList<Arbre<CoalescentNode>> result = new ArrayList<Arbre<CoalescentNode>>();
        for (int i = 0; i < this.roots.size(); ++i) {
            if (i == left || i == right) continue;
            result.add(this.roots.get(i));
        }
        Arbre<CoalescentNode> leftArbre = this.roots.get(left).copy();
        Arbre<CoalescentNode> rightArbre = this.roots.get(right).copy();
        HashSet union = CollUtils.set();
        union.addAll(leftArbre.getContents().rootedClade);
        union.addAll(rightArbre.getContents().rootedClade);
        Arbre<CoalescentNode> newArbre = Arbre.arbreWithChildren(new CoalescentNode(union, contents, newTopHeight, newNode == null ? new Taxon("internal_" + this.nRoots() + "_" + System.currentTimeMillis()) : newNode, branch1, branch2), leftArbre, rightArbre);
        result.add(newArbre);
        return new PartialCoalescentState(result, newTopHeight, this.nLeaves, newArbre.getContents(), this.logLikelihood(), this.obs, this.isClock, this.data, this.priorFct, this.calculators, this.context);
    }

    public Set<Taxon> mergedClade(int left, int right) {
        throw new RuntimeException();
    }

    public Set<Set<Taxon>> allClades() {
        throw new RuntimeException();
    }

    public Set<Taxon> rootedClade(int i) {
        return Collections.unmodifiableSet(this.roots.get((int)i).getContents().rootedClade);
    }

    public Set<Set<Taxon>> allRootedClades() {
        HashSet<Set<Taxon>> result = CollUtils.set();
        for (Arbre<CoalescentNode> root : this.roots) {
            PartialCoalescentState.allRootedClades(root, result);
        }
        return result;
    }

    private static void allRootedClades(Arbre<CoalescentNode> root, Set<Set<Taxon>> result) {
        result.add(root.getContents().rootedClade);
        for (Arbre<CoalescentNode> child : root.getChildren()) {
            PartialCoalescentState.allRootedClades(child, result);
        }
    }

    public Set<Taxon> clade(int i) {
        throw new RuntimeException();
    }

    @Deprecated
    public Observations getObservations() {
        return this.obs;
    }

    @Deprecated
    public int nCharacter(int site) {
        return this.getObservations().nCharacter(site);
    }

    @Deprecated
    public int nSites() {
        return this.getObservations().nSites();
    }

    public Map<Taxon, LikelihoodModelCalculator> getLeafLikelihoodModels() {
        HashMap<Taxon, LikelihoodModelCalculator> result = new HashMap<Taxon, LikelihoodModelCalculator>();
        for (Arbre<CoalescentNode> root : this.roots) {
            for (CoalescentNode leaf : root.leaveContents()) {
                result.put(leaf.nodeIdentifier, leaf.likelihoodModelCache);
            }
        }
        return result;
    }

    public Density<PhyloParticle> getPriorDensity() {
        return this.priorFct;
    }

    @Override
    public int generationIndex() {
        return this.nLeaves - this.roots.size();
    }

    public static class CoalescentNode {
        public final LikelihoodModelCalculator likelihoodModelCache;
        public final double height;
        public final double leftBranchLength;
        public final double rightBranchLength;
        public final Taxon nodeIdentifier;
        public final Set<Taxon> rootedClade;

        private CoalescentNode(Set<Taxon> rootedClade, LikelihoodModelCalculator likelihoodModelCache, double height, Taxon nodeIdentifier, double leftBranchLength, double rightBranchLength) {
            this.rootedClade = rootedClade;
            this.likelihoodModelCache = likelihoodModelCache;
            this.height = height;
            this.nodeIdentifier = nodeIdentifier;
            this.leftBranchLength = leftBranchLength;
            this.rightBranchLength = rightBranchLength;
        }

        public boolean isLeaf() {
            return this.height == 0.0;
        }
    }
}

