/*
 * Decompiled with CFR 0.152.
 */
package pty.smc.models;

import Jama.Matrix;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import ma.RateMatrixLoader;
import ma.SequenceType;
import nuts.math.RateMtxUtils;
import nuts.tui.Table;
import nuts.util.MathUtils;
import pty.ObservationDimensions;
import pty.smc.models.CachedEigenDecomp;

public interface CTMC
extends Serializable,
ObservationDimensions {
    public double[][] getTransitionPr(int var1, double var2);

    public double[] getInitialDistribution(int var1);

    public CachedEigenDecomp getRateMtx(int var1);

    public boolean isSiteTied();

    public static final class SimpleCTMC
    implements CTMC {
        private static final long serialVersionUID = 1L;
        private final CachedEigenDecomp Q;
        private final Matrix originalQ;
        private final double[] statDistn;
        private final int nSites;

        public static SimpleCTMC dnaCTMC(int nSites) {
            return new SimpleCTMC(RateMatrixLoader.k2p(), nSites);
        }

        public static SimpleCTMC dnaCTMC(int nSites, double trans2tranv) {
            return new SimpleCTMC(RateMatrixLoader.k2p(trans2tranv), nSites);
        }

        public static SimpleCTMC proteinCTMC(int nSites) {
            return new SimpleCTMC(RateMatrixLoader.dayhoff(), nSites);
        }

        public static SimpleCTMC fromSequenceType(int nSites, SequenceType st, double scale) {
            if (st == SequenceType.BINARY) {
                double[][] rate = new double[][]{{-scale, scale}, {scale, -scale}};
                return new SimpleCTMC(rate, nSites);
            }
            throw new RuntimeException();
        }

        public SimpleCTMC(double[][] rate, int nSites) {
            this.nSites = nSites;
            this.originalQ = new Matrix(rate);
            this.Q = new CachedEigenDecomp(this.originalQ.eig());
            this.statDistn = RateMtxUtils.getStationaryDistribution(rate);
            MathUtils.checkIsProb(this.statDistn);
        }

        @Override
        public double[] getInitialDistribution(int site) {
            return this.statDistn;
        }

        @Override
        public double[][] getTransitionPr(int site, double t) {
            return RateMtxUtils.marginalTransitionMtx(this.Q.getV(), this.Q.getVinv(), this.Q.getD(), t);
        }

        @Override
        public int nCharacter(int site) {
            return this.statDistn.length;
        }

        @Override
        public int nSites() {
            return this.nSites;
        }

        @Override
        public CachedEigenDecomp getRateMtx(int site) {
            return this.Q;
        }

        public String toString() {
            return "SimpleCTMC:\n" + Table.toString(this.originalQ);
        }

        @Override
        public boolean isSiteTied() {
            return true;
        }
    }

    public static final class GeneralCTMC
    implements CTMC {
        private static final long serialVersionUID = 1L;
        private final List<CachedEigenDecomp> Qs = new ArrayList<CachedEigenDecomp>();
        private final List<Matrix> originalQs = new ArrayList<Matrix>();
        private final List<double[]> statDistn = new ArrayList<double[]>();

        public GeneralCTMC(List<double[][]> Qs) {
            for (double[][] Q : Qs) {
                this.originalQs.add(new Matrix(Q));
                double[] stat = RateMtxUtils.getStationaryDistribution(Q);
                MathUtils.checkIsProb(stat);
                this.statDistn.add(stat);
                this.Qs.add(new CachedEigenDecomp(new Matrix(Q).eig()));
            }
        }

        @Override
        public double[] getInitialDistribution(int site) {
            return this.statDistn.get(site);
        }

        @Override
        public double[][] getTransitionPr(int site, double t) {
            return RateMtxUtils.marginalTransitionMtx(this.Qs.get(site).getV(), this.Qs.get(site).getVinv(), this.Qs.get(site).getD(), t);
        }

        @Override
        public int nCharacter(int site) {
            return this.statDistn.get(site).length;
        }

        @Override
        public int nSites() {
            return this.Qs.size();
        }

        @Override
        public CachedEigenDecomp getRateMtx(int site) {
            return this.Qs.get(site);
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("GeneralCTMC:\n");
            for (int i = 0; i < this.nSites(); ++i) {
                result.append("Site " + i + ":\n" + Table.toString(this.originalQs.get(i)) + "\n");
            }
            return result.toString();
        }

        @Override
        public boolean isSiteTied() {
            return false;
        }
    }
}

