/*
 * Decompiled with CFR 0.152.
 */
package sage;

import fig.basic.StrUtils;
import goblin.HLParams;
import goblin.Taxon;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import nuts.io.IO;
import nuts.lang.StringUtils;
import nuts.maxent.LabeledInstance;
import nuts.util.Counter;
import pepper.Encodings;

public class RegexFeatureTemplate {
    private final List<Pattern> patterns;

    public RegexFeatureTemplate(List<Pattern> patterns) {
        this.patterns = new ArrayList<Pattern>(patterns);
    }

    public static RegexFeatureTemplate load(File file) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String line : IO.i(file)) {
            patterns.add(Pattern.compile(line));
        }
        return new RegexFeatureTemplate(patterns);
    }

    public void extractFeatures(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance, Counter<Object> features) {
        String instanceStr = RegexFeatureTemplate.format(instance);
        List<String> cMatch = null;
        for (Pattern p : this.patterns) {
            cMatch = StringUtils.multiSelectFirstRegex(p, instanceStr);
            if (cMatch == null) continue;
            features.incrementCount(StrUtils.join(cMatch), 1.0);
        }
    }

    private static String format(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance) {
        String string = HLParams.format(instance);
        return string.substring(1, string.length() - 1);
    }

    public void debug(Collection<Taxon> allLanguages) {
        Counter<String> patternUsage = new Counter<String>();
        for (Taxon lang : allLanguages) {
            for (HLParams.HLContext ctxt : HLParams.allHLContexts(Encodings.getGlobalEncodings(), lang)) {
                for (HLParams.HLOutcome out : ctxt.allOutcomes()) {
                    String instanceStr = RegexFeatureTemplate.format(new LabeledInstance<HLParams.HLContext, HLParams.HLOutcome>(out, ctxt));
                    for (Pattern p : this.patterns) {
                        if (StringUtils.multiSelectFirstRegex(p, instanceStr) == null) continue;
                        patternUsage.incrementCount(p.toString(), 1.0);
                    }
                }
            }
        }
        for (Pattern p : this.patterns) {
            if (patternUsage.getCount(p.toString()) != 0.0) continue;
            throw new RuntimeException("Rule never occurs (syntax error?):" + p.toString());
        }
    }
}

