/*
 * Decompiled with CFR 0.152.
 */
package boot;

import boot.BootstrapRandom;
import fig.basic.Option;
import java.util.ArrayList;
import java.util.Random;
import nuts.io.IO;
import nuts.util.CollUtils;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.stat.regression.GLSMultipleLinearRegression;

public class TestBootstrap
implements Runnable {
    @Option(required=true)
    public int machineId;
    @Option(required=true)
    public int numMachines;
    @Option(required=true)
    public int n;
    @Option(required=true)
    public int d;
    @Option(required=true)
    public Random rand1 = new Random(1L);
    @Option
    public double errorSigma = 10.0;
    public Random rand2 = new Random(51790537L);
    public ArrayList<RealVector> X = CollUtils.list();
    public boolean sampleGenerated = false;
    public ArrayList<Double> errors = CollUtils.list();
    public boolean errorGenerated = false;
    public BootstrapRandom bRandom;

    @Override
    public void run() {
        this.bRandom = new BootstrapRandom(this.machineId, this.n, this.rand1, this.rand2);
        this.generateSamples();
        this.generateErrors();
        GLSMultipleLinearRegression regression = new GLSMultipleLinearRegression();
    }

    private ArrayList<RealVector> generateSamples() {
        if (!this.sampleGenerated) {
            for (int i = 0; i < this.n; ++i) {
                ArrayRealVector vect = new ArrayRealVector(this.d);
                for (int j = 0; j < this.d; ++j) {
                    vect.append(this.bRandom.nextGaussian());
                }
                this.X.add((RealVector)vect);
                this.sampleGenerated = true;
            }
        }
        return this.X;
    }

    private ArrayList<Double> generateErrors() {
        if (!this.errorGenerated) {
            for (int i = 0; i < this.n; ++i) {
                this.errors.add(this.bRandom.nextGaussian(0.0, this.errorSigma));
            }
        }
        return this.errors;
    }

    public static void main(String[] args) {
        IO.run(args, new TestBootstrap());
    }
}

