/*
 * Decompiled with CFR 0.152.
 */
package conifer.apps;

import conifer.apps.AllPhyloOptions;
import conifer.apps.PhyloAppUtils;
import conifer.data.PhylogeneticData;
import conifer.exp.Experiment;
import conifer.particle.FiniteGenerationParticle;
import conifer.particle.PhyloParticle;
import fig.basic.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import monaco.StandardKernel;
import monaco.mcmc.MCAlgorithm;
import monaco.process.Monitor;
import monaco.process.ProcessSchedule;
import monaco.process.ProcessScheduleContext;
import nuts.io.OutputProducer;
import nuts.io.SimpleOutputProducer;
import nuts.util.CollUtils;
import pty.smc.ParticleFilter;

public abstract class AbstractPhyloApp
implements Runnable,
Monitor,
OutputProducer {
    public final AllPhyloOptions allOptions = new AllPhyloOptions();
    public final SimpleOutputProducer producer = new SimpleOutputProducer();
    private List<Experiment> experiments = null;
    private PhylogeneticData dataBeforeHeldout;
    private PhylogeneticData dataAfterHeldout = null;

    public StandardKernel<PhyloParticle> getKernel() {
        this.getData();
        this.allOptions.proposalOptions.nested = this.allOptions.proposalOptions2;
        StandardKernel<PhyloParticle> result = PhyloAppUtils.getKernel(this.allOptions.heatOptions, this.dataBeforeHeldout, this.dataAfterHeldout, this.allOptions.inferenceEvolutionaryOptions, this.allOptions.calculatorOptions, this.allOptions.inferenceTreeOptions, this.allOptions.proposalOptions, this.producer.getOutputFolder());
        if (result.getInitial() instanceof FiniteGenerationParticle) {
            int nGenLeft = ((FiniteGenerationParticle)((Object)result.getInitial())).nGenerationsLeft();
            this.allOptions.processOptions.burnIn = Math.max(this.allOptions.processOptions.burnIn, nGenLeft);
        }
        return result;
    }

    @Override
    public void setOutputFolder(File f) {
        this.producer.setOutputFolder(f);
    }

    public MCAlgorithm<PhyloParticle> getMCAlgorithm() {
        MCAlgorithm<PhyloParticle> result = PhyloAppUtils.getMCAlgorithm(this.getKernel(), this.getProcessors(), this.allOptions.processOptions, this, this.allOptions.mcOptions);
        if (result instanceof OutputProducer) {
            File subDir = new File(this.producer.getOutputFolder(), "mc-algorithm");
            subDir.mkdir();
            ((OutputProducer)((Object)result)).setOutputFolder(subDir);
        }
        return result;
    }

    public ProcessSchedule getProcessSchedule() {
        return this.allOptions.processOptions.getSchedule(this);
    }

    public List<ParticleFilter.ParticleProcessor<PhyloParticle>> getProcessors() {
        this.getData();
        ArrayList<ParticleFilter.ParticleProcessor<PhyloParticle>> processors = CollUtils.list();
        for (Experiment exp : this.experiments) {
            processors.add(exp.getProcessor());
        }
        return processors;
    }

    public PhylogeneticData getData() {
        if (this.dataLoaded()) {
            return this.dataAfterHeldout;
        }
        this.allOptions.scrambleRandoms();
        Pair<Pair<PhylogeneticData, PhylogeneticData>, List<Experiment>> preparedData = PhyloAppUtils.prepareData(this.allOptions.dataOptions, this.allOptions.experimentOptions, this.producer.getOutputFolder());
        this.dataBeforeHeldout = preparedData.getFirst().getFirst();
        this.dataAfterHeldout = preparedData.getFirst().getSecond();
        this.experiments = preparedData.getSecond();
        return this.dataAfterHeldout;
    }

    @Override
    public void monitor(ProcessScheduleContext context) {
        this.monitorExperiments("generation", context.getGeneration());
    }

    public void monitorExperiments(Object ... context) {
        for (Experiment exp : this.experiments) {
            exp.monitor(context);
        }
    }

    public boolean dataLoaded() {
        return this.dataAfterHeldout != null;
    }

    public List<Experiment> getExperiments() {
        return this.experiments;
    }
}

