/*
 * Decompiled with CFR 0.152.
 */
package conifer.exp;

import conifer.data.PhylogeneticData;
import conifer.exp.Experiment;
import conifer.exp.ExperimentOptions;
import conifer.exp.MSAInferenceExperiment;
import conifer.exp.ParamExperiment;
import conifer.exp.PrepareExperimentsContext;
import conifer.exp.TreeReconstructionExperiment;

public enum ExperimentalSetup {
    PARAM_MONITOR{

        @Override
        public Experiment prepareExperiment(PhylogeneticData data, ExperimentOptions options, PrepareExperimentsContext context) {
            return new ParamExperiment(data, options, context);
        }
    }
    ,
    MSA_HELDOUT{

        @Override
        public Experiment prepareExperiment(PhylogeneticData data, ExperimentOptions options, PrepareExperimentsContext context) {
            return new MSAInferenceExperiment(data, options, context);
        }
    }
    ,
    TREE_HELDOUT{

        @Override
        public Experiment prepareExperiment(PhylogeneticData data, ExperimentOptions options, PrepareExperimentsContext context) {
            return new TreeReconstructionExperiment(data, options, context);
        }
    };


    public abstract Experiment prepareExperiment(PhylogeneticData var1, ExperimentOptions var2, PrepareExperimentsContext var3);
}

