/*
 * Decompiled with CFR 0.152.
 */
package conifer.particle;

import conifer.Phylogeny;
import conifer.data.TaxonIndexedData;
import conifer.evol.EvolutionaryParameters;
import conifer.particle.TreeProvider;
import conifer.proposals.ProposalOptions;
import java.io.File;
import ma.MSAPoset;
import nuts.io.OutputProducer;
import nuts.io.SimpleOutputProducer;

public class PhyloParticleInitContext {
    private final TaxonIndexedData taxonIndexedData;
    private final TreeProvider treeProvider;
    private final MSAProvider msaProvider;
    private final EvolutionaryParameters parameters;
    public final ProposalOptions proposalOptions;

    public TaxonIndexedData getTaxonIndexedData() {
        return this.taxonIndexedData;
    }

    public Phylogeny getTree() {
        return this.treeProvider.getTree();
    }

    public MSAPoset getMSA() {
        return this.msaProvider.getMSA();
    }

    public PhyloParticleInitContext(TaxonIndexedData taxonIndexedData, TreeProvider treeProvider, MSAProvider msaProvider, EvolutionaryParameters parameters, ProposalOptions proposalOptions) {
        this.taxonIndexedData = taxonIndexedData;
        this.treeProvider = treeProvider;
        this.msaProvider = msaProvider;
        this.parameters = parameters;
        this.proposalOptions = proposalOptions;
    }

    public EvolutionaryParameters getParameters() {
        return this.parameters;
    }

    public static class SingletonMSAProvider
    implements MSAProvider,
    OutputProducer {
        public final MSAPoset msa;
        private SimpleOutputProducer output = new SimpleOutputProducer();

        public SingletonMSAProvider(MSAPoset msa) {
            this.msa = msa;
        }

        @Override
        public MSAPoset getMSA() {
            File f = new File(this.output.getOutputFolder(), "msa.fasta");
            this.msa.toFASTA(f);
            return this.msa;
        }

        @Override
        public void setOutputFolder(File f) {
            this.output.setOutputFolder(f);
        }
    }

    public static interface MSAProvider {
        public MSAPoset getMSA();
    }
}

