/*
 * Decompiled with CFR 0.152.
 */
package ev.par;

import ev.par.FeatureExtractor;
import goblin.Taxon;
import java.util.ArrayList;
import java.util.Arrays;
import ma.BalibaseCorpus;
import ma.MultiAlignment;
import pepper.Encodings;

public class HydrophobicModeling {
    public static String visualize(HydrophobicHeuristic heuristic, String str) {
        int[] hydroIndicators = heuristic.compute(str);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            if (hydroIndicators[i] == 1) {
                result.append(Character.toLowerCase(str.charAt(i)));
                continue;
            }
            if (hydroIndicators[i] == 0) {
                result.append(Character.toUpperCase(str.charAt(i)));
                continue;
            }
            throw new RuntimeException();
        }
        return result.toString();
    }

    public static MultiAlignment visualize(HydrophobicHeuristic heuristic, MultiAlignment msa) {
        msa = msa.copy();
        ArrayList<Taxon> ls = new ArrayList<Taxon>(msa.getSequences().keySet());
        for (Taxon l : ls) {
            msa.changeString(l, HydrophobicModeling.visualize(heuristic, msa.getSequences().get(l)));
        }
        return msa;
    }

    public static void main(String[] args) {
        BalibaseCorpus.BalibaseCorpusOptions bco = new BalibaseCorpus.BalibaseCorpusOptions();
        bco.referenceAlignmentsPath = new ArrayList<String>(Arrays.asList("data/BAliBASE/ref5/test"));
        BalibaseCorpus bc = new BalibaseCorpus(bco);
        for (MultiAlignment msa : bc.getMultiAlignments().values()) {
            System.out.println(HydrophobicModeling.visualize((HydrophobicHeuristic)new ClustalHeuristics(), msa) + "\n\n");
        }
    }

    public static interface HydrophobicHeuristic {
        public int[] compute(String var1);
    }

    public static class ClustalHeuristics
    implements HydrophobicHeuristic {
        private final boolean useHydroIndex;
        private final FeatureExtractor.HydropathyDB db = null;

        public ClustalHeuristics() {
            this.useHydroIndex = false;
        }

        @Override
        public int[] compute(String s) {
            s = s.toUpperCase();
            int[] result = new int[s.length()];
            Arrays.fill(result, 1);
            int stretch = 0;
            for (int i = 0; i < s.length(); ++i) {
                if (this.isHydrophilic(s.charAt(i))) {
                    ++stretch;
                    continue;
                }
                ClustalHeuristics.apply(result, i, stretch);
                stretch = 0;
            }
            ClustalHeuristics.apply(result, s.length(), stretch);
            return result;
        }

        public boolean isHydrophilic(char c) {
            if (this.useHydroIndex) {
                return this.db.stats.getMean() > this.db.get(c);
            }
            return Encodings.HYDROPHILIC.contains(Character.valueOf(c));
        }

        private static void apply(int[] result, int current, int stretchLength) {
            if (stretchLength < 5) {
                return;
            }
            for (int i = 0; i < stretchLength; ++i) {
                result[current - i - 1] = 0;
            }
        }
    }
}

