/*
 * Decompiled with CFR 0.152.
 */
package ev.poi.proposals;

import ev.poi.PoissonModel;
import ev.poi.proposals.PoissonProposal;
import fig.basic.UnorderedPair;
import goblin.Taxon;
import java.util.Random;
import pty.RootedTree;
import pty.UnrootedTree;

public class RootingProposal
implements PoissonProposal {
    private RootedTree oldValue;
    private final PoissonModel model;

    public RootingProposal(PoissonModel model) {
        this.model = model;
    }

    @Override
    public double doProposal(Random rand, boolean maximize) {
        this.oldValue = this.model.currentRooted();
        RootedTree newRootedTree = this.model.currentUnrooted().reRoot(RootingProposal.nextRerooting(this.model.currentRooted(), rand, this.model.currentUnrooted()));
        this.model.setPhylogeneticTree(newRootedTree);
        return 0.0;
    }

    @Override
    public void undo() {
        this.model.setPhylogeneticTree(this.oldValue);
    }

    public static RootedTree.RootingInfo nextRerooting(RootedTree tree, Random rand, UnrootedTree nct) {
        Taxon curRoot = tree.topology().getContents();
        UnorderedPair<Taxon, Taxon> randomEdge = nct.randomEdge(rand);
        double randomRatio = rand.nextDouble();
        return new RootedTree.RootingInfo(randomEdge.getFirst(), randomEdge.getSecond(), curRoot, randomRatio);
    }

    @Override
    public String description() {
        return "RootingProposal";
    }
}

