/*
 * Decompiled with CFR 0.152.
 */
package ev.to;

import ev.poi.exp.MSAOutput;
import ev.poi.exp.PhylogeneticOutput;
import ev.poi.exp.PoissonSystem;
import ev.poi.exp.TreeOutput;
import ev.to.NJ;
import ev.to.PhyML;
import ev.to.PhyloTools;
import fig.basic.Option;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import ma.MSAParser;
import ma.MSAPoset;
import nuts.io.IO;
import nuts.util.CollUtils;
import nuts.util.IncrementalExperiment;
import pty.RootedTree;

public class ExternalTreeSystem
implements IncrementalExperiment.System {
    @Option
    public boolean initFromGoldAlignments = false;
    @Option
    public double minBL = 0.01;
    @Option
    public boolean useNJ = true;
    public static NJ nj = new NJ();
    public static PhyML phyML = new PhyML();

    @Override
    public void inference(IncrementalExperiment.InferenceContext context) {
        File workingDir = new File(context.getSystemDirectory(), "working-" + System.currentTimeMillis());
        workingDir.mkdir();
        PhyloTools pt = this.useNJ ? nj : phyML;
        pt.setWorkingDir(workingDir);
        MSAPoset msa = MSAParser.parseMSA(context.getInit(MSAOutput.MSA_OUTPUT));
        RootedTree.Util.RootedTreeImpl current = RootedTree.Util.incrementSmallBranches(pt.inferTree(msa.toMultiAlignmentObject()), this.minBL);
        IO.writeToDisk(context.getMainOutputFile(TreeOutput.TREE), RootedTree.Util.toNewick(current));
    }

    @Override
    public String name() {
        return this.useNJ ? "NJ" : "PhyML";
    }

    public static void main(String[] args) {
        ExternalTreeSystem system = new ExternalTreeSystem();
        IncrementalExperiment experiments = new IncrementalExperiment(system);
        experiments.outputTypeClassPackage = PhylogeneticOutput.class.getPackage().getName();
        IO.run(args, experiments, "system", system, "msa", PoissonSystem.externalMSASystem, "nj", nj, "phyml", phyML);
    }

    @Override
    public Map<IncrementalExperiment.OutputType, IncrementalExperiment.System> requiredInferenceInitializers() {
        HashMap<IncrementalExperiment.OutputType, IncrementalExperiment.System> result = CollUtils.map();
        if (this.initFromGoldAlignments) {
            result.put(MSAOutput.MSA_OUTPUT, PoissonSystem.RETURN_GIVEN_MSA);
        } else {
            result.put(MSAOutput.MSA_OUTPUT, PoissonSystem.externalMSASystem);
        }
        return result;
    }
}

